/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.pluginstuff;

import info.jdictionary.FileDownloader;
import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.JDictionary;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.gui.NetworkErrorPanel;
import info.jdictionary.gui.PluginInfoSheetPanel;
import info.jdictionary.listeners.PluginStructureChangeListener;
import info.jdictionary.pluginstuff.PluginDeployer;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class PluginDownloader
extends JPanel
implements Runnable {
    JDictionary jDictionary;
    PluginManager pluginManager;
    ArrayList pluginInfoPanels = new ArrayList();
    PluginInfoAndDownloadPanel highlightedPluginInfoPanel;
    HashSet downloadQuene = new HashSet();
    JPanel availablePluginsPanel = new JPanel();
    JPanel pluginInfoOutputPanel = new JPanel();
    JPanel tipsPanel = new JPanel();
    JPanel informationPanel = new JPanel();
    JLabel headerLabel = new JLabel();
    JLabel messageLabel;
    ImageIcon spacerLine = ImageBank.getImageByName("Spacer.jpg");
    ImageIcon headerImage = ImageBank.getImageByName("DownloadHeader.png");
    JScrollPane pluginInfoOutputScrollPane = new JScrollPane();
    JScrollPane informationScrollPane = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BoxLayout boxLayout1 = new BoxLayout(this, 1);
    BoxLayout boxLayout2 = new BoxLayout(this.pluginInfoOutputPanel, 1);
    BoxLayout boxLayout3 = new BoxLayout(this.informationPanel, 1);
    boolean success;

    public PluginDownloader(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        this.pluginManager = jDictionary.getPluginManager();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.boxLayout1);
        this.setBackground(Color.white);
        this.setAlignmentX(0.0f);
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.availablePluginsPanel.setLayout(this.borderLayout1);
        this.availablePluginsPanel.setBackground(Color.white);
        this.availablePluginsPanel.setAlignmentX(0.0f);
        this.availablePluginsPanel.setMinimumSize(new Dimension(300, 100));
        this.availablePluginsPanel.setPreferredSize(new Dimension(1000, 1000));
        this.availablePluginsPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("AvailPlugins")));
        this.availablePluginsPanel.add((Component)this.pluginInfoOutputScrollPane, "Center");
        this.tipsPanel.setBackground(Color.white);
        this.tipsPanel.setAlignmentX(0.0f);
        this.tipsPanel.setMinimumSize(new Dimension(0, 80));
        this.tipsPanel.setPreferredSize(new Dimension(0, 160));
        this.tipsPanel.setLayout(this.borderLayout3);
        this.tipsPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("Tips")));
        this.tipsPanel.add(this.informationScrollPane);
        this.headerLabel.setBackground(Color.white);
        this.headerLabel.setMinimumSize(new Dimension(300, 65));
        this.headerLabel.setPreferredSize(new Dimension(500, 65));
        this.headerLabel.setIcon(this.headerImage);
        this.pluginInfoOutputScrollPane.setHorizontalScrollBarPolicy(31);
        this.pluginInfoOutputScrollPane.getViewport().setBackground(Color.white);
        this.informationScrollPane.setHorizontalScrollBarPolicy(31);
        this.informationScrollPane.getViewport().add((Component)this.informationPanel, null);
        this.pluginInfoOutputScrollPane.getViewport().add((Component)this.pluginInfoOutputPanel, null);
        this.pluginInfoOutputPanel.setBackground(Color.white);
        this.pluginInfoOutputPanel.setLayout(this.borderLayout2);
        this.informationPanel.setLayout(this.boxLayout3);
        this.informationPanel.setBackground(Color.white);
        this.addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip1"), IconBank.bulb, 0));
        this.addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip2"), IconBank.bulb, 0));
        this.add((Component)this.headerLabel, null);
        this.add((Component)this.availablePluginsPanel, null);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add((Component)this.tipsPanel, null);
    }

    public void run() {
        this.addToOutputPanel(JDictionary.getString("DownloadingInfo"), IconBank.hourGlass);
        Object[] sheets = this.downloadPluginInfoSheets();
        if (sheets != null) {
            this.showPluginInfoPanels(sheets);
            this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("AvailPluginsPref")))).append(sheets.length).append(JDictionary.getString("AvailPluginsPostf")))), IconBank.info, 0));
            this.success = true;
            this.checkDownloadQuene();
        } else {
            this.addToOutputPanel(JDictionary.getString("NetError"), IconBank.caution);
            this.addToInformationPanel(new NetworkErrorPanel(this.jDictionary));
            this.addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip3"), IconBank.bulb, 0));
        }
    }

    Object[] downloadPluginInfoSheets() {
        URL url = null;
        Object[] sheets = null;
        try {
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("SourceforgeDownloadServerURL")))).append("/").append(JDictionary.getString("InfoSheetsFile")).append("_").append(JDictionary.getLanguage()))));
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null) {
                Object[] objectArray = sheets;
                return objectArray;
            }
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("SourceforgeDownloadServerURL")))).append("/").append(JDictionary.getString("InfoSheetsFile")))));
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null) {
                Object[] objectArray = sheets;
                return objectArray;
            }
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("InfoSheetsFile")).append("_").append(JDictionary.getLanguage()))));
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null) {
                Object[] objectArray = sheets;
                return objectArray;
            }
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("InfoSheetsFile")))));
            sheets = PluginInfoSheet.CreateInfoSheets(url);
            if (sheets != null) {
                Object[] objectArray = sheets;
                return objectArray;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return sheets;
    }

    void showPluginInfoPanels(final Object[] sheets) {
        for (int n = 0; n < sheets.length; ++n) {
            PluginInfoAndDownloadPanel pluginInfoAndDownloadPanel = new PluginInfoAndDownloadPanel(this.jDictionary, (PluginInfoSheet)sheets[n]);
            this.pluginInfoPanels.add(pluginInfoAndDownloadPanel);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloader.this.pluginInfoOutputPanel.removeAll();
                PluginDownloader.this.pluginInfoOutputPanel.setLayout(PluginDownloader.this.boxLayout2);
                for (int n = 0; n < PluginDownloader.this.pluginInfoPanels.size(); ++n) {
                    PluginDownloader.this.pluginInfoOutputPanel.add((PluginInfoAndDownloadPanel)PluginDownloader.this.pluginInfoPanels.get(n));
                    if (n >= sheets.length - 1) continue;
                    JLabel spacer = new JLabel(PluginDownloader.this.spacerLine);
                    spacer.setPreferredSize(new Dimension(200, 1));
                    PluginDownloader.this.pluginInfoOutputPanel.add(spacer);
                }
                PluginDownloader.this.pluginInfoOutputPanel.validate();
                PluginDownloader.this.pluginInfoOutputScrollPane.validate();
                PluginDownloader.this.pluginInfoOutputPanel.repaint();
            }
        });
    }

    void addToInformationPanel(final JComponent label) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                label.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
                PluginDownloader.this.informationPanel.add(label);
                PluginDownloader.this.informationScrollPane.validate();
                PluginDownloader.this.informationScrollPane.repaint();
                PluginDownloader.this.showComponentOnScrollPane(PluginDownloader.this.informationScrollPane, label, false);
            }
        });
    }

    public void updateInfoPanelsState() {
        for (int n = 0; n < this.pluginInfoPanels.size(); ++n) {
            ((PluginInfoAndDownloadPanel)this.pluginInfoPanels.get(n)).updateState();
        }
    }

    public void addToOutputPanel(String message, ImageIcon icon) {
        this.messageLabel = new JLabel(message, icon, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloader.this.pluginInfoOutputPanel.removeAll();
                PluginDownloader.this.pluginInfoOutputPanel.add(PluginDownloader.this.messageLabel);
                PluginDownloader.this.pluginInfoOutputPanel.validate();
            }
        });
    }

    public void addToOutputPanel(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginDownloader.this.pluginInfoOutputPanel.removeAll();
                PluginDownloader.this.pluginInfoOutputPanel.add(component);
                PluginDownloader.this.pluginInfoOutputPanel.validate();
            }
        });
    }

    public void download(String fileName) {
        if (!this.success) {
            this.downloadQuene.add(fileName);
            return;
        }
        if (this.pluginInfoPanels != null && this.pluginInfoPanels.size() > 0) {
            Iterator it = ((AbstractList)this.pluginInfoPanels).iterator();
            while (it.hasNext()) {
                PluginInfoAndDownloadPanel p = (PluginInfoAndDownloadPanel)it.next();
                if (!p.getSheet().getFileName().equals(fileName)) continue;
                if (!p.downloading) {
                    p.startDownload();
                }
                this.showComponentOnScrollPane(this.pluginInfoOutputScrollPane, p, true);
                p.highlight(10000);
                return;
            }
        }
    }

    void checkDownloadQuene() {
        if (this.downloadQuene.size() > 0) {
            Iterator it = this.downloadQuene.iterator();
            while (it.hasNext()) {
                this.download((String)it.next());
            }
            this.downloadQuene.clear();
        }
    }

    void showComponentOnScrollPane(final JScrollPane scrollPane, final JComponent component, boolean highlight) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Point point = new Point(component.getX(), component.getY());
                scrollPane.getViewport().setViewPosition(point);
                scrollPane.validate();
                scrollPane.repaint();
            }
        });
    }

    public boolean isSuccess() {
        return this.success;
    }

    class PluginInfoAndDownloadPanel
    extends JPanel {
        JDictionary jDictionary;
        boolean downloading = false;
        boolean activated = true;
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        BoxLayout boxLayout1 = new BoxLayout(this, 0);
        BoxLayout boxLayout2 = new BoxLayout(this.jPanel1, 1);
        BoxLayout boxLayout3 = new BoxLayout(this.jPanel3, 1);
        JButton button = new JButton();
        int highlightCounter = 0;
        PluginInfoSheet sheet;
        PluginInfoSheetPanel sheetPanel;
        Downloader downloader;
        JProgressBar progressBar;

        public PluginInfoAndDownloadPanel(JDictionary jDictionary, PluginInfoSheet sheet) {
            this.jDictionary = jDictionary;
            this.sheet = sheet;
            this.sheetPanel = new PluginInfoSheetPanel(sheet);
            PluginDownloader.this.pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener(this){
                private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void pluginAdded(PluginStructureChangeEvent e) {
                    this.this$1.updateState();
                }

                public void pluginRemoved(PluginStructureChangeEvent e) {
                    this.this$1.updateState();
                }
            });
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateState();
        }

        private void jbInit() throws Exception {
            this.setBackground(Color.white);
            this.setPreferredSize(new Dimension(370, 85));
            this.setMinimumSize(new Dimension(300, 85));
            this.setLayout(this.boxLayout1);
            this.setBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3));
            this.setAlignmentX(0.0f);
            this.jPanel1.setBackground(new Color(255, 255, 255));
            this.jPanel1.setPreferredSize(new Dimension(160, 55));
            this.jPanel1.setLayout(this.boxLayout2);
            this.jPanel2.setBackground(new Color(255, 255, 255));
            this.jPanel3.setBackground(new Color(255, 255, 255));
            this.jPanel3.setAlignmentX(0.0f);
            this.jPanel3.setLayout(this.boxLayout3);
            this.jScrollPane1.setPreferredSize(new Dimension(300, 70));
            this.jScrollPane1.setMinimumSize(new Dimension(100, 70));
            this.button.setAlignmentX(0.0f);
            this.button.setMargin(new Insets(0, 3, 0, 3));
            this.button.addActionListener(new ActionListener(this){
                private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.button_actionPerformed(e);
                }
            });
            this.jPanel1.add(this.jPanel3);
            this.jPanel1.add(Box.createVerticalGlue());
            this.jPanel1.add(this.button);
            this.jPanel2.add(this.jPanel1);
            this.add(this.jScrollPane1);
            this.add(this.jPanel2);
            this.jScrollPane1.getViewport().add((Component)this.sheetPanel, 0);
        }

        PluginInfoSheet getSheet() {
            return this.sheet;
        }

        void startDownload() {
            if (!this.activated) {
                this.jDictionary.getPluginManager().setActive(this.sheet.getFileName());
                PluginDownloader.this.pluginManager.scanPlugins();
                return;
            }
            if (this.downloading) {
                this.downloading = false;
                this.downloader.terminate();
                return;
            }
            if (this.jDictionary.getPluginManager().isItAvailable(this.sheet.getFileName(), true)) {
                return;
            }
            PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("DownloadingFile"))).concat(String.valueOf(String.valueOf(this.sheet.getName()))), IconBank.FolderIn, 0));
            this.downloading = true;
            this.showProgressBar();
            this.downloader = new Downloader();
            this.downloader.start();
            this.updateState();
        }

        void showProgressBar() {
            this.progressBar = new JProgressBar();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.progressBar.setPreferredSize(new Dimension(this.this$1.button.getWidth(), this.this$1.button.getHeight()));
                    this.this$1.progressBar.setStringPainted(true);
                    this.this$1.jPanel3.removeAll();
                    this.this$1.jPanel3.add(this.this$1.progressBar);
                    this.this$1.jPanel1.validate();
                    this.this$1.jPanel1.repaint();
                }
            });
        }

        synchronized void updateState() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (this.this$1.downloading) {
                        this.this$1.button.setIcon(IconBank.stop);
                        this.this$1.button.setText(JDictionary.getString("StopDownloading"));
                        return;
                    }
                    this.this$1.jPanel3.removeAll();
                    this.this$1.activated = true;
                    if (this.this$1.sheet.getMinJDictionaryVersion() != null && Float.parseFloat(this.this$1.sheet.getMinJDictionaryVersion()) > JDictionary.getJDictionaryVersion()) {
                        JLabel label = new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("JDict")))).append(this.this$1.sheet.getMinJDictionaryVersion()).append(JDictionary.getString("Needed")))), IconBank.info, 0);
                        label.setToolTipText(String.valueOf(String.valueOf(JDictionary.getString("PleseUpgr"))).concat(String.valueOf(String.valueOf(this.this$1.sheet.getMinJDictionaryVersion()))));
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setToolTipText(String.valueOf(String.valueOf(JDictionary.getString("PleseUpgr"))).concat(String.valueOf(String.valueOf(this.this$1.sheet.getMinJDictionaryVersion()))));
                        this.this$1.button.setText(JDictionary.getString("DownInst"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(false);
                    } else if (PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)this.this$1).pluginManager.isPluginFileLoadedWithName(this.this$1.sheet.getFileName())) {
                        JLabel label = new JLabel(JDictionary.getString("AlreadyInstalled"), IconBank.info, 0);
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setText(JDictionary.getString("DownInst"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(false);
                    } else if (PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)this.this$1).pluginManager.isItAvailable(this.this$1.sheet.getFileName(), true)) {
                        this.this$1.activated = false;
                        JLabel label = new JLabel(JDictionary.getString("InstalledButDeactivated"), IconBank.info, 0);
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setText(JDictionary.getString("Activate"));
                        this.this$1.button.setIcon(IconBank.plug);
                        this.this$1.button.setEnabled(true);
                    } else if (PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)this.this$1).pluginManager.isItAvailable(this.this$1.sheet.getFileName(), false) && PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)this.this$1).pluginManager.isThereNewerPluginFileAvailable(this.this$1.sheet.getFileName())) {
                        JLabel label = new JLabel(JDictionary.getString("YouHaveNewerVersion"), IconBank.info, 0);
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setText(JDictionary.getString("DownInst"));
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(false);
                    } else {
                        JLabel label;
                        if (PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)this.this$1).pluginManager.isItAvailable(this.this$1.sheet.getFileName(), false) && !PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)this.this$1).pluginManager.isThereNewerPluginFileAvailable(this.this$1.sheet.getFileName())) {
                            label = new JLabel(JDictionary.getString("NewerAvailable"), IconBank.FingerUp, 0);
                            this.this$1.button.setText(JDictionary.getString("DownUpgr"));
                        } else {
                            label = new JLabel(JDictionary.getString("NotInstalled"), IconBank.info, 0);
                            this.this$1.button.setText(JDictionary.getString("DownInst"));
                        }
                        this.this$1.jPanel3.add(label);
                        this.this$1.button.setIcon(IconBank.FolderIn);
                        this.this$1.button.setEnabled(true);
                    }
                    this.this$1.jPanel1.validate();
                    this.this$1.jPanel1.repaint();
                }
            });
        }

        void button_actionPerformed(ActionEvent e) {
            this.startDownload();
        }

        void highlight(boolean highlight) {
            this.highlightCounter = highlight ? ++this.highlightCounter : --this.highlightCounter;
            if (this.highlightCounter > 0) {
                if (!this.getBackground().equals(Color.orange)) {
                    this.setBackground(Color.orange);
                }
                return;
            }
            if (this.highlightCounter <= 0) {
                if (!this.getBackground().equals(Color.white)) {
                    this.setBackground(Color.white);
                }
                return;
            }
        }

        void highlight(int time) {
            this.highlight(true);
            new Thread(this, time){
                private final /* synthetic */ int val$time;
                private final /* synthetic */ PluginInfoAndDownloadPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$time = val$time;
                }

                public void run() {
                    try {
                        Thread.sleep(this.val$time);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.this$1.highlight(false);
                }
            }.start();
        }

        class Downloader
        extends Thread {
            FileDownloader fileDownloader = new FileDownloader();
            PluginDeployer deployer;
            byte[] b;
            boolean stop;
            URL url;

            Downloader() {
                this.deployer = new PluginDeployer(PluginInfoAndDownloadPanel.this.jDictionary);
                this.stop = false;
                this.url = null;
            }

            public void terminate() {
                this.fileDownloader.terminate();
                PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("DownStopPref")))).append(PluginInfoAndDownloadPanel.this.sheet.getName()).append(JDictionary.getString("DownStopPost")))), IconBank.stop, 0));
                this.stop = true;
                PluginInfoAndDownloadPanel.this.updateState();
            }

            public void run() {
                try {
                    this.url = new URL(PluginInfoAndDownloadPanel.this.sheet.getURL());
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.b = this.fileDownloader.download(this.url, PluginInfoAndDownloadPanel.this.progressBar);
                if (!this.stop) {
                    if (this.b != null) {
                        PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("Installing"))).concat(String.valueOf(String.valueOf(PluginInfoAndDownloadPanel.this.sheet.getName()))), IconBank.info, 0));
                        PluginInfoAndDownloadPanel.this.button.setEnabled(false);
                        this.deployer.deploy(this.b, PluginInfoAndDownloadPanel.this.sheet.getFileName());
                        ((PluginInfoAndDownloadPanel)PluginInfoAndDownloadPanel.this).PluginDownloader.this.pluginManager.setActive(PluginInfoAndDownloadPanel.this.sheet.getFileName());
                        ((PluginInfoAndDownloadPanel)PluginInfoAndDownloadPanel.this).PluginDownloader.this.pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener(this){
                            private final /* synthetic */ Downloader this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void pluginRemoved(PluginStructureChangeEvent e) {
                            }

                            public void pluginAdded(PluginStructureChangeEvent e) {
                                if (PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)Downloader.access$1((Downloader)this.this$2)).pluginManager.isItInstalled(Downloader.access$1((Downloader)this.this$2).sheet)) {
                                    PluginInfoAndDownloadPanel.access$0(Downloader.access$1(this.this$2)).addToInformationPanel(new JLabel(String.valueOf(String.valueOf(Downloader.access$1((Downloader)this.this$2).sheet.getName())).concat(String.valueOf(String.valueOf(JDictionary.getString("ReadyToUse")))), IconBank.ThumbUp, 0));
                                } else {
                                    PluginInfoAndDownloadPanel.access$0(Downloader.access$1(this.this$2)).addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("ErrorAtInstall"))).concat(String.valueOf(String.valueOf(Downloader.access$1((Downloader)this.this$2).sheet.getName()))), IconBank.caution, 0));
                                }
                                PluginInfoAndDownloadPanel.access$0((PluginInfoAndDownloadPanel)Downloader.access$1((Downloader)this.this$2)).pluginManager.removePluginStructureChangeListener(this);
                                Downloader.access$1(this.this$2).updateState();
                            }
                        });
                        ((PluginInfoAndDownloadPanel)PluginInfoAndDownloadPanel.this).PluginDownloader.this.pluginManager.scanPlugins();
                    } else {
                        PluginDownloader.this.addToInformationPanel(new JLabel(String.valueOf(String.valueOf(JDictionary.getString("ErrorAtDownload"))).concat(String.valueOf(String.valueOf(PluginInfoAndDownloadPanel.this.sheet.getName()))), IconBank.caution, 0));
                    }
                }
                PluginInfoAndDownloadPanel.this.downloading = false;
            }

            static /* synthetic */ PluginInfoAndDownloadPanel access$1(Downloader x$0) {
                return x$0.PluginInfoAndDownloadPanel.this;
            }
        }
    }
}

