/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.windows;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextShareSet;
import net.java.games.jogl.impl.JAWT_DrawingSurface;
import net.java.games.jogl.impl.JAWT_DrawingSurfaceInfo;
import net.java.games.jogl.impl.windows.JAWT_Win32DrawingSurfaceInfo;
import net.java.games.jogl.impl.windows.WGL;
import net.java.games.jogl.impl.windows.WindowsGLContext;
import net.java.games.jogl.impl.windows.WindowsGLImpl;
import net.java.games.jogl.impl.windows.WindowsPbufferGLContext;

public class WindowsOnscreenGLContext
extends WindowsGLContext {
    JAWT_DrawingSurface ds;
    JAWT_DrawingSurfaceInfo dsi;
    JAWT_Win32DrawingSurfaceInfo win32dsi;
    List pbuffersToInstantiate = new ArrayList();

    public WindowsOnscreenGLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(component, gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeGL(Runnable runnable, boolean bl, Runnable runnable2) throws GLException {
        if (this.hglrc == 0L) {
            Object object = this.component.getTreeLock();
            synchronized (object) {
                super.invokeGL(runnable, bl, runnable2);
            }
        } else {
            super.invokeGL(runnable, bl, runnable2);
        }
    }

    protected GL createGL() {
        return new WindowsGLImpl(this);
    }

    protected boolean isOffscreen() {
        return false;
    }

    public int getOffscreenContextBufferedImageType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public boolean canCreatePbufferContext() {
        return this.haveWGLARBPbuffer();
    }

    public synchronized GLContext createPbufferContext(GLCapabilities gLCapabilities, int n, int n2) {
        WindowsPbufferGLContext windowsPbufferGLContext = new WindowsPbufferGLContext(gLCapabilities, n, n2);
        this.pbuffersToInstantiate.add(windowsPbufferGLContext);
        return windowsPbufferGLContext;
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        try {
            if (!this.lockSurface()) {
                return false;
            }
            boolean bl = super.makeCurrent(runnable);
            if (bl) {
                while (!this.pbuffersToInstantiate.isEmpty()) {
                    WindowsPbufferGLContext windowsPbufferGLContext = (WindowsPbufferGLContext)this.pbuffersToInstantiate.remove(this.pbuffersToInstantiate.size() - 1);
                    windowsPbufferGLContext.createPbuffer(this.hdc, this.hglrc);
                }
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            try {
                this.unlockSurface();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void free() throws GLException {
        try {
            super.free();
        }
        finally {
            this.unlockSurface();
        }
    }

    public synchronized void swapBuffers() throws GLException {
        if (!WGL.SwapBuffers(this.hdc) && WGL.GetLastError() != 0) {
            throw new GLException("Error swapping buffers");
        }
    }

    private boolean lockSurface() throws GLException {
        if (this.hdc != 0L) {
            throw new GLException("Surface already locked");
        }
        this.ds = this.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            return false;
        }
        int n = this.ds.Lock();
        if ((n & 1) != 0) {
            throw new GLException("Unable to lock surface");
        }
        if ((n & 8) != 0 && this.hglrc != 0L) {
            if (!WGL.wglDeleteContext(this.hglrc)) {
                throw new GLException("Unable to delete old GL context after surface changed");
            }
            GLContextShareSet.contextDestroyed(this);
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.hglrc + " due to JAWT_LOCK_SURFACE_CHANGED");
            }
            this.hglrc = 0L;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.ds.Unlock();
            this.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            return false;
        }
        this.win32dsi = (JAWT_Win32DrawingSurfaceInfo)this.dsi.platformInfo();
        this.hdc = this.win32dsi.hdc();
        if (this.hdc == 0L) {
            this.ds.FreeDrawingSurfaceInfo(this.dsi);
            this.ds.Unlock();
            this.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            this.dsi = null;
            this.win32dsi = null;
            return false;
        }
        return true;
    }

    private void unlockSurface() {
        if (this.hdc == 0L) {
            throw new GLException("Surface already unlocked");
        }
        this.ds.FreeDrawingSurfaceInfo(this.dsi);
        this.ds.Unlock();
        this.getJAWT().FreeDrawingSurface(this.ds);
        this.ds = null;
        this.dsi = null;
        this.win32dsi = null;
        this.hdc = 0L;
    }

    protected void create() {
        this.choosePixelFormatAndCreateContext(true);
    }
}

