/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.windows;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.util.HashMap;
import java.util.Map;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.FunctionAvailabilityCache;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextShareSet;
import net.java.games.jogl.impl.JAWT;
import net.java.games.jogl.impl.JAWTFactory;
import net.java.games.jogl.impl.windows.GLProcAddressTable;
import net.java.games.jogl.impl.windows.PIXELFORMATDESCRIPTOR;
import net.java.games.jogl.impl.windows.WGL;
import net.java.games.jogl.impl.windows.WindowsGLContextFactory;
import net.java.games.jogl.impl.windows.WindowsGLImpl;

public abstract class WindowsGLContext
extends GLContext {
    private static JAWT jawt;
    protected long hglrc;
    protected long hdc;
    private boolean wglGetExtensionsStringEXTInitialized;
    private boolean wglGetExtensionsStringEXTAvailable;
    private static final Map functionNameMap;
    private static final Map extensionNameMap;
    private GLProcAddressTable glProcAddressTable;
    private long hglu32;
    private boolean haveWGLARBPbuffer = true;
    private static final int MAX_PFORMATS = 256;
    private static final int MAX_ATTRIBS = 256;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WindowsGLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(component, gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    protected GL createGL() {
        return new WindowsGLImpl(this);
    }

    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        String string2 = (String)extensionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract boolean isOffscreen();

    public abstract int getOffscreenContextBufferedImageType();

    public int getOffscreenContextWidth() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextHeight() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public abstract int getOffscreenContextReadBuffer();

    public abstract boolean offscreenImageNeedsVerticalFlip();

    protected abstract void create();

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        boolean bl = false;
        if (this.hglrc == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println("!!! Created GL context for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!WGL.wglMakeCurrent(this.hdc, this.hglrc)) {
            throw new GLException("Error making context current: " + WGL.GetLastError());
        }
        if (DEBUG) {
            System.err.println("wglMakeCurrent(hdc " + WindowsGLContext.hdcToString(this.hdc) + ", hglrc " + WindowsGLContext.hdcToString(this.hglrc) + ") succeeded");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            this.haveWGLARBPbuffer = this.isExtensionAvailable("WGL_ARB_pbuffer") && this.isExtensionAvailable("WGL_ARB_pixel_format");
            WindowsGLContext windowsGLContext = (WindowsGLContext)GLContextShareSet.getShareContext(this);
            if (windowsGLContext != null) {
                long l = windowsGLContext.getHGLRC();
                if (l == 0L) {
                    throw new GLException("GLContextShareSet returned an invalid OpenGL context");
                }
                if (!WGL.wglShareLists(l, this.hglrc)) {
                    throw new GLException("wglShareLists(0x" + Long.toHexString(l) + ", 0x" + Long.toHexString(this.hglrc) + ") failed: error code " + WGL.GetLastError());
                }
            }
            GLContextShareSet.contextCreated(this);
            runnable.run();
        }
        return true;
    }

    protected synchronized void free() throws GLException {
        if (!WGL.wglMakeCurrent(0L, 0L)) {
            throw new GLException("Error freeing OpenGL context: " + WGL.GetLastError());
        }
    }

    protected void destroyImpl() throws GLException {
        if (this.hglrc != 0L) {
            if (!WGL.wglDeleteContext(this.hglrc)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.hglrc);
            }
            this.hglrc = 0L;
        }
    }

    public abstract void swapBuffers() throws GLException;

    protected long dynamicLookupFunction(String string) {
        long l = WGL.wglGetProcAddress(string);
        if (l == 0L) {
            if (this.hglu32 == 0L) {
                this.hglu32 = WGL.LoadLibraryA("GLU32");
                if (this.hglu32 == 0L) {
                    throw new GLException("Error loading GLU32.DLL");
                }
            }
            l = WGL.GetProcAddress(this.hglu32, string);
        }
        return l;
    }

    public boolean isCreated() {
        return this.hglrc != 0L;
    }

    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println("!!! Initializing OpenGL extension address table");
        }
        this.resetProcAddressTable(this.getGLProcAddressTable());
    }

    public GLProcAddressTable getGLProcAddressTable() {
        if (this.glProcAddressTable == null) {
            this.glProcAddressTable = new GLProcAddressTable();
        }
        return this.glProcAddressTable;
    }

    public String getPlatformExtensionsString() {
        if (!this.wglGetExtensionsStringEXTInitialized) {
            this.wglGetExtensionsStringEXTAvailable = WGL.wglGetProcAddress("wglGetExtensionsStringEXT") != 0L;
            this.wglGetExtensionsStringEXTInitialized = true;
        }
        if (this.wglGetExtensionsStringEXTAvailable) {
            return this.gl.wglGetExtensionsStringEXT();
        }
        return "";
    }

    protected boolean isFunctionAvailable(String string) {
        boolean bl = super.isFunctionAvailable(string);
        if (!$assertionsDisabled && bl && this.getGLProcAddressTable().getAddressFor(this.mapToRealGLFunctionName(string)) == 0L && !FunctionAvailabilityCache.isPartOfGLCore("1.1", this.mapToRealGLFunctionName(string))) {
            throw new AssertionError();
        }
        return bl;
    }

    protected JAWT getJAWT() {
        if (jawt == null) {
            JAWT jAWT = new JAWT();
            jAWT.version(65540);
            if (!JAWTFactory.JAWT_GetAWT(jAWT)) {
                throw new RuntimeException("Unable to initialize JAWT");
            }
            jawt = jAWT;
        }
        return jawt;
    }

    protected void choosePixelFormatAndCreateContext(boolean bl) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = null;
        int n = 0;
        if (bl) {
            Object object;
            GLCapabilities[] gLCapabilitiesArray = null;
            int n2 = 0;
            pIXELFORMATDESCRIPTOR = WindowsGLContext.newPixelFormatDescriptor();
            GraphicsConfiguration graphicsConfiguration = this.component.getGraphicsConfiguration();
            GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
            GL gL = WindowsGLContextFactory.getDummyGL(graphicsDevice);
            int n3 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (gL != null && ((String)(object = WindowsGLContextFactory.getDummyGLExtensions(graphicsDevice))).indexOf("WGL_ARB_pixel_format") >= 0) {
                bl2 = true;
                if (((String)object).indexOf("WGL_ARB_multisample") >= 0) {
                    bl3 = true;
                }
            }
            object = graphicsConfiguration.getBounds();
            long l = 0L;
            long l2 = 0L;
            boolean bl4 = false;
            if (gL != null) {
                l = WindowsGLContextFactory.getDummyGLContext((GraphicsDevice)graphicsDevice).hdc;
                l2 = WindowsGLContextFactory.getDummyGLContext((GraphicsDevice)graphicsDevice).hglrc;
                if (!WGL.wglMakeCurrent(l, l2)) {
                    System.err.println("Error Making WGLC Current: " + WGL.GetLastError());
                } else {
                    bl4 = true;
                }
            }
            boolean bl5 = false;
            if (gL != null && bl2) {
                int n4;
                int[] nArray;
                int[] nArray2;
                int[] nArray3 = new int[512];
                int[] nArray4 = new int[512];
                float[] fArray = new float[512];
                int n5 = 0;
                boolean bl6 = false;
                nArray3[n5++] = 8208;
                nArray3[n5++] = 1;
                nArray3[n5++] = 8193;
                nArray3[n5++] = 1;
                nArray3[n5++] = 8211;
                nArray3[n5++] = 8235;
                nArray3[n5++] = 8209;
                nArray3[n5++] = this.capabilities.getDoubleBuffered() ? 1 : 0;
                nArray3[n5++] = 8210;
                nArray3[n5++] = this.capabilities.getStereo() ? 1 : 0;
                nArray3[n5++] = 8226;
                nArray3[n5++] = this.capabilities.getDepthBits();
                nArray3[n5++] = 8213;
                nArray3[n5++] = this.capabilities.getRedBits();
                nArray3[n5++] = 8215;
                nArray3[n5++] = this.capabilities.getGreenBits();
                nArray3[n5++] = 8217;
                nArray3[n5++] = this.capabilities.getBlueBits();
                nArray3[n5++] = 8219;
                nArray3[n5++] = this.capabilities.getAlphaBits();
                nArray3[n5++] = 8227;
                nArray3[n5++] = this.capabilities.getStencilBits();
                if (this.capabilities.getAccumRedBits() > 0 || this.capabilities.getAccumGreenBits() > 0 || this.capabilities.getAccumBlueBits() > 0 || this.capabilities.getAccumAlphaBits() > 0) {
                    nArray3[n5++] = 8221;
                    nArray3[n5++] = this.capabilities.getAccumRedBits() + this.capabilities.getAccumGreenBits() + this.capabilities.getAccumBlueBits() + this.capabilities.getAccumAlphaBits();
                    nArray3[n5++] = 8222;
                    nArray3[n5++] = this.capabilities.getAccumRedBits();
                    nArray3[n5++] = 8223;
                    nArray3[n5++] = this.capabilities.getAccumGreenBits();
                    nArray3[n5++] = 8224;
                    nArray3[n5++] = this.capabilities.getAccumBlueBits();
                    nArray3[n5++] = 8225;
                    nArray3[n5++] = this.capabilities.getAccumAlphaBits();
                }
                if (bl3 && this.capabilities.getSampleBuffers()) {
                    nArray3[n5++] = 8257;
                    nArray3[n5++] = 1;
                    nArray3[n5++] = 8258;
                    nArray3[n5++] = this.capabilities.getNumSamples();
                }
                if (gL.wglChoosePixelFormatARB(this.hdc, nArray3, fArray, 256, nArray2 = new int[256], nArray = new int[1])) {
                    n2 = nArray[0];
                    if (n2 > 0) {
                        n3 = nArray2[0] - 1;
                        if (DEBUG) {
                            System.err.println("Used wglChoosePixelFormatARB to recommend pixel format " + n3);
                        }
                    }
                } else if (DEBUG) {
                    System.err.println("wglChoosePixelFormatARB failed: " + WGL.GetLastError());
                    Thread.dumpStack();
                }
                if (DEBUG && n3 < 0) {
                    System.err.print("wglChoosePixelFormatARB didn't recommend a pixel format");
                    if (this.capabilities.getSampleBuffers()) {
                        System.err.print(" for multisampled GLCapabilities");
                    }
                    System.err.println();
                }
                n5 = 0;
                nArray3[0] = 8192;
                if (gL.wglGetPixelFormatAttribivARB(this.hdc, 0, 0, 1, nArray3, nArray4)) {
                    n2 = nArray4[0];
                    nArray3[n5++] = 8193;
                    nArray3[n5++] = 8195;
                    nArray3[n5++] = 8208;
                    nArray3[n5++] = 8226;
                    nArray3[n5++] = 8227;
                    nArray3[n5++] = 8209;
                    nArray3[n5++] = 8210;
                    nArray3[n5++] = 8211;
                    nArray3[n5++] = 8213;
                    nArray3[n5++] = 8215;
                    nArray3[n5++] = 8217;
                    nArray3[n5++] = 8219;
                    nArray3[n5++] = 8222;
                    nArray3[n5++] = 8223;
                    nArray3[n5++] = 8224;
                    nArray3[n5++] = 8225;
                    if (bl3) {
                        nArray3[n5++] = 8257;
                        nArray3[n5++] = 8258;
                    }
                    gLCapabilitiesArray = new GLCapabilities[n2];
                    for (n4 = 0; n4 < n2; ++n4) {
                        if (!gL.wglGetPixelFormatAttribivARB(this.hdc, n4 + 1, 0, n5, nArray3, nArray4)) {
                            throw new GLException("Error getting pixel format attributes for pixel format " + (n4 + 1) + " of device context");
                        }
                        gLCapabilitiesArray[n4] = WindowsGLContext.iattributes2GLCapabilities(nArray3, nArray4, n5, true);
                    }
                    if (bl4) {
                        WGL.wglMakeCurrent(0L, 0L);
                    }
                    bl5 = true;
                } else {
                    n4 = WGL.GetLastError();
                    if (n4 != 0) {
                        throw new GLException("Unable to enumerate pixel formats of window using wglGetPixelFormatAttribivARB: error code " + WGL.GetLastError());
                    }
                }
            }
            if (!bl5) {
                if (DEBUG) {
                    System.err.println("Using ChoosePixelFormat because no wglChoosePixelFormatARB: dummyGL = " + gL);
                }
                pIXELFORMATDESCRIPTOR = WindowsGLContext.glCapabilities2PFD(this.capabilities, bl);
                n3 = WGL.ChoosePixelFormat(this.hdc, pIXELFORMATDESCRIPTOR) - 1;
                n2 = WGL.DescribePixelFormat(this.hdc, 1, 0, null);
                if (n2 == 0) {
                    throw new GLException("Unable to enumerate pixel formats of window for GLCapabilitiesChooser");
                }
                gLCapabilitiesArray = new GLCapabilities[n2];
                for (int i = 0; i < n2; ++i) {
                    if (WGL.DescribePixelFormat(this.hdc, 1 + i, pIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
                        throw new GLException("Error describing pixel format " + (1 + i) + " of device context");
                    }
                    gLCapabilitiesArray[i] = WindowsGLContext.pfd2GLCapabilities(pIXELFORMATDESCRIPTOR);
                }
            }
            if ((n = this.chooser.chooseCapabilities(this.capabilities, gLCapabilitiesArray, n3)) < 0 || n >= n2) {
                throw new GLException("Invalid result " + n + " from GLCapabilitiesChooser (should be between 0 and " + (n2 - 1) + ")");
            }
            if (DEBUG) {
                System.err.println("Chosen pixel format (" + n + "):");
                System.err.println(gLCapabilitiesArray[n]);
            }
            if (WGL.DescribePixelFormat(this.hdc, ++n, pIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
                throw new GLException("Error re-describing the chosen pixel format: " + WGL.GetLastError());
            }
        } else {
            pIXELFORMATDESCRIPTOR = WindowsGLContext.glCapabilities2PFD(this.capabilities, bl);
            n = WGL.ChoosePixelFormat(this.hdc, pIXELFORMATDESCRIPTOR);
        }
        if (!WGL.SetPixelFormat(this.hdc, n, pIXELFORMATDESCRIPTOR)) {
            int n6 = WGL.GetLastError();
            if (DEBUG) {
                System.err.println("SetPixelFormat failed: current context = " + WGL.wglGetCurrentContext() + ", current DC = " + WGL.wglGetCurrentDC());
                System.err.println("GetPixelFormat(hdc " + WindowsGLContext.hdcToString(this.hdc) + ") returns " + WGL.GetPixelFormat(this.hdc));
            }
            throw new GLException("Unable to set pixel format " + n + " for device context " + WindowsGLContext.hdcToString(this.hdc) + ": error code " + n6);
        }
        this.hglrc = WGL.wglCreateContext(this.hdc);
        if (DEBUG) {
            System.err.println("!!! Created OpenGL context " + this.hglrc + " for device context " + WindowsGLContext.hdcToString(this.hdc) + " using pixel format " + n);
        }
        if (this.hglrc == 0L) {
            throw new GLException("Unable to create OpenGL context");
        }
    }

    protected long getHGLRC() {
        return this.hglrc;
    }

    static PIXELFORMATDESCRIPTOR glCapabilities2PFD(GLCapabilities gLCapabilities, boolean bl) {
        int n = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        if (n < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsGLContext.newPixelFormatDescriptor();
        int n2 = 4128;
        if (gLCapabilities.getDoubleBuffered()) {
            n2 |= 1;
            if (bl) {
                n2 |= 0x200;
            }
        }
        n2 = bl ? (n2 |= 4) : (n2 |= 8);
        pIXELFORMATDESCRIPTOR.dwFlags(n2);
        pIXELFORMATDESCRIPTOR.iPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.cColorBits((byte)n);
        pIXELFORMATDESCRIPTOR.cRedBits((byte)gLCapabilities.getRedBits());
        pIXELFORMATDESCRIPTOR.cGreenBits((byte)gLCapabilities.getGreenBits());
        pIXELFORMATDESCRIPTOR.cBlueBits((byte)gLCapabilities.getBlueBits());
        pIXELFORMATDESCRIPTOR.cDepthBits((byte)gLCapabilities.getDepthBits());
        pIXELFORMATDESCRIPTOR.iLayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR newPixelFormatDescriptor() {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = new PIXELFORMATDESCRIPTOR();
        pIXELFORMATDESCRIPTOR.nSize((short)pIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.nVersion((short)1);
        return pIXELFORMATDESCRIPTOR;
    }

    static GLCapabilities pfd2GLCapabilities(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        if ((pIXELFORMATDESCRIPTOR.dwFlags() & 0x20) == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(pIXELFORMATDESCRIPTOR.cRedBits());
        gLCapabilities.setGreenBits(pIXELFORMATDESCRIPTOR.cGreenBits());
        gLCapabilities.setBlueBits(pIXELFORMATDESCRIPTOR.cBlueBits());
        gLCapabilities.setAlphaBits(pIXELFORMATDESCRIPTOR.cAlphaBits());
        gLCapabilities.setAccumRedBits(pIXELFORMATDESCRIPTOR.cAccumRedBits());
        gLCapabilities.setAccumGreenBits(pIXELFORMATDESCRIPTOR.cAccumGreenBits());
        gLCapabilities.setAccumBlueBits(pIXELFORMATDESCRIPTOR.cAccumBlueBits());
        gLCapabilities.setAccumAlphaBits(pIXELFORMATDESCRIPTOR.cAccumAlphaBits());
        gLCapabilities.setDepthBits(pIXELFORMATDESCRIPTOR.cDepthBits());
        gLCapabilities.setStencilBits(pIXELFORMATDESCRIPTOR.cStencilBits());
        gLCapabilities.setDoubleBuffered((pIXELFORMATDESCRIPTOR.dwFlags() & 1) != 0);
        gLCapabilities.setStereo((pIXELFORMATDESCRIPTOR.dwFlags() & 2) != 0);
        gLCapabilities.setHardwareAccelerated((pIXELFORMATDESCRIPTOR.dwFlags() & 0x40) == 0 || (pIXELFORMATDESCRIPTOR.dwFlags() & 0x1000) != 0);
        return gLCapabilities;
    }

    static GLCapabilities iattributes2GLCapabilities(int[] nArray, int[] nArray2, int n, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        block20: for (int i = 0; i < n; ++i) {
            switch (nArray[i]) {
                case 8193: {
                    if (nArray2[i] == 1) continue block20;
                    return null;
                }
                case 8195: {
                    gLCapabilities.setHardwareAccelerated(nArray2[i] == 8231);
                    continue block20;
                }
                case 8208: {
                    if (nArray2[i] == 1) continue block20;
                    return null;
                }
                case 8226: {
                    gLCapabilities.setDepthBits(nArray2[i]);
                    continue block20;
                }
                case 8227: {
                    gLCapabilities.setStencilBits(nArray2[i]);
                    continue block20;
                }
                case 8209: {
                    gLCapabilities.setDoubleBuffered(nArray2[i] == 1);
                    continue block20;
                }
                case 8210: {
                    gLCapabilities.setStereo(nArray2[i] == 1);
                    continue block20;
                }
                case 8211: {
                    if (nArray2[i] == 8235) continue block20;
                    return null;
                }
                case 8213: {
                    gLCapabilities.setRedBits(nArray2[i]);
                    continue block20;
                }
                case 8215: {
                    gLCapabilities.setGreenBits(nArray2[i]);
                    continue block20;
                }
                case 8217: {
                    gLCapabilities.setBlueBits(nArray2[i]);
                    continue block20;
                }
                case 8219: {
                    gLCapabilities.setAlphaBits(nArray2[i]);
                    continue block20;
                }
                case 8222: {
                    gLCapabilities.setAccumRedBits(nArray2[i]);
                    continue block20;
                }
                case 8223: {
                    gLCapabilities.setAccumGreenBits(nArray2[i]);
                    continue block20;
                }
                case 8224: {
                    gLCapabilities.setAccumBlueBits(nArray2[i]);
                    continue block20;
                }
                case 8225: {
                    gLCapabilities.setAccumAlphaBits(nArray2[i]);
                    continue block20;
                }
                case 8257: {
                    gLCapabilities.setSampleBuffers(nArray2[i] == 1);
                    continue block20;
                }
                case 8258: {
                    gLCapabilities.setNumSamples(nArray2[i]);
                    continue block20;
                }
                default: {
                    throw new GLException("Unknown pixel format attribute " + nArray[i]);
                }
            }
        }
        return gLCapabilities;
    }

    protected static String hdcToString(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected boolean haveWGLARBPbuffer() {
        return this.haveWGLARBPbuffer;
    }

    static {
        $assertionsDisabled = !WindowsGLContext.class.desiredAssertionStatus();
        functionNameMap = new HashMap();
        functionNameMap.put("glAllocateMemoryNV", "wglAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "wglFreeMemoryNV");
        extensionNameMap = new HashMap();
        extensionNameMap.put("GL_ARB_pbuffer", "WGL_ARB_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "WGL_ARB_pixel_format");
    }
}

