/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.macosx;

import java.awt.Component;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextShareSet;
import net.java.games.jogl.impl.JAWT;
import net.java.games.jogl.impl.JAWTFactory;
import net.java.games.jogl.impl.macosx.CGL;
import net.java.games.jogl.impl.macosx.GLProcAddressTable;
import net.java.games.jogl.impl.macosx.MacOSXGLImpl;

public abstract class MacOSXGLContext
extends GLContext {
    private static JAWT jawt;
    protected long nsContext;
    protected long nsView;
    protected long updater;
    private GLProcAddressTable glProcAddressTable;

    public MacOSXGLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(component, gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    protected GL createGL() {
        return new MacOSXGLImpl(this);
    }

    protected String mapToRealGLFunctionName(String string) {
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected boolean isFunctionAvailable(String string) {
        return super.isFunctionAvailable(string);
    }

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    protected abstract boolean isOffscreen();

    public int getOffscreenContextBufferedImageType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextWidth() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextHeight() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    protected void create() {
        MacOSXGLContext macOSXGLContext = (MacOSXGLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (macOSXGLContext != null && (l = macOSXGLContext.getNSContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        this.nsContext = CGL.createContext(l, this.nsView, this.capabilities.getDoubleBuffered() ? 1 : 0, this.capabilities.getRedBits(), this.capabilities.getGreenBits(), this.capabilities.getBlueBits(), this.capabilities.getAlphaBits(), this.capabilities.getDepthBits(), this.capabilities.getStencilBits(), this.capabilities.getAccumRedBits(), this.capabilities.getAccumGreenBits(), this.capabilities.getAccumBlueBits(), this.capabilities.getAccumAlphaBits(), this.capabilities.getSampleBuffers() ? 1 : 0, this.capabilities.getNumSamples());
        if (this.nsContext == 0L) {
            throw new GLException("Error creating nsContext");
        }
        GLContextShareSet.contextCreated(this);
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        boolean bl = false;
        if (this.nsContext == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println("!!! Created GL nsContext for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!CGL.makeCurrentContext(this.nsContext, this.nsView)) {
            throw new GLException("Error making nsContext current");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            if (runnable != null) {
                runnable.run();
            }
        }
        return true;
    }

    protected synchronized void free() throws GLException {
        if (!CGL.clearCurrentContext(this.nsContext, this.nsView)) {
            throw new GLException("Error freeing OpenGL nsContext");
        }
    }

    protected void destroyImpl() throws GLException {
        if (this.nsContext != 0L) {
            if (!CGL.deleteContext(this.nsContext, 0L)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.nsContext);
            }
            this.nsContext = 0L;
        }
    }

    public abstract void swapBuffers() throws GLException;

    protected long dynamicLookupFunction(String string) {
        return CGL.getProcAddress(string);
    }

    public boolean isCreated() {
        return this.nsContext != 0L;
    }

    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println("!!! Initializing OpenGL extension address table");
        }
        this.resetProcAddressTable(this.getGLProcAddressTable());
    }

    public GLProcAddressTable getGLProcAddressTable() {
        if (this.glProcAddressTable == null) {
            this.glProcAddressTable = new GLProcAddressTable();
        }
        return this.glProcAddressTable;
    }

    public String getPlatformExtensionsString() {
        return "";
    }

    protected long getNSContext() {
        return this.nsContext;
    }

    protected long getNSView() {
        return this.nsView;
    }

    protected JAWT getJAWT() {
        if (jawt == null) {
            JAWT jAWT = new JAWT();
            jAWT.version(65540);
            if (!JAWTFactory.JAWT_GetAWT(jAWT)) {
                throw new RuntimeException("Unable to initialize JAWT");
            }
            jawt = jAWT;
        }
        return jawt;
    }
}

