/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.GLContext;

public abstract class GLContextFactory {
    private static GLContextFactory factory;

    public static GLContextFactory getFactory() {
        if (factory == null) {
            try {
                String string = System.getProperty("os.name");
                String string2 = string.toLowerCase();
                Class<?> clazz = null;
                clazz = string2.startsWith("wind") ? Class.forName("net.java.games.jogl.impl.windows.WindowsGLContextFactory") : (string2.startsWith("mac os x") ? Class.forName("net.java.games.jogl.impl.macosx.MacOSXGLContextFactory") : Class.forName("net.java.games.jogl.impl.x11.X11GLContextFactory"));
                if (clazz == null) {
                    throw new GLException("OS " + string + " not yet supported");
                }
                factory = (GLContextFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new GLException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new GLException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new GLException(illegalAccessException);
            }
        }
        return factory;
    }

    public abstract GraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities var1, GLCapabilitiesChooser var2, GraphicsDevice var3);

    public abstract GLContext createGLContext(Component var1, GLCapabilities var2, GLCapabilitiesChooser var3, GLContext var4);
}

