/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.io.OutputStream;
import jdbm.recman.BlockIo;
import jdbm.recman.DataPage;
import jdbm.recman.FreePhysicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.RecordFile;
import jdbm.recman.RecordHeader;

final class PhysicalRowIdManager {
    private final RecordFile file;
    private final PageManager pageman;
    private final FreePhysicalRowIdPageManager freeman;
    private final int BLOCK_SIZE;
    final short DATA_PER_PAGE;

    PhysicalRowIdManager(RecordFile file, PageManager pageManager, FreePhysicalRowIdPageManager freeman) throws IOException {
        this.file = file;
        this.pageman = pageManager;
        this.freeman = freeman;
        this.BLOCK_SIZE = file.BLOCK_SIZE;
        this.DATA_PER_PAGE = (short)(this.BLOCK_SIZE - 20);
    }

    long insert(byte[] data, int start, int length) throws IOException {
        if (length < 1) {
            throw new IllegalArgumentException("Lenght is <1");
        }
        if (start < 0) {
            throw new IllegalArgumentException("negative start");
        }
        long retval = this.alloc(length);
        this.write(retval, data, start, length);
        return retval;
    }

    long update(long rowid, byte[] data, int start, int length) throws IOException {
        short head;
        BlockIo block = this.file.get(Location.getBlock(rowid));
        int availSize = RecordHeader.getAvailableSize(block, head = Location.getOffset(rowid));
        if (length > availSize || availSize - length > 65534) {
            this.file.release(block);
            this.free(rowid);
            rowid = this.alloc(length);
        } else {
            this.file.release(block);
        }
        this.write(rowid, data, start, length);
        return rowid;
    }

    void delete(long rowid) throws IOException {
        this.free(rowid);
    }

    void fetch(OutputStream out, long rowid) throws IOException {
        short head;
        PageCursor curs = new PageCursor(this.pageman, Location.getBlock(rowid));
        BlockIo block = this.file.get(curs.getCurrent());
        int size = RecordHeader.getCurrentSize(block, head = Location.getOffset(rowid));
        if (size == 0) {
            this.file.release(curs.getCurrent(), false);
            return;
        }
        int offsetInBuffer = 0;
        int leftToRead = size;
        int dataOffset = Location.getOffset(rowid) + 4;
        while (leftToRead > 0) {
            int toCopy = this.BLOCK_SIZE - dataOffset;
            if (leftToRead < toCopy) {
                toCopy = leftToRead;
            }
            byte[] blockData = block.getData();
            int finish = dataOffset + toCopy;
            out.write(blockData, dataOffset, finish - dataOffset);
            offsetInBuffer += toCopy;
            this.file.release(block);
            if ((leftToRead -= toCopy) <= 0) continue;
            block = this.file.get(curs.next());
            dataOffset = 20;
        }
    }

    private long alloc(int size) throws IOException {
        long retval = this.freeman.get(size = RecordHeader.roundAvailableSize(size));
        if (retval == 0L) {
            retval = this.allocNew(size, this.pageman.getLast((short)1));
        }
        return retval;
    }

    private long allocNew(int size, long start) throws IOException {
        DataPage curPage;
        BlockIo curBlock;
        if (start == 0L) {
            start = this.pageman.allocate((short)1);
            curBlock = this.file.get(start);
            curPage = DataPage.getDataPageView(curBlock, this.BLOCK_SIZE);
            curPage.setFirst((short)20);
            RecordHeader.setAvailableSize(curBlock, (short)20, 0);
            RecordHeader.setCurrentSize(curBlock, (short)20, 0);
        } else {
            curBlock = this.file.get(start);
            curPage = DataPage.getDataPageView(curBlock, this.BLOCK_SIZE);
        }
        short pos = curPage.getFirst();
        if (pos == 0) {
            this.file.release(curBlock);
            return this.allocNew(size, 0L);
        }
        short hdr = pos;
        int availSize = RecordHeader.getAvailableSize(curBlock, hdr);
        while (availSize != 0 && pos < this.BLOCK_SIZE) {
            if ((pos = (short)(pos + (availSize + 4))) == this.BLOCK_SIZE) {
                this.file.release(curBlock);
                return this.allocNew(size, 0L);
            }
            hdr = pos;
            availSize = RecordHeader.getAvailableSize(curBlock, hdr);
        }
        if (pos == 4) {
            this.file.release(curBlock);
        }
        long retval = Location.toLong(start, pos);
        int freeHere = this.BLOCK_SIZE - pos - 4;
        if (freeHere < size) {
            int neededLeft;
            int lastSize = (size - freeHere) % this.DATA_PER_PAGE;
            if (this.DATA_PER_PAGE - lastSize < 20) {
                size += this.DATA_PER_PAGE - lastSize;
                size = RecordHeader.roundAvailableSize(size);
            }
            RecordHeader.setAvailableSize(curBlock, hdr, size);
            this.file.release(start, true);
            for (neededLeft = size - freeHere; neededLeft >= this.DATA_PER_PAGE; neededLeft -= this.DATA_PER_PAGE) {
                start = this.pageman.allocate((short)1);
                curBlock = this.file.get(start);
                curPage = DataPage.getDataPageView(curBlock, this.BLOCK_SIZE);
                curPage.setFirst((short)0);
                this.file.release(start, true);
            }
            if (neededLeft > 0) {
                start = this.pageman.allocate((short)1);
                curBlock = this.file.get(start);
                curPage = DataPage.getDataPageView(curBlock, this.BLOCK_SIZE);
                curPage.setFirst((short)(20 + neededLeft));
                this.file.release(start, true);
            }
        } else {
            if (freeHere - size <= 20) {
                size = freeHere;
            }
            RecordHeader.setAvailableSize(curBlock, hdr, size);
            this.file.release(start, true);
        }
        return retval;
    }

    private void free(long id) throws IOException {
        BlockIo curBlock = this.file.get(Location.getBlock(id));
        DataPage curPage = DataPage.getDataPageView(curBlock, this.BLOCK_SIZE);
        RecordHeader.setCurrentSize(curBlock, Location.getOffset(id), 0);
        this.file.release(Location.getBlock(id), true);
        this.freeman.put(id, RecordHeader.getAvailableSize(curBlock, Location.getOffset(id)));
    }

    private void write(long rowid, byte[] data, int start, int length) throws IOException {
        PageCursor curs = new PageCursor(this.pageman, Location.getBlock(rowid));
        BlockIo block = this.file.get(curs.getCurrent());
        short hdr = Location.getOffset(rowid);
        RecordHeader.setCurrentSize(block, hdr, length);
        if (length == 0) {
            this.file.release(curs.getCurrent(), true);
            return;
        }
        int offsetInBuffer = start;
        int leftToWrite = length;
        int dataOffset = Location.getOffset(rowid) + 4;
        while (leftToWrite > 0) {
            int toCopy = this.BLOCK_SIZE - dataOffset;
            if (leftToWrite < toCopy) {
                toCopy = leftToWrite;
            }
            System.arraycopy(data, offsetInBuffer, block.getData(), dataOffset, toCopy);
            offsetInBuffer += toCopy;
            this.file.release(curs.getCurrent(), true);
            if ((leftToWrite -= toCopy) <= 0) continue;
            block = this.file.get(curs.next());
            dataOffset = 20;
        }
    }

    void commit() throws IOException {
        this.freeman.commit();
    }
}

