/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jdbm.RecordListener;
import jdbm.RecordManager;
import jdbm.Serializer;
import jdbm.btree.BPage;
import jdbm.btree.BTreeSortedMap;
import jdbm.helper.ComparableComparator;
import jdbm.helper.JdbmBase;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTree<K, V>
implements Externalizable,
JdbmBase<K, V> {
    private static final long serialVersionUID = 8883213742777032628L;
    private static final boolean DEBUG = false;
    public static final int DEFAULT_SIZE = 32;
    protected transient RecordManager _recman;
    private transient long _recid;
    protected Comparator<K> _comparator;
    protected Serializer<K> keySerializer;
    protected Serializer<V> valueSerializer;
    private int _height;
    private transient long _root;
    protected int _pageSize;
    protected volatile int _entries;
    private transient BPage<K, V> _bpageSerializer;
    protected List<RecordListener<K, V>> recordListeners = new CopyOnWriteArrayList<RecordListener<K, V>>();
    protected ReadWriteLock lock = new ReentrantReadWriteLock();

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public void setKeySerializer(Serializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValueSerializer(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public static <K, V> BTree<K, V> createInstance(RecordManager recman, Comparator<K> comparator) throws IOException {
        return BTree.createInstance(recman, comparator, null, null, 32);
    }

    public static <K extends Comparable, V> BTree<K, V> createInstance(RecordManager recman) throws IOException {
        BTree<K, V> ret = BTree.createInstance(recman, ComparableComparator.INSTANCE, null, null, 32);
        return ret;
    }

    public static <K, V> BTree<K, V> createInstance(RecordManager recman, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        return BTree.createInstance(recman, comparator, keySerializer, valueSerializer, 32);
    }

    public static <K, V> BTree<K, V> createInstance(RecordManager recman, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer, int pageSize) throws IOException {
        if (recman == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 'comparator' is null");
        }
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'comparator' must be serializable");
        }
        if ((pageSize & 1) != 0) {
            throw new IllegalArgumentException("Argument 'pageSize' must be even");
        }
        BTree<K, V> btree = new BTree<K, V>();
        btree._recman = recman;
        btree._comparator = comparator;
        btree.keySerializer = keySerializer;
        btree.valueSerializer = valueSerializer;
        btree._pageSize = pageSize;
        btree._bpageSerializer = new BPage();
        btree._bpageSerializer._btree = btree;
        btree._recid = recman.insert(btree);
        return btree;
    }

    public static <K, V> BTree<K, V> load(RecordManager recman, long recid) throws IOException {
        BTree btree = (BTree)recman.fetch(recid);
        btree._recid = recid;
        btree._recman = recman;
        btree._bpageSerializer = new BPage();
        btree._bpageSerializer._btree = btree;
        return btree;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V insert(K key, V value, boolean replace) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' is null");
        }
        try {
            this.lock.writeLock().lock();
            BPage<Object, Object> rootPage = this.getRoot();
            if (rootPage == null) {
                rootPage = new BPage<K, V>(this, key, value);
                this._root = rootPage._recid;
                this._height = 1;
                this._entries = 1;
                this._recman.update(this._recid, this);
                for (RecordListener<K, V> l : this.recordListeners) {
                    l.recordInserted(key, value);
                }
                Iterator<RecordListener<K, V>> i$ = null;
                return (V)i$;
            }
            BPage.InsertResult<K, V> insert = rootPage.insert(this._height, key, value, replace);
            boolean dirty = false;
            if (insert._overflow != null) {
                rootPage = new BPage(this, rootPage, insert._overflow);
                this._root = rootPage._recid;
                ++this._height;
                dirty = true;
            }
            if (insert._existing == null) {
                ++this._entries;
                dirty = true;
            }
            if (dirty) {
                this._recman.update(this._recid, this);
            }
            for (RecordListener l : this.recordListeners) {
                if (insert._existing == null) {
                    l.recordInserted(key, value);
                    continue;
                }
                l.recordUpdated(key, insert._existing, value);
            }
            Object v = insert._existing;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        try {
            this.lock.writeLock().lock();
            BPage<K, V> rootPage = this.getRoot();
            if (rootPage == null) {
                V v = null;
                return v;
            }
            boolean dirty = false;
            BPage.RemoveResult<K, V> remove = rootPage.remove(this._height, key);
            if (remove._underflow && rootPage.isEmpty()) {
                --this._height;
                dirty = true;
                this._recman.delete(this._root);
                this._root = this._height == 0 ? 0L : rootPage.childBPage((int)(this._pageSize - 1))._recid;
            }
            if (remove._value != null) {
                --this._entries;
                dirty = true;
            }
            if (dirty) {
                this._recman.update(this._recid, this);
            }
            if (remove._value != null) {
                for (RecordListener l : this.recordListeners) {
                    l.recordRemoved(key, remove._value);
                }
            }
            Object v = remove._value;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V find(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        try {
            this.lock.readLock().lock();
            BPage<K, V> rootPage = this.getRoot();
            if (rootPage == null) {
                V v = null;
                return v;
            }
            V v = rootPage.findValue(this._height, key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Tuple<K, V> findGreaterOrEqual(K key) throws IOException {
        if (key == null) {
            return null;
        }
        Tuple<Object, Object> tuple = new Tuple<Object, Object>(null, null);
        TupleBrowser<Object, Object> browser = this.browse(key);
        if (browser.getNext(tuple)) {
            return tuple;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleBrowser<K, V> browse() throws IOException {
        try {
            TupleBrowser<K, V> browser;
            this.lock.readLock().lock();
            BPage<K, V> rootPage = this.getRoot();
            if (rootPage == null) {
                TupleBrowser tupleBrowser = EmptyBrowser.INSTANCE;
                return tupleBrowser;
            }
            TupleBrowser<K, V> tupleBrowser = browser = rootPage.findFirst();
            return tupleBrowser;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleBrowser<K, V> browse(K key) throws IOException {
        try {
            TupleBrowser<K, V> browser;
            this.lock.readLock().lock();
            BPage<K, V> rootPage = this.getRoot();
            if (rootPage == null) {
                TupleBrowser tupleBrowser = EmptyBrowser.INSTANCE;
                return tupleBrowser;
            }
            TupleBrowser<K, V> tupleBrowser = browser = rootPage.find(this._height, key);
            return tupleBrowser;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        return this._entries;
    }

    public long getRecid() {
        return this._recid;
    }

    BPage<K, V> getRoot() throws IOException {
        if (this._root == 0L) {
            return null;
        }
        BPage root = (BPage)this._recman.fetch(this._root, this._bpageSerializer);
        if (root != null) {
            root._recid = this._root;
            root._btree = this;
        }
        return root;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._comparator = (Comparator)in.readObject();
        this._height = in.readInt();
        this._root = in.readLong();
        this._pageSize = in.readInt();
        this._entries = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._comparator);
        out.writeInt(this._height);
        out.writeLong(this._root);
        out.writeInt(this._pageSize);
        out.writeInt(this._entries);
    }

    public BTreeSortedMap<K, V> asMap() {
        return new BTreeSortedMap(this, false);
    }

    @Override
    public void addRecordListener(RecordListener<K, V> listener) {
        this.recordListeners.add(listener);
    }

    @Override
    public void removeRecordListener(RecordListener<K, V> listener) {
        this.recordListeners.remove(listener);
    }

    @Override
    public RecordManager getRecordManager() {
        return this._recman;
    }

    public Comparator<K> getComparator() {
        return this._comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        try {
            this.lock.writeLock().lock();
            BPage<K, V> rootPage = this.getRoot();
            if (rootPage != null) {
                rootPage.delete();
            }
            this._recman.delete(this._recid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void dumpChildPageRecIDs(List<Long> out) throws IOException {
        BPage<K, V> root = this.getRoot();
        if (root != null) {
            out.add(root._recid);
            root.dumpChildPageRecIDs(out, this._height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyBrowser<K, V>
    implements TupleBrowser<K, V> {
        static TupleBrowser INSTANCE = new EmptyBrowser();

        private EmptyBrowser() {
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) {
            return false;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) {
            return false;
        }
    }
}

