/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import jdbm.Serializer;
import jdbm.SerializerInput;
import jdbm.SerializerOutput;
import jdbm.btree.BTree;
import jdbm.btree.LeadingValueCompressionProvider;
import jdbm.helper.ComparableComparator;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.LongPacker;
import jdbm.helper.OpenByteArrayInputStream;
import jdbm.helper.OpenByteArrayOutputStream;
import jdbm.helper.Serialization;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BPage<K, V>
implements Serializer<BPage<K, V>> {
    private static final boolean DEBUG = false;
    transient BTree<K, V> _btree;
    protected transient long _recid;
    protected boolean _isLeaf;
    protected K[] _keys;
    protected V[] _values;
    protected long[] _children;
    protected int _first;
    protected long _previous;
    protected long _next;
    private static final int LEAF = 162;
    private static final int NOT_LEAF = 163;
    private static final int ALL_NULL = 0;
    private static final int ALL_INTEGERS = 32;
    private static final int ALL_INTEGERS_NEGATIVE = 64;
    private static final int ALL_LONGS = 96;
    private static final int ALL_LONGS_NEGATIVE = 128;
    private static final int ALL_STRINGS = 160;
    private static final int ALL_OTHER = 192;

    public BTree<K, V> getBTree() {
        return this._btree;
    }

    public BPage() {
    }

    BPage(BTree<K, V> btree, BPage<K, V> root, BPage<K, V> overflow) throws IOException {
        this._btree = btree;
        this._isLeaf = false;
        this._first = this._btree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = overflow.getLargestKey();
        this._keys[this._btree._pageSize - 1] = root.getLargestKey();
        this._children = new long[this._btree._pageSize];
        this._children[this._btree._pageSize - 2] = overflow._recid;
        this._children[this._btree._pageSize - 1] = root._recid;
        this._recid = this._btree._recman.insert(this, this);
    }

    BPage(BTree<K, V> btree, K key, V value) throws IOException {
        this._btree = btree;
        this._isLeaf = true;
        this._first = btree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = key;
        this._keys[this._btree._pageSize - 1] = null;
        this._values = new Object[this._btree._pageSize];
        this._values[this._btree._pageSize - 2] = value;
        this._values[this._btree._pageSize - 1] = null;
        this._recid = this._btree._recman.insert(this, this);
    }

    BPage(BTree<K, V> btree, boolean isLeaf) throws IOException {
        this._btree = btree;
        this._isLeaf = isLeaf;
        this._first = this._btree._pageSize / 2;
        this._keys = new Object[this._btree._pageSize];
        if (isLeaf) {
            this._values = new Object[this._btree._pageSize];
        } else {
            this._children = new long[this._btree._pageSize];
        }
        this._recid = this._btree._recman.insert(this, this);
    }

    K getLargestKey() {
        return this._keys[this._btree._pageSize - 1];
    }

    boolean isEmpty() {
        if (this._isLeaf) {
            return this._first == this._values.length - 1;
        }
        return this._first == this._children.length - 1;
    }

    boolean isFull() {
        return this._first == 0;
    }

    TupleBrowser<K, V> find(int height, K key) throws IOException {
        int index = this.findChildren(key);
        if (--height == 0) {
            return new Browser(this, index);
        }
        BPage<K, V> child = this.childBPage(index);
        return child.find(height, key);
    }

    V findValue(int height, K key) throws IOException {
        int index = this.findChildren(key);
        if (--height == 0) {
            K key2 = this._keys[index];
            if (key2 == null || this._btree._comparator.compare(key, key2) != 0) {
                return null;
            }
            return this._values[index];
        }
        BPage<K, V> child = this.childBPage(index);
        return child.findValue(height, key);
    }

    TupleBrowser<K, V> findFirst() throws IOException {
        if (this._isLeaf) {
            return new Browser(this, this._first);
        }
        BPage<K, V> child = this.childBPage(this._first);
        return child.findFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void delete() throws IOException {
        if (this._isLeaf) {
            if (this._next != 0L) {
                BPage<K, V> nextBPage = this.loadBPage(this._next);
                if (nextBPage._previous != this._recid) throw new Error("Inconsistent data in BTree");
                nextBPage._previous = this._previous;
                this._btree._recman.update(nextBPage._recid, nextBPage, nextBPage);
            }
            if (this._previous != 0L) {
                BPage<K, V> previousBPage = this.loadBPage(this._previous);
                if (previousBPage._next == this._recid) throw new Error("Inconsistent data in BTree");
                previousBPage._next = this._next;
                this._btree._recman.update(previousBPage._recid, previousBPage, previousBPage);
            }
        } else {
            int left = this._first;
            int right = this._btree._pageSize - 1;
            for (int i = left; i <= right; ++i) {
                BPage<K, V> childBPage = this.loadBPage(this._children[i]);
                childBPage.delete();
            }
        }
        this._btree._recman.delete(this._recid);
    }

    InsertResult<K, V> insert(int height, K key, V value, boolean replace) throws IOException {
        long overflow;
        InsertResult result;
        int index = this.findChildren(key);
        if (--height == 0) {
            result = new InsertResult();
            overflow = -1L;
            if (this.compare(key, this._keys[index]) == 0) {
                result._existing = this._values[index];
                if (replace) {
                    this._values[index] = value;
                    this._btree._recman.update(this._recid, this, this);
                }
                return result;
            }
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.insert(height, key, value, replace);
            if (result._existing != null) {
                return result;
            }
            if (result._overflow == null) {
                return result;
            }
            key = result._overflow.getLargestKey();
            overflow = result._overflow._recid;
            this._keys[index] = child.getLargestKey();
            result._overflow = null;
        }
        if (!this.isFull()) {
            if (height == 0) {
                BPage.insertEntry(this, index - 1, key, value);
            } else {
                BPage.insertChild(this, index - 1, key, overflow);
            }
            this._btree._recman.update(this._recid, this, this);
            return result;
        }
        int half = this._btree._pageSize >> 1;
        BPage<K, V> newPage = new BPage<K, V>(this._btree, this._isLeaf);
        if (index < half) {
            if (height == 0) {
                BPage.copyEntries(this, 0, newPage, half, index);
                BPage.setEntry(newPage, half + index, key, value);
                BPage.copyEntries(this, index, newPage, half + index + 1, half - index - 1);
            } else {
                BPage.copyChildren(this, 0, newPage, half, index);
                BPage.setChild(newPage, half + index, key, overflow);
                BPage.copyChildren(this, index, newPage, half + index + 1, half - index - 1);
            }
        } else if (height == 0) {
            BPage.copyEntries(this, 0, newPage, half, half);
            BPage.copyEntries(this, half, this, half - 1, index - half);
            BPage.setEntry(this, index - 1, key, value);
        } else {
            BPage.copyChildren(this, 0, newPage, half, half);
            BPage.copyChildren(this, half, this, half - 1, index - half);
            BPage.setChild(this, index - 1, key, overflow);
        }
        this._first = half - 1;
        for (int i = 0; i < this._first; ++i) {
            if (height == 0) {
                BPage.setEntry(this, i, null, null);
                continue;
            }
            BPage.setChild(this, i, null, -1L);
        }
        if (this._isLeaf) {
            newPage._previous = this._previous;
            newPage._next = this._recid;
            if (this._previous != 0L) {
                BPage<K, V> previous = this.loadBPage(this._previous);
                previous._next = newPage._recid;
                this._btree._recman.update(this._previous, previous, this);
            }
            this._previous = newPage._recid;
        }
        this._btree._recman.update(this._recid, this, this);
        this._btree._recman.update(newPage._recid, newPage, this);
        result._overflow = newPage;
        return result;
    }

    RemoveResult<K, V> remove(int height, K key) throws IOException {
        RemoveResult<K, V> result;
        int half = this._btree._pageSize / 2;
        int index = this.findChildren(key);
        if (--height == 0) {
            if (this.compare(this._keys[index], key) != 0) {
                throw new IllegalArgumentException("Key not found: " + key);
            }
            result = new RemoveResult();
            result._value = this._values[index];
            BPage.removeEntry(this, index);
            this._btree._recman.update(this._recid, this, this);
        } else {
            BPage<K, V> child = this.childBPage(index);
            result = child.remove(height, key);
            this._keys[index] = child.getLargestKey();
            this._btree._recman.update(this._recid, this, this);
            if (result._underflow) {
                if (child._first != half + 1) {
                    throw new IllegalStateException("Error during underflow [1]");
                }
                if (index < this._children.length - 1) {
                    BPage<K, V> brother = this.childBPage(index + 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        if (child._isLeaf) {
                            BPage.copyEntries(child, half + 1, child, half + 1 - steal, half - 1);
                            BPage.copyEntries(brother, bfirst, child, 2 * half - steal, steal);
                        } else {
                            BPage.copyChildren(child, half + 1, child, half + 1 - steal, half - 1);
                            BPage.copyChildren(brother, bfirst, child, 2 * half - steal, steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BPage.setEntry(brother, i, null, null);
                                continue;
                            }
                            BPage.setChild(brother, i, null, -1L);
                        }
                        this._keys[index] = child.getLargestKey();
                        this._btree._recman.update(this._recid, this, this);
                        this._btree._recman.update(brother._recid, brother, this);
                        this._btree._recman.update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [2]");
                        }
                        brother._first = 1;
                        if (child._isLeaf) {
                            BPage.copyEntries(child, half + 1, brother, 1, half - 1);
                        } else {
                            BPage.copyChildren(child, half + 1, brother, 1, half - 1);
                        }
                        this._btree._recman.update(brother._recid, brother, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, index - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, index - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._recman.update(this._recid, this, this);
                        if (child._previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(child._previous);
                            prev._next = child._next;
                            this._btree._recman.update(prev._recid, prev, this);
                        }
                        if (child._next != 0L) {
                            BPage<K, V> next = this.loadBPage(child._next);
                            next._previous = child._previous;
                            this._btree._recman.update(next._recid, next, this);
                        }
                        this._btree._recman.delete(child._recid);
                    }
                } else {
                    BPage<K, V> brother = this.childBPage(index - 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        if (child._isLeaf) {
                            BPage.copyEntries(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BPage.copyEntries(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        } else {
                            BPage.copyChildren(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BPage.copyChildren(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BPage.setEntry(brother, i, null, null);
                                continue;
                            }
                            BPage.setChild(brother, i, null, -1L);
                        }
                        this._keys[index - 1] = brother.getLargestKey();
                        this._btree._recman.update(this._recid, this, this);
                        this._btree._recman.update(brother._recid, brother, this);
                        this._btree._recman.update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [3]");
                        }
                        child._first = 1;
                        if (child._isLeaf) {
                            BPage.copyEntries(brother, half, child, 1, half);
                        } else {
                            BPage.copyChildren(brother, half, child, 1, half);
                        }
                        this._btree._recman.update(child._recid, child, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._recman.update(this._recid, this, this);
                        if (brother._previous != 0L) {
                            BPage<K, V> prev = this.loadBPage(brother._previous);
                            prev._next = brother._next;
                            this._btree._recman.update(prev._recid, prev, this);
                        }
                        if (brother._next != 0L) {
                            BPage<K, V> next = this.loadBPage(brother._next);
                            next._previous = brother._previous;
                            this._btree._recman.update(next._recid, next, this);
                        }
                        this._btree._recman.delete(brother._recid);
                    }
                }
            }
        }
        result._underflow = this._first > half;
        return result;
    }

    private int findChildren(K key) {
        int left = this._first;
        int right = this._btree._pageSize - 1;
        while (left < right) {
            int middle = (left + right) / 2;
            if (this.compare(this._keys[middle], key) < 0) {
                left = middle + 1;
                continue;
            }
            right = middle;
        }
        return right;
    }

    private static <K, V> void insertEntry(BPage<K, V> page, int index, K key, V value) {
        K[] keys = page._keys;
        V[] values = page._values;
        int start = page._first;
        int count = index - page._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(values, start, values, start - 1, count);
        --page._first;
        keys[index] = key;
        values[index] = value;
    }

    private static <K, V> void insertChild(BPage<K, V> page, int index, K key, long child) {
        K[] keys = page._keys;
        long[] children = page._children;
        int start = page._first;
        int count = index - page._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(children, start, children, start - 1, count);
        --page._first;
        keys[index] = key;
        children[index] = child;
    }

    private static <K, V> void removeEntry(BPage<K, V> page, int index) {
        K[] keys = page._keys;
        V[] values = page._values;
        int start = page._first;
        int count = index - page._first;
        System.arraycopy(keys, start, keys, start + 1, count);
        keys[start] = null;
        System.arraycopy(values, start, values, start + 1, count);
        values[start] = null;
        ++page._first;
    }

    private static <K, V> void setEntry(BPage<K, V> page, int index, K key, V value) {
        page._keys[index] = key;
        page._values[index] = value;
    }

    private static <K, V> void setChild(BPage<K, V> page, int index, K key, long recid) {
        page._keys[index] = key;
        page._children[index] = recid;
    }

    private static <K, V> void copyEntries(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._values, indexSource, dest._values, indexDest, count);
    }

    private static <K, V> void copyChildren(BPage<K, V> source, int indexSource, BPage<K, V> dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._children, indexSource, dest._children, indexDest, count);
    }

    BPage<K, V> childBPage(int index) throws IOException {
        return this.loadBPage(this._children[index]);
    }

    private BPage<K, V> loadBPage(long recid) throws IOException {
        BPage child = (BPage)this._btree._recman.fetch(recid, this);
        child._recid = recid;
        child._btree = this._btree;
        return child;
    }

    private final int compare(K value1, K value2) {
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        return this._btree._comparator.compare(value1, value2);
    }

    public static byte[] readByteArray(DataInputStream in) throws IOException {
        int len = LongPacker.unpackInt(in);
        if (len == 0) {
            return null;
        }
        byte[] buf = new byte[len - 1];
        in.readFully(buf);
        return buf;
    }

    public static void writeByteArray(SerializerOutput out, byte[] buf) throws IOException {
        if (buf == null) {
            out.write(0);
        } else {
            LongPacker.packInt(out, buf.length + 1);
            out.write(buf);
        }
    }

    private void dump(int height) {
        int i;
        String prefix = "";
        for (i = 0; i < height; ++i) {
            prefix = prefix + "    ";
        }
        System.out.println(prefix + "-------------------------------------- BPage recid=" + this._recid);
        System.out.println(prefix + "first=" + this._first);
        for (i = 0; i < this._btree._pageSize; ++i) {
            if (this._isLeaf) {
                System.out.println(prefix + "BPage [" + i + "] " + this._keys[i] + " " + this._values[i]);
                continue;
            }
            System.out.println(prefix + "BPage [" + i + "] " + this._keys[i] + " " + this._children[i]);
        }
        System.out.println(prefix + "--------------------------------------");
    }

    void dumpRecursive(int height, int level) throws IOException {
        ++level;
        if (--height > 0) {
            for (int i = this._first; i < this._btree._pageSize && this._keys[i] != null; ++i) {
                BPage<K, V> child = this.childBPage(i);
                super.dump(level);
                child.dumpRecursive(height, level);
            }
        }
    }

    @Override
    public BPage<K, V> deserialize(SerializerInput ois) throws IOException {
        BPage<K, V> bpage = new BPage<K, V>();
        switch (ois.read()) {
            case 162: {
                bpage._isLeaf = true;
                break;
            }
            case 163: {
                bpage._isLeaf = false;
                break;
            }
            default: {
                throw new InternalError("wrong BPage header");
            }
        }
        if (bpage._isLeaf) {
            bpage._previous = LongPacker.unpackLong(ois);
            bpage._next = LongPacker.unpackLong(ois);
        }
        bpage._first = LongPacker.unpackInt(ois);
        try {
            bpage._keys = this.readKeys(ois, bpage._first);
        }
        catch (ClassNotFoundException except) {
            throw new IOException(except.getMessage());
        }
        if (bpage._isLeaf) {
            try {
                this.readValues(ois, bpage);
            }
            catch (ClassNotFoundException except) {
                throw new IOException(except);
            }
        } else {
            bpage._children = new long[this._btree._pageSize];
            for (int i = bpage._first; i < this._btree._pageSize; ++i) {
                bpage._children[i] = LongPacker.unpackLong(ois);
            }
        }
        return bpage;
    }

    @Override
    public void serialize(SerializerOutput oos, BPage<K, V> obj) throws IOException {
        BPage<K, V> bpage = obj;
        oos.writeByte(bpage._isLeaf ? 162 : 163);
        if (bpage._isLeaf) {
            LongPacker.packLong(oos, bpage._previous);
            LongPacker.packLong(oos, bpage._next);
        }
        LongPacker.packInt(oos, bpage._first);
        this.writeKeys(oos, bpage._keys, bpage._first);
        if (bpage._isLeaf) {
            this.writeValues(oos, bpage);
        } else {
            for (int i = bpage._first; i < this._btree._pageSize; ++i) {
                LongPacker.packLong(oos, bpage._children[i]);
            }
        }
    }

    private void readValues(DataInputStream ois, BPage<K, V> bpage) throws IOException, ClassNotFoundException {
        bpage._values = new Object[this._btree._pageSize];
        if (this._btree.valueSerializer == null || this._btree.valueSerializer == DefaultSerializer.INSTANCE) {
            Object[] vals = (Object[])Serialization.readObject(ois);
            for (int i = bpage._first; i < this._btree._pageSize; ++i) {
                bpage._values[i] = vals[i - bpage._first];
            }
        } else {
            for (int i = bpage._first; i < this._btree._pageSize; ++i) {
                byte[] serialized = BPage.readByteArray(ois);
                if (serialized == null) continue;
                bpage._values[i] = this._btree.valueSerializer.deserialize(new SerializerInput(new ByteArrayInputStream(serialized)));
            }
        }
    }

    private void writeValues(SerializerOutput oos, BPage<K, V> bpage) throws IOException {
        if (this._btree.valueSerializer == null || this._btree.valueSerializer == DefaultSerializer.INSTANCE) {
            V[] vals2 = Arrays.copyOfRange(bpage._values, bpage._first, bpage._values.length);
            Serialization.writeObject(oos, vals2);
        } else {
            for (int i = bpage._first; i < this._btree._pageSize; ++i) {
                if (bpage._values[i] != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this._btree.valueSerializer.serialize(new SerializerOutput(baos), bpage._values[i]);
                    BPage.writeByteArray(oos, baos.toByteArray());
                    continue;
                }
                BPage.writeByteArray(oos, null);
            }
        }
    }

    private K[] readKeys(SerializerInput ois, int firstUse) throws IOException, ClassNotFoundException {
        Object[] ret = new Object[this._btree._pageSize];
        int type = ois.read();
        if (type == 0) {
            return ret;
        }
        if (type == 32 || type == 64) {
            long first = LongPacker.unpackLong(ois);
            if (type == 64) {
                first = -first;
            }
            ret[firstUse] = (int)first;
            for (int i = firstUse + 1; i < this._btree._pageSize; ++i) {
                long v = LongPacker.unpackLong(ois);
                if (v == 0L) continue;
                ret[i] = (int)(v += first);
                first = v;
            }
            return ret;
        }
        if (type == 96 || type == 128) {
            long first = LongPacker.unpackLong(ois);
            if (type == 128) {
                first = -first;
            }
            ret[firstUse] = first;
            for (int i = firstUse + 1; i < this._btree._pageSize; ++i) {
                long v = LongPacker.unpackLong(ois);
                if (v == 0L) continue;
                ret[i] = v += first;
                first = v;
            }
            return ret;
        }
        if (type == 160) {
            byte[] previous = null;
            for (int i = firstUse; i < this._btree._pageSize; ++i) {
                byte[] b = LeadingValueCompressionProvider.readByteArray(ois, previous, 0);
                if (b == null) continue;
                ret[i] = new String(b);
                previous = b;
            }
            return ret;
        }
        if (type == 192) {
            if (this._btree.keySerializer == null || this._btree.keySerializer == DefaultSerializer.INSTANCE) {
                for (int i = firstUse; i < this._btree._pageSize; ++i) {
                    ret[i] = DefaultSerializer.INSTANCE.deserialize(ois);
                }
                return ret;
            }
            DefaultSerializer ser = this._btree.keySerializer != null ? this._btree.keySerializer : DefaultSerializer.INSTANCE;
            OpenByteArrayInputStream in1 = null;
            SerializerInput in2 = null;
            byte[] previous = null;
            for (int i = firstUse; i < this._btree._pageSize; ++i) {
                byte[] b = LeadingValueCompressionProvider.readByteArray(ois, previous, 0);
                if (b == null) continue;
                if (in1 == null) {
                    in1 = new OpenByteArrayInputStream(b);
                    in2 = new SerializerInput(in1);
                }
                in1.reset(b, b.length);
                ret[i] = ser.deserialize(in2);
                previous = b;
            }
            return ret;
        }
        throw new InternalError("unknown bpage header type: " + type);
    }

    private void writeKeys(SerializerOutput oos, K[] keys, int firstUse) throws IOException {
        int i;
        if (keys.length != this._btree._pageSize) {
            throw new IllegalArgumentException("wrong keys size");
        }
        boolean allNull = true;
        for (i = firstUse; i < this._btree._pageSize; ++i) {
            if (keys[i] == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            oos.write(0);
            return;
        }
        if (this._btree._comparator == ComparableComparator.INSTANCE && (this._btree.keySerializer == null || this._btree.keySerializer == DefaultSerializer.INSTANCE)) {
            boolean allInteger = true;
            for (int i2 = firstUse; i2 < this._btree._pageSize; ++i2) {
                if (keys[i2] == null || keys[i2].getClass() == Integer.class) continue;
                allInteger = false;
                break;
            }
            boolean allLong = true;
            for (int i3 = firstUse; i3 < this._btree._pageSize; ++i3) {
                if (keys[i3] == null || keys[i3].getClass() == Long.class && (Long)keys[i3] != Long.MIN_VALUE) continue;
                allLong = false;
                break;
            }
            if (allLong) {
                long max = Long.MIN_VALUE;
                long min = Long.MAX_VALUE;
                for (int i4 = firstUse; i4 < this._btree._pageSize; ++i4) {
                    if (keys[i4] == null) continue;
                    long v = (Long)keys[i4];
                    if (v > max) {
                        max = v;
                    }
                    if (v >= min) continue;
                    min = v;
                }
                double max2 = max;
                double min2 = min;
                double maxDiff = 9.223372036854776E18;
                if (max2 - min2 > maxDiff / 2.0) {
                    allLong = false;
                }
            }
            if (allLong && allInteger) {
                throw new InternalError();
            }
            if (allLong || allInteger) {
                long first = ((Number)keys[firstUse]).longValue();
                if (allInteger) {
                    if (first > 0L) {
                        oos.write(32);
                    } else {
                        oos.write(64);
                    }
                } else if (allLong) {
                    if (first > 0L) {
                        oos.write(96);
                    } else {
                        oos.write(128);
                    }
                } else {
                    throw new InternalError();
                }
                LongPacker.packLong(oos, Math.abs(first));
                for (int i5 = firstUse + 1; i5 < this._btree._pageSize; ++i5) {
                    if (keys[i5] == null) {
                        LongPacker.packLong(oos, 0L);
                        continue;
                    }
                    long v = ((Number)keys[i5]).longValue();
                    if (v <= first) {
                        throw new InternalError("not ordered");
                    }
                    LongPacker.packLong(oos, v - first);
                    first = v;
                }
                return;
            }
            boolean allString = true;
            for (int i6 = firstUse; i6 < this._btree._pageSize; ++i6) {
                if (keys[i6] == null || keys[i6].getClass() == String.class) continue;
                allString = false;
                break;
            }
            if (allString) {
                oos.write(160);
                byte[] previous = null;
                for (int i7 = firstUse; i7 < this._btree._pageSize; ++i7) {
                    if (keys[i7] == null) {
                        LeadingValueCompressionProvider.writeByteArray(oos, null, previous, 0);
                        continue;
                    }
                    byte[] b = ((String)keys[i7]).getBytes();
                    LeadingValueCompressionProvider.writeByteArray(oos, b, previous, 0);
                    previous = b;
                }
                return;
            }
        }
        oos.write(192);
        if (this._btree.keySerializer == null || this._btree.keySerializer == DefaultSerializer.INSTANCE) {
            for (i = firstUse; i < this._btree._pageSize; ++i) {
                DefaultSerializer.INSTANCE.serialize(oos, keys[i]);
            }
            return;
        }
        Serializer ser = this._btree.keySerializer;
        byte[] previous = null;
        byte[] buffer = new byte[1024];
        OpenByteArrayOutputStream out2 = new OpenByteArrayOutputStream(buffer);
        SerializerOutput out3 = new SerializerOutput(out2);
        for (int i8 = firstUse; i8 < this._btree._pageSize; ++i8) {
            if (keys[i8] == null) {
                LeadingValueCompressionProvider.writeByteArray(oos, null, previous, 0);
                continue;
            }
            out2.reset();
            ser.serialize(out3, keys[i8]);
            byte[] b = out2.toByteArray();
            LeadingValueCompressionProvider.writeByteArray(oos, b, previous, 0);
            previous = b;
        }
    }

    void dumpChildPageRecIDs(List out, int height) throws IOException {
        if (--height > 0) {
            for (int i = this._first; i < this._btree._pageSize; ++i) {
                if (this._children[i] == 0L) continue;
                BPage<K, V> child = this.childBPage(i);
                out.add(new Long(child._recid));
                child.dumpChildPageRecIDs(out, height);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Browser<K, V>
    implements TupleBrowser<K, V> {
        private BPage<K, V> _page;
        private int _index;

        Browser(BPage<K, V> page, int index) {
            this._page = page;
            this._index = index;
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) throws IOException {
            if (this._index < this._page._btree._pageSize) {
                if (this._page._keys[this._index] == null) {
                    return false;
                }
            } else if (this._page._next != 0L) {
                this._page = ((BPage)this._page).loadBPage(this._page._next);
                this._index = this._page._first;
            }
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            ++this._index;
            return true;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) throws IOException {
            if (this._index == this._page._first) {
                if (this._page._previous != 0L) {
                    this._page = ((BPage)this._page).loadBPage(this._page._previous);
                    this._index = this._page._btree._pageSize;
                } else {
                    return false;
                }
            }
            --this._index;
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RemoveResult<K, V> {
        boolean _underflow;
        V _value;

        RemoveResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InsertResult<K, V> {
        BPage<K, V> _overflow;
        V _existing;

        InsertResult() {
        }
    }
}

