/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import java.util.Properties;
import jcckit.GraphicsPlotCanvas;
import jcckit.data.DataCurve;
import jcckit.data.DataElement;
import jcckit.data.DataPlot;
import jcckit.data.DataPoint;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Rectangle;
import jcckit.graphic.ShapeAttributes;
import jcckit.plot.CartesianCoordinateSystem;
import jcckit.plot.CoordinateSystem;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.PropertiesBasedConfigData;

public class ZoomExample
extends Applet {
    private static double X_MIN_DEFAULT = -1.1;
    private static double X_MAX_DEFAULT = 1.1;
    private static double Y_MIN_DEFAULT = -1.1;
    private static double Y_MAX_DEFAULT = 1.1;
    private static final int NUMBER_OF_ITERATIONS = 6;
    private static final double H = 1.0 / (2.0 * Math.sqrt(3.0));
    private static final ShapeAttributes MARKER_ATTRIBUTES = new ShapeAttributes(null, Color.gray, 0.0, null);
    private GraphicsPlotCanvas _plotCanvas;
    private GraphPoint _anchor;
    private MouseListener _mouseListener = new 1();
    private MouseMotionListener _mouseMotionListener = new 2();

    public void init() {
        this.createPlotCanvas();
        this._plotCanvas.connect(this.createData());
        this.setLayout(new BorderLayout());
        Canvas canvas = this._plotCanvas.getGraphicsCanvas();
        canvas.addMouseListener(this._mouseListener);
        canvas.addMouseMotionListener(this._mouseMotionListener);
        this.add((Component)canvas, "Center");
        this.resetViewWindow();
    }

    private void createPlotCanvas() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("background", "0xffffff");
        ((Hashtable)properties).put("paper", "0 0 1 1");
        ((Hashtable)properties).put("plot/legendVisible", "false");
        this._plotCanvas = new GraphicsPlotCanvas(new ConfigParameters((ConfigData)new PropertiesBasedConfigData(properties)));
    }

    private void resetViewWindow() {
        this.setCoordinateSystem(X_MIN_DEFAULT, Y_MIN_DEFAULT, X_MAX_DEFAULT, Y_MAX_DEFAULT);
    }

    private void setCoordinateSystem(double d, double d2, double d3, double d4) {
        Properties properties = new Properties();
        ((Hashtable)properties).put("xAxis/minimum", Double.toString(d));
        ((Hashtable)properties).put("xAxis/maximum", Double.toString(d3));
        ((Hashtable)properties).put("xAxis/ticLabelFormat", "%1.3f");
        ((Hashtable)properties).put("xAxis/axisLabel", "");
        ((Hashtable)properties).put("yAxis/minimum", Double.toString(d2));
        ((Hashtable)properties).put("yAxis/maximum", Double.toString(d4));
        ((Hashtable)properties).put("yAxis/ticLabelFormat", "%1.3f");
        ((Hashtable)properties).put("yAxis/axisLabel", "");
        ((Hashtable)properties).put("yAxis/axisLength", "0.8");
        CartesianCoordinateSystem cartesianCoordinateSystem = new CartesianCoordinateSystem(new ConfigParameters((ConfigData)new PropertiesBasedConfigData(properties)));
        this._plotCanvas.getPlot().setCoordinateSystem((CoordinateSystem)cartesianCoordinateSystem);
    }

    private DataPlot createData() {
        DataPlot dataPlot = new DataPlot();
        DataCurve dataCurve = new DataCurve("");
        DataPoint dataPoint = new DataPoint(-3.0 * H, 0.5);
        DataPoint dataPoint2 = new DataPoint(3.0 * H, 0.5);
        DataPoint dataPoint3 = new DataPoint(0.0, -1.0);
        this.makeKochCurve(dataCurve, dataPoint, dataPoint2, 6);
        this.makeKochCurve(dataCurve, dataPoint2, dataPoint3, 6);
        this.makeKochCurve(dataCurve, dataPoint3, dataPoint, 6);
        dataPlot.addElement((DataElement)dataCurve);
        return dataPlot;
    }

    private void makeKochCurve(DataCurve dataCurve, DataPoint dataPoint, DataPoint dataPoint2, int n) {
        if (n == 0) {
            dataCurve.addElement((DataElement)dataPoint);
            dataCurve.addElement((DataElement)dataPoint2);
            return;
        }
        --n;
        double d = dataPoint.getX();
        double d2 = dataPoint.getY();
        double d3 = dataPoint2.getX() - d;
        double d4 = dataPoint2.getY() - d2;
        DataPoint dataPoint3 = new DataPoint(d + d3 / 3.0, d2 + d4 / 3.0);
        DataPoint dataPoint4 = new DataPoint(d + d3 / 2.0 - H * d4, d2 + d4 / 2.0 + H * d3);
        DataPoint dataPoint5 = new DataPoint(d + 2.0 * d3 / 3.0, d2 + 2.0 * d4 / 3.0);
        this.makeKochCurve(dataCurve, dataPoint, dataPoint3, n);
        this.makeKochCurve(dataCurve, dataPoint3, dataPoint4, n);
        this.makeKochCurve(dataCurve, dataPoint4, dataPoint5, n);
        this.makeKochCurve(dataCurve, dataPoint5, dataPoint2, n);
    }

    private GraphPoint getPosition(MouseEvent mouseEvent) {
        return this._plotCanvas.mapCursorPosition(mouseEvent.getX(), mouseEvent.getY());
    }

    private void drawMarker(GraphPoint graphPoint) {
        double d = this._anchor.getX();
        double d2 = this._anchor.getY();
        double d3 = graphPoint.getX();
        double d4 = graphPoint.getY();
        GraphPoint graphPoint2 = new GraphPoint(0.5 * (d + d3), 0.5 * (d2 + d4));
        this.setMarker((GraphicalElement)new Rectangle(graphPoint2, Math.abs(d3 - d), Math.abs(d4 - d2), (GraphicAttributes)MARKER_ATTRIBUTES));
    }

    private void setMarker(GraphicalElement graphicalElement) {
        this._plotCanvas.setMarker(graphicalElement);
        this._plotCanvas.getGraphicsCanvas().repaint();
    }

    private void changeViewingWindow(GraphPoint graphPoint) {
        double d;
        double d2;
        double d3;
        DataPoint dataPoint = this._plotCanvas.getPlot().transform(this._anchor);
        DataPoint dataPoint2 = this._plotCanvas.getPlot().transform(graphPoint);
        double d4 = dataPoint.getX();
        if (d4 > (d3 = dataPoint2.getX())) {
            d4 = dataPoint2.getX();
            d3 = dataPoint.getX();
        }
        if ((d2 = dataPoint.getY()) > (d = dataPoint2.getY())) {
            d2 = dataPoint2.getY();
            d = dataPoint.getY();
        }
        this.setMarker(null);
        if (d4 != d3 && d2 != d) {
            this.setCoordinateSystem(d4, d2, d3, d);
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                ZoomExample.this.resetViewWindow();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ZoomExample.this._anchor = ZoomExample.this.getPosition(mouseEvent);
            ZoomExample.this.drawMarker(ZoomExample.this._anchor);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ZoomExample.this.changeViewingWindow(ZoomExample.this.getPosition(mouseEvent));
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            ZoomExample.this.drawMarker(ZoomExample.this.getPosition(mouseEvent));
        }

        /* synthetic */ 2() {
        }
    }
}

