/*
 * Decompiled with CFR 0.152.
 */
package jcckit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import jcckit.GraphicsPlotCanvas;
import jcckit.GraphicsPlotCanvas2;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.Renderer;
import jcckit.renderer.Graphics2DRenderer;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class Graphics2DPlotCanvas
extends GraphicsPlotCanvas2 {
    public static final String ANTI_ALIASINGD_KEY = "antiAliasing";
    private static final AffineTransform IDENTITY = new AffineTransform();
    protected String _renderer = "jcckit.renderer.Graphics2DRenderer";
    private AffineTransform _transformation;
    private final boolean _antiAliasing;

    public Graphics2DPlotCanvas(ConfigParameters config) {
        super(config);
        this._antiAliasing = config.getBoolean(ANTI_ALIASINGD_KEY, true);
        this.setRenderer("jcckit.renderer.Graphics2DRenderer");
    }

    protected void createGraphicsCanvas() {
        this._canvas = new Graphics2DCanvas();
    }

    protected void createGraphicsJPanel() {
        this._jPanel = new Graphics2DJPanel();
    }

    public void draw2DInto(Image image) {
        this._jPanel.setSize(image.getWidth(null), image.getHeight(null));
        this._jPanel.update(image.getGraphics());
    }

    public GraphPoint mapCursorPosition(int x, int y) {
        double[] coordinates = new double[]{x, y, 0.0, 0.0};
        try {
            this._transformation.inverseTransform(coordinates, 0, coordinates, 2, 1);
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        return new GraphPoint(coordinates[2], coordinates[3]);
    }

    public static void main(String[] args) throws Exception {
        GraphicsPlotCanvas.run(args, "jcckit.Graphics2DPlotCanvas");
    }

    protected class Graphics2DJPanel
    extends GraphicsPlotCanvas2.GraphicsJPanel {
        public Graphics2DJPanel() {
            super(Graphics2DPlotCanvas.this);
            this._painter = new Graphics2DPainter((Component)this);
        }
    }

    protected class Graphics2DCanvas
    extends GraphicsPlotCanvas.GraphicsCanvas {
        public Graphics2DCanvas() {
            super(Graphics2DPlotCanvas.this);
            this._painter = new Graphics2DPainter((Component)this);
        }
    }

    protected class Graphics2DPainter
    extends GraphicsPlotCanvas.GraphicsPainter {
        public Graphics2DPainter(Component component) {
            super(Graphics2DPlotCanvas.this, component);
        }

        protected void prepare(Graphics g) {
            ((Graphics2D)g).setTransform(IDENTITY);
        }

        protected Renderer createRenderer(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, Graphics2DPlotCanvas.this._antiAliasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setTransform(Graphics2DPlotCanvas.this._transformation);
            return ((Graphics2DRenderer)Factory.create(Graphics2DPlotCanvas.this._renderer)).init((Graphics2D)g);
        }

        protected void calculateTransformation(Dimension size) {
            double pWidth = Graphics2DPlotCanvas.this.getPaper().getMaxX() - Graphics2DPlotCanvas.this.getPaper().getMinX();
            double pHeight = Graphics2DPlotCanvas.this.getPaper().getMaxY() - Graphics2DPlotCanvas.this.getPaper().getMinY();
            double scale = Math.min((double)size.width / pWidth, (double)size.height / pHeight);
            double x0 = 0.5 * (double)Graphics2DPlotCanvas.this.getHorizontalAnchor().getFactor() * ((double)size.width - scale * pWidth) + scale * Graphics2DPlotCanvas.this.getPaper().getMinX();
            double y0 = 0.5 * (double)Graphics2DPlotCanvas.this.getVerticalAnchor().getFactor() * (scale * pHeight - (double)size.height) + (double)size.height + scale * Graphics2DPlotCanvas.this.getPaper().getMinY();
            Graphics2DPlotCanvas.this._transformation = new AffineTransform(scale, 0.0, 0.0, -scale, x0, y0);
        }
    }
}

