/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Brusselator {
    private double _noiseFactor = 0.001;
    private double _alpha;
    private double _beta;
    private double _d;
    private double _time;
    private final double[] _u;
    private final double[] _v;
    private final double[] _du;
    private final double[] _dv;
    private final double _dx;
    private final double _dt;
    private ActionListener _listener;

    public Brusselator(double d, double d2, double d3) {
        this._dx = d;
        this._dt = d2;
        this._u = new double[(int)(d3 / d + 0.5)];
        this._v = new double[this._u.length];
        this._du = new double[this._u.length];
        this._dv = new double[this._u.length];
        this.reset();
        this.addNoise();
    }

    public void addActionListener(ActionListener actionListener) {
        this._listener = AWTEventMulticaster.add(this._listener, actionListener);
    }

    private void notifyListeners(ActionEvent actionEvent) {
        if (this._listener != null) {
            this._listener.actionPerformed(actionEvent);
        }
    }

    public double getDx() {
        return this._dx;
    }

    public double getDt() {
        return this._dt;
    }

    public double getTime() {
        return this._time;
    }

    public void setTime(double d) {
        this._time = d;
    }

    public void setNoiseFactor(double d) {
        this._noiseFactor = d;
    }

    public void setAlpha(double d) {
        this._alpha = d;
    }

    public void setBeta(double d) {
        this._beta = d;
    }

    public void setD(double d) {
        this._d = d;
    }

    public int getNumberOfPoints() {
        return this._u.length;
    }

    public double getU(int n) {
        return this._u[n];
    }

    public void setU(int n, double d) {
        this._u[n] = d;
    }

    public double getV(int n) {
        return this._v[n];
    }

    public void setV(int n, double d) {
        this._v[n] = d;
    }

    public void reset() {
        int n = 0;
        while (n < this._u.length) {
            this._u[n] = this._beta;
            this._v[n] = this._alpha / Math.max(0.01, this._beta);
            ++n;
        }
        this._time = 0.0;
        this.notifyListeners(new ActionEvent(this, 0, "reset"));
    }

    public void addNoise() {
        int n = 0;
        while (n < this._u.length) {
            int n2 = n;
            this._u[n2] = this._u[n2] * (1.0 + (0.5 - Math.random()) * this._noiseFactor);
            int n3 = n++;
            this._v[n3] = this._v[n3] * (1.0 + (0.5 - Math.random()) * this._noiseFactor);
        }
        this._time = 0.0;
        this.notifyListeners(new ActionEvent(this, 0, "state changed"));
    }

    public void next() {
        int n = (int)(this._dt / (this._dx * this._dx / (2.5 * Math.max(1.0, this._d)))) + 1;
        double d = this._dt / (double)n;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            int n4 = this._u.length;
            while (n3 < n4) {
                this._du[n3] = (this._u[(n3 + n4 - 1) % n4] - 2.0 * this._u[n3] + this._u[(n3 + 1) % n4]) / (this._dx * this._dx) + this._beta + this._u[n3] * (this._u[n3] * this._v[n3] - 1.0 - this._alpha);
                this._dv[n3] = this._d * (this._v[(n3 + n4 - 1) % n4] - 2.0 * this._v[n3] + this._v[(n3 + 1) % n4]) / (this._dx * this._dx) + this._u[n3] * (this._alpha - this._u[n3] * this._v[n3]);
                ++n3;
            }
            int n5 = 0;
            int n6 = this._u.length;
            while (n5 < n6) {
                int n7 = n5;
                this._u[n7] = this._u[n7] + d * this._du[n5];
                int n8 = n5;
                this._v[n8] = this._v[n8] + d * this._dv[n5];
                ++n5;
            }
            ++n2;
        }
        this._time += this._dt;
        this.notifyListeners(new ActionEvent(this, 0, "state changed"));
    }
}

