/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Iterator;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;

public class Update
extends Message {
    private Name origin;
    private int dclass;

    public Update(Name zone, int dclass) {
        if (!zone.isAbsolute()) {
            throw new RelativeNameException(zone);
        }
        DClass.check(dclass);
        this.getHeader().setOpcode((byte)5);
        Record soa = Record.newRecord(zone, 6, 1);
        this.addRecord(soa, 0);
        this.origin = zone;
        this.dclass = dclass;
    }

    public Update(Name zone) {
        this(zone, 1);
    }

    private void newPrereq(Record rec) {
        this.addRecord(rec, 1);
    }

    private void newUpdate(Record rec) {
        this.addRecord(rec, 2);
    }

    public void present(Name name) {
        this.newPrereq(Record.newRecord(name, 255, 255, 0L));
    }

    public void present(Name name, int type) {
        this.newPrereq(Record.newRecord(name, type, 255, 0L));
    }

    public void present(Name name, int type, String record) throws IOException {
        this.newPrereq(Record.fromString(name, type, this.dclass, 0L, record, this.origin));
    }

    public void present(Name name, int type, Tokenizer tokenizer) throws IOException {
        this.newPrereq(Record.fromString(name, type, this.dclass, 0L, tokenizer, this.origin));
    }

    public void present(Record record) {
        this.newPrereq(record);
    }

    public void absent(Name name) {
        this.newPrereq(Record.newRecord(name, 255, 254, 0L));
    }

    public void absent(Name name, int type) {
        this.newPrereq(Record.newRecord(name, type, 254, 0L));
    }

    public void add(Name name, int type, long ttl, String record) throws IOException {
        this.newUpdate(Record.fromString(name, type, this.dclass, ttl, record, this.origin));
    }

    public void add(Name name, int type, long ttl, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString(name, type, this.dclass, ttl, tokenizer, this.origin));
    }

    public void add(Record record) {
        this.newUpdate(record);
    }

    public void add(Record[] records) {
        int i = 0;
        while (i < records.length) {
            this.add(records[i]);
            ++i;
        }
    }

    public void add(RRset rrset) {
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.add((Record)it.next());
        }
    }

    public void delete(Name name) {
        this.newUpdate(Record.newRecord(name, 255, 255, 0L));
    }

    public void delete(Name name, int type) {
        this.newUpdate(Record.newRecord(name, type, 255, 0L));
    }

    public void delete(Name name, int type, String record) throws IOException {
        this.newUpdate(Record.fromString(name, type, 254, 0L, record, this.origin));
    }

    public void delete(Name name, int type, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString(name, type, 254, 0L, tokenizer, this.origin));
    }

    public void delete(Record record) {
        this.newUpdate(record.withDClass(254, 0L));
    }

    public void delete(Record[] records) {
        int i = 0;
        while (i < records.length) {
            this.delete(records[i]);
            ++i;
        }
    }

    public void delete(RRset rrset) {
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.delete((Record)it.next());
        }
    }

    public void replace(Name name, int type, long ttl, String record) throws IOException {
        this.delete(name, type);
        this.add(name, type, ttl, record);
    }

    public void replace(Name name, int type, long ttl, Tokenizer tokenizer) throws IOException {
        this.delete(name, type);
        this.add(name, type, ttl, tokenizer);
    }

    public void replace(Record record) {
        this.delete(record.getName(), record.getType());
        this.add(record);
    }

    public void replace(Record[] records) {
        int i = 0;
        while (i < records.length) {
            this.replace(records[i]);
            ++i;
        }
    }

    public void replace(RRset rrset) {
        this.delete(rrset.getName(), rrset.getType());
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.add((Record)it.next());
        }
    }
}

