/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base16;
import org.xbill.DNS.utils.base64;
import org.xbill.DNS.utils.hmacSigner;

public class TSIG {
    public static final Name HMAC = Name.fromConstantString("HMAC-MD5.SIG-ALG.REG.INT.");
    public static final short FUDGE = 300;
    private Name name;
    private Name alg;
    private byte[] key;

    public TSIG(Name name, byte[] key) {
        this.name = name;
        this.alg = HMAC;
        this.key = key;
    }

    public TSIG(String name, String key) {
        Name keyname;
        byte[] keyArray = key.length() > 1 && key.charAt(0) == ':' ? base16.fromString(key.substring(1)) : base64.fromString(key);
        if (keyArray == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            keyname = Name.fromString(name, Name.root);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.name = keyname;
        this.alg = HMAC;
        this.key = keyArray;
    }

    public TSIGRecord generate(Message m, byte[] b, byte error, TSIGRecord old) {
        int fudge;
        Date timeSigned = error != 18 ? new Date() : old.getTimeSigned();
        hmacSigner h = null;
        if (error == 0 || error == 18) {
            h = new hmacSigner(this.key);
        }
        if ((fudge = Options.intValue("tsigfudge")) < 0 || fudge > Short.MAX_VALUE) {
            fudge = 300;
        }
        if (old != null) {
            DataByteOutputStream dbs = new DataByteOutputStream();
            dbs.writeUnsignedShort(old.getSignature().length);
            if (h != null) {
                h.addData(dbs.toByteArray());
                h.addData(old.getSignature());
            }
        }
        if (h != null) {
            h.addData(b);
        }
        DataByteOutputStream out = new DataByteOutputStream();
        this.name.toWireCanonical(out);
        out.writeShort(255);
        out.writeInt(0);
        this.alg.toWireCanonical(out);
        long time = timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeUnsignedShort(timeHigh);
        out.writeUnsignedInt(timeLow);
        out.writeUnsignedShort(fudge);
        out.writeShort(error);
        out.writeShort(0);
        if (h != null) {
            h.addData(out.toByteArray());
        }
        byte[] signature = h != null ? h.sign() : new byte[]{};
        byte[] other = null;
        if (error == 18) {
            out = new DataByteOutputStream();
            time = new Date().getTime() / 1000L;
            timeHigh = (int)(time >> 32);
            timeLow = time & 0xFFFFFFFFL;
            out.writeUnsignedShort(timeHigh);
            out.writeUnsignedInt(timeLow);
            other = out.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m.getHeader().getID(), error, other);
    }

    public void apply(Message m, byte error, TSIGRecord old) {
        TSIGRecord r = this.generate(m, m.toWire(), error, old);
        m.addRecord(r, 3);
    }

    public void apply(Message m, TSIGRecord old) {
        this.apply(m, (byte)0, old);
    }

    public void applyStream(Message m, TSIGRecord old, boolean first) {
        if (first) {
            this.apply(m, old);
            return;
        }
        Date timeSigned = new Date();
        hmacSigner h = new hmacSigner(this.key);
        int fudge = Options.intValue("tsigfudge");
        if (fudge < 0 || fudge > Short.MAX_VALUE) {
            fudge = 300;
        }
        DataByteOutputStream dbs = new DataByteOutputStream();
        dbs.writeUnsignedShort(old.getSignature().length);
        h.addData(dbs.toByteArray());
        h.addData(old.getSignature());
        h.addData(m.toWire());
        DataByteOutputStream out = new DataByteOutputStream();
        long time = timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeUnsignedShort(timeHigh);
        out.writeUnsignedInt(timeLow);
        out.writeUnsignedShort(fudge);
        h.addData(out.toByteArray());
        byte[] signature = h.sign();
        byte[] other = null;
        TSIGRecord r = new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m.getHeader().getID(), 0, other);
        m.addRecord(r, 3);
    }

    public byte verify(Message m, byte[] b, int length, TSIGRecord old) {
        TSIGRecord tsig = m.getTSIG();
        hmacSigner h = new hmacSigner(this.key);
        if (tsig == null) {
            return 1;
        }
        if (!tsig.getName().equals(this.name) || !tsig.getAlgorithm().equals(this.alg)) {
            if (Options.check("verbose")) {
                System.err.println("BADKEY failure");
            }
            return 17;
        }
        long now = System.currentTimeMillis();
        long then = tsig.getTimeSigned().getTime();
        long fudge = tsig.getFudge();
        if (Math.abs(now - then) > fudge * 1000L) {
            if (Options.check("verbose")) {
                System.err.println("BADTIME failure");
            }
            return 18;
        }
        try {
            if (old != null && tsig.getError() != 17 && tsig.getError() != 16) {
                DataByteOutputStream dbs = new DataByteOutputStream();
                dbs.writeUnsignedShort(old.getSignature().length);
                h.addData(dbs.toByteArray());
                h.addData(old.getSignature());
            }
            m.getHeader().decCount(3);
            byte[] header = m.getHeader().toWire();
            m.getHeader().incCount(3);
            h.addData(header);
            int len = m.tsigstart - header.length;
            h.addData(b, header.length, len);
            DataByteOutputStream out = new DataByteOutputStream();
            tsig.getName().toWireCanonical(out);
            out.writeShort(tsig.dclass);
            out.writeUnsignedInt(tsig.ttl);
            tsig.getAlgorithm().toWireCanonical(out);
            long time = tsig.getTimeSigned().getTime() / 1000L;
            int timeHigh = (int)(time >> 32);
            long timeLow = time & 0xFFFFFFFFL;
            out.writeUnsignedShort(timeHigh);
            out.writeUnsignedInt(timeLow);
            out.writeShort(tsig.getFudge());
            out.writeShort(tsig.getError());
            if (tsig.getOther() != null) {
                out.writeShort(tsig.getOther().length);
                out.write(tsig.getOther());
            } else {
                out.writeShort(0);
            }
            h.addData(out.toByteArray());
        }
        catch (IOException e) {
            return 2;
        }
        if (h.verify(tsig.getSignature())) {
            return 0;
        }
        if (Options.check("verbose")) {
            System.err.println("BADSIG failure");
        }
        return 16;
    }

    public byte verify(Message m, byte[] b, TSIGRecord old) {
        return this.verify(m, b, b.length, old);
    }

    public int recordLength() {
        return this.name.length() + 10 + HMAC.length() + 8 + 18 + 4 + 8;
    }

    static {
        if (Options.check("verbosehmac")) {
            hmacSigner.verbose = true;
        }
    }

    public static class StreamVerifier {
        private TSIG key;
        private hmacSigner verifier;
        private int nresponses;
        private int lastsigned;
        private TSIGRecord lastTSIG;

        public StreamVerifier(TSIG tsig, TSIGRecord old) {
            this.key = tsig;
            this.verifier = new hmacSigner(this.key.key);
            this.nresponses = 0;
            this.lastTSIG = old;
        }

        public byte verify(Message m, byte[] b) {
            TSIGRecord tsig = m.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                byte result = this.key.verify(m, b, this.lastTSIG);
                if (result == 0) {
                    byte[] signature = tsig.getSignature();
                    DataByteOutputStream dbs = new DataByteOutputStream();
                    dbs.writeUnsignedShort(signature.length);
                    this.verifier.addData(dbs.toByteArray());
                    this.verifier.addData(signature);
                }
                this.lastTSIG = tsig;
                return result;
            }
            if (tsig != null) {
                m.getHeader().decCount(3);
            }
            byte[] header = m.getHeader().toWire();
            if (tsig != null) {
                m.getHeader().incCount(3);
            }
            this.verifier.addData(header);
            int len = tsig == null ? b.length - header.length : m.tsigstart - header.length;
            this.verifier.addData(b, header.length, len);
            if (tsig == null) {
                boolean required;
                boolean bl = required = this.nresponses - this.lastsigned >= 100;
                if (required) {
                    return 1;
                }
                return 0;
            }
            this.lastsigned = this.nresponses;
            this.lastTSIG = tsig;
            if (!tsig.getName().equals(this.key.name) || !tsig.getAlgorithm().equals(this.key.alg)) {
                if (Options.check("verbose")) {
                    System.err.println("BADKEY failure");
                }
                return 17;
            }
            DataByteOutputStream out = new DataByteOutputStream();
            long time = tsig.getTimeSigned().getTime() / 1000L;
            int timeHigh = (int)(time >> 32);
            long timeLow = time & 0xFFFFFFFFL;
            out.writeUnsignedShort(timeHigh);
            out.writeUnsignedInt(timeLow);
            out.writeShort(tsig.getFudge());
            this.verifier.addData(out.toByteArray());
            if (!this.verifier.verify(tsig.getSignature())) {
                if (Options.check("verbose")) {
                    System.err.println("BADSIG failure");
                }
                return 16;
            }
            this.verifier.clear();
            DataByteOutputStream dbs = new DataByteOutputStream();
            dbs.writeUnsignedShort(tsig.getSignature().length);
            this.verifier.addData(dbs.toByteArray());
            this.verifier.addData(tsig.getSignature());
            return 0;
        }
    }
}

