/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public abstract class NS_CNAME_PTRRecord
extends Record {
    protected Name target;

    protected NS_CNAME_PTRRecord() {
    }

    protected NS_CNAME_PTRRecord(Name name, int type, int dclass, long ttl) {
        super(name, type, dclass, ttl);
    }

    public NS_CNAME_PTRRecord(Name name, int type, int dclass, long ttl, Name target) {
        super(name, type, dclass, ttl);
        if (!target.isAbsolute()) {
            throw new RelativeNameException(target);
        }
        this.target = target;
    }

    protected static Record rrFromWire(NS_CNAME_PTRRecord rec, DataByteInputStream in) throws IOException {
        if (in == null) {
            return rec;
        }
        rec.target = new Name(in);
        return rec;
    }

    protected static Record rdataFromString(NS_CNAME_PTRRecord rec, Tokenizer st, Name origin) throws IOException {
        rec.target = st.getName(origin);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.target != null) {
            sb.append(this.target);
        }
        return sb.toString();
    }

    public Name getTarget() {
        return this.target;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.target == null) {
            return;
        }
        if (this.type == 39) {
            this.target.toWire(out, null, canonical);
        } else {
            this.target.toWire(out, c, canonical);
        }
    }
}

