/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Arrays;
import java.util.Iterator;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.utils.DataByteOutputStream;

public class DNSSEC {
    public static final byte RSAMD5 = 1;
    public static final byte RSA = 1;
    public static final byte DH = 2;
    public static final byte DSA = 3;
    public static final byte RSASHA1 = 5;
    public static final byte Failed = -1;
    public static final byte Insecure = 0;
    public static final byte Secure = 1;

    private DNSSEC() {
    }

    private static void digestSIG(DataByteOutputStream out, SIGRecord sig) {
        out.writeShort(sig.getTypeCovered());
        out.writeByte(sig.getAlgorithm());
        out.writeByte(sig.getLabels());
        out.writeUnsignedInt(sig.getOrigTTL());
        out.writeInt((int)(sig.getExpire().getTime() / 1000L));
        out.writeInt((int)(sig.getTimeSigned().getTime() / 1000L));
        out.writeShort(sig.getFootprint());
        sig.getSigner().toWireCanonical(out);
    }

    public static byte[] digestRRset(SIGRecord sig, RRset rrset) {
        DataByteOutputStream out = new DataByteOutputStream();
        DNSSEC.digestSIG(out, sig);
        int size = rrset.size();
        byte[][] records = new byte[size][];
        Iterator it = rrset.rrs();
        Name name = rrset.getName();
        Name wild = null;
        if (name.labels() > sig.getLabels()) {
            wild = name.wild(name.labels() - sig.getLabels());
        }
        while (it.hasNext()) {
            Record rec = (Record)it.next();
            if (wild != null) {
                rec = rec.withName(wild);
            }
            records[--size] = rec.toWireCanonical();
        }
        Arrays.sort((Object[])records);
        int i = 0;
        while (i < records.length) {
            out.writeArray(records[i]);
            ++i;
        }
        return out.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sig, Message msg, byte[] previous) {
        DataByteOutputStream out = new DataByteOutputStream();
        DNSSEC.digestSIG(out, sig);
        if (previous != null) {
            out.writeArray(previous);
        }
        msg.toWire(out);
        return out.toByteArray();
    }
}

