/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class ARecord
extends Record {
    private static ARecord member = new ARecord();
    private int addr;

    private ARecord() {
    }

    private ARecord(Name name, int dclass, long ttl) {
        super(name, 1, dclass, ttl);
    }

    static ARecord getMember() {
        return member;
    }

    private static final int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static final int fromArray(byte[] array) {
        return ARecord.fromBytes(array[0], array[1], array[2], array[3]);
    }

    private static final String toDottedQuad(int addr) {
        StringBuffer sb = new StringBuffer();
        sb.append(addr >>> 24 & 0xFF);
        sb.append(".");
        sb.append(addr >>> 16 & 0xFF);
        sb.append(".");
        sb.append(addr >>> 8 & 0xFF);
        sb.append(".");
        sb.append(addr & 0xFF);
        return sb.toString();
    }

    public ARecord(Name name, int dclass, long ttl, InetAddress address) {
        this(name, dclass, ttl);
        this.addr = ARecord.fromArray(address.getAddress());
    }

    Record rrFromWire(Name name, int type, int dclass, long ttl, int length, DataByteInputStream in) throws IOException {
        ARecord rec = new ARecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        byte b1 = in.readByte();
        byte b2 = in.readByte();
        byte b3 = in.readByte();
        byte b4 = in.readByte();
        rec.addr = ARecord.fromBytes(b1, b2, b3, b4);
        return rec;
    }

    Record rdataFromString(Name name, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        ARecord rec = new ARecord(name, dclass, ttl);
        String s = st.getString();
        try {
            if (s.equals("@me@")) {
                InetAddress address = InetAddress.getLocalHost();
                if (address.equals(InetAddress.getByName("127.0.0.1"))) {
                    String msg = "InetAddress.getLocalHost() is broken.  Don't use @me@.";
                    throw new RuntimeException(msg);
                }
                rec.addr = ARecord.fromArray(address.getAddress());
            }
        }
        catch (UnknownHostException e) {
            throw st.exception("invalid address");
        }
        int[] addr = Address.toArray(s);
        if (addr == null) {
            throw st.exception("invalid dotted quad");
        }
        rec.addr = ARecord.fromBytes((byte)addr[0], (byte)addr[1], (byte)addr[2], (byte)addr[3]);
        return rec;
    }

    public String rdataToString() {
        return ARecord.toDottedQuad(this.addr);
    }

    public InetAddress getAddress() {
        String s = ARecord.toDottedQuad(this.addr);
        try {
            return InetAddress.getByName(s);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        out.writeByte(this.addr >>> 24 & 0xFF);
        out.writeByte(this.addr >>> 16 & 0xFF);
        out.writeByte(this.addr >>> 8 & 0xFF);
        out.writeByte(this.addr & 0xFF);
    }
}

