/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Inet6Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class A6Record
extends Record {
    private static A6Record member = new A6Record();
    private int prefixBits;
    private Inet6Address suffix;
    private Name prefix;

    private A6Record() {
    }

    private A6Record(Name name, int dclass, long ttl) {
        super(name, 38, dclass, ttl);
    }

    static A6Record getMember() {
        return member;
    }

    public A6Record(Name name, int dclass, long ttl, int prefixBits, Inet6Address suffix, Name prefix) {
        this(name, dclass, ttl);
        Record.checkU8("prefixBits", prefixBits);
        this.prefixBits = prefixBits;
        this.suffix = suffix;
        if (prefix != null && !prefix.isAbsolute()) {
            throw new RelativeNameException(prefix);
        }
        this.prefix = prefix;
    }

    Record rrFromWire(Name name, int type, int dclass, long ttl, int length, DataByteInputStream in) throws IOException {
        A6Record rec = new A6Record(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.prefixBits = in.readUnsignedByte();
        int suffixbits = 128 - rec.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        byte[] data = new byte[suffixbytes];
        in.read(data);
        rec.suffix = new Inet6Address(128 - rec.prefixBits, data);
        if (rec.prefixBits > 0) {
            rec.prefix = new Name(in);
        }
        return rec;
    }

    Record rdataFromString(Name name, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        A6Record rec = new A6Record(name, dclass, ttl);
        rec.prefixBits = st.getUInt8();
        try {
            rec.suffix = new Inet6Address(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
        if (rec.prefixBits > 0) {
            rec.prefix = st.getName(origin);
        }
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.suffix != null) {
            sb.append(this.prefixBits);
            sb.append(" ");
            sb.append(this.suffix);
            if (this.prefix != null) {
                sb.append(" ");
                sb.append(this.prefix);
            }
        }
        return sb.toString();
    }

    public int getPrefixBits() {
        return this.prefixBits;
    }

    public Inet6Address getSuffix() {
        return this.suffix;
    }

    public Name getPrefix() {
        return this.prefix;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.suffix == null) {
            return;
        }
        out.write(this.prefixBits);
        int suffixbits = 128 - this.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        byte[] data = this.suffix.toBytes();
        out.write(data, 16 - suffixbytes, suffixbytes);
        if (this.prefix != null) {
            this.prefix.toWire(out, null, canonical);
        }
    }
}

