/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import org.xbill.DNS.DClass;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.Type;

public class dig {
    static Name name = null;
    static int type = 1;
    static int dclass = 1;

    static void usage() {
        System.out.println("Usage: dig [@server] name [<type>] [<class>] [options]");
        System.exit(0);
    }

    static void doQuery(Message response, long ms) throws IOException {
        System.out.println("; java dig 0.0");
        System.out.println(response);
        System.out.println(";; Query time: " + ms + " ms");
    }

    static void doAXFR(Message response) throws IOException {
        System.out.println("; java dig 0.0 <> " + name + " axfr");
        if (response.isSigned()) {
            System.out.print(";; TSIG ");
            if (response.isVerified()) {
                System.out.println("ok");
            } else {
                System.out.println("failed");
            }
        }
        if (response.getRcode() != 0) {
            System.out.println(response);
            return;
        }
        Record[] records = response.getSectionArray(1);
        int i = 0;
        while (i < records.length) {
            System.out.println(records[i]);
            ++i;
        }
        System.out.print(";; done (");
        System.out.print(response.getHeader().getCount(1));
        System.out.print(" records, ");
        System.out.print(response.getHeader().getCount(3));
        System.out.println(" additional)");
    }

    public static void main(String[] argv) throws IOException {
        boolean printQuery;
        Resolver res;
        OPTRecord opt;
        block28: {
            opt = null;
            res = null;
            printQuery = false;
            if (argv.length < 1) {
                dig.usage();
            }
            try {
                int arg = 0;
                if (argv[arg].startsWith("@")) {
                    String server = argv[arg++].substring(1);
                    res = new SimpleResolver(server);
                } else {
                    res = new ExtendedResolver();
                }
                String nameString = argv[arg++];
                if (nameString.equals("-x")) {
                    name = ReverseMap.fromAddress(argv[arg++]);
                    type = 12;
                    dclass = 1;
                } else {
                    name = Name.fromString(nameString, Name.root);
                    type = Type.value(argv[arg]);
                    if (type < 0) {
                        type = 1;
                    } else {
                        ++arg;
                    }
                    dclass = DClass.value(argv[arg]);
                    if (dclass < 0) {
                        dclass = 1;
                    } else {
                        ++arg;
                    }
                }
                while (argv[arg].startsWith("-") && argv[arg].length() > 1) {
                    switch (argv[arg].charAt(1)) {
                        case 'p': {
                            String portStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            int port = Integer.parseInt(portStr);
                            if (port < 0 || port > 65536) {
                                System.out.println("Invalid port");
                                return;
                            }
                            res.setPort(port);
                            break;
                        }
                        case 'k': {
                            String key = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            int index = key.indexOf(47);
                            if (index < 0) {
                                res.setTSIGKey(key);
                                break;
                            }
                            res.setTSIGKey(key.substring(0, index), key.substring(index + 1));
                            break;
                        }
                        case 't': {
                            res.setTCP(true);
                            break;
                        }
                        case 'i': {
                            res.setIgnoreTruncation(true);
                            break;
                        }
                        case 'e': {
                            String ednsStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            int edns = Integer.parseInt(ednsStr);
                            if (edns < 0 || edns > 1) {
                                System.out.println("Unsupported EDNS level: " + edns);
                                return;
                            }
                            res.setEDNS(edns);
                            break;
                        }
                        case 'd': {
                            opt = new OPTRecord(1280, 0, 0, 32768);
                            break;
                        }
                        case 'q': {
                            printQuery = true;
                            break;
                        }
                        default: {
                            System.out.print("Invalid option: ");
                            System.out.println(argv[arg]);
                        }
                    }
                    ++arg;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (name != null) break block28;
                dig.usage();
            }
        }
        Record rec = Record.newRecord(name, type, dclass);
        Message query = Message.newQuery(rec);
        if (opt != null) {
            query.addRecord(opt, 3);
        }
        if (printQuery) {
            System.out.println(query);
        }
        long startTime = System.currentTimeMillis();
        Message response = res.send(query);
        long endTime = System.currentTimeMillis();
        if (type == 252) {
            dig.doAXFR(response);
        } else {
            dig.doQuery(response, endTime - startTime);
        }
    }
}

