//Copyright 2002-2003 Erwin Bolwidt. All rights reserved.
//See the file LICENSE.txt in this package for information about licensing.
package org.jaxup.tests;

import org.jaxup.JaxupWriter;
import org.jaxup.Updater;
import org.jaxup.xupdate.XUpdate;

public class DocumentModelTestData
{
    private String name;
    private Updater updater;
    private JaxupWriter writer;
    private XUpdate xupdater;
    private XMLComparator comparator;

    public DocumentModelTestData(String name, Updater updater, JaxupWriter writer)
    {
        this.name = name;
        this.updater = updater;
        this.writer = writer;
        this.xupdater = new XUpdate(updater);
        this.comparator = new XMLComparator(updater);
    }

    public XMLComparator getComparator()
    {
        return comparator;
    }

    public String getName()
    {
        return name;
    }

    public Updater getUpdater()
    {
        return updater;
    }

    public XUpdate getXUpdater()
    {
        return xupdater;
    }

    public JaxupWriter getWriter()
    {
        return writer;
    }
}
