package org.jaxup.samples.jdom;

import java.io.File;

import org.jaxen.jdom.DocumentNavigator;
import org.jaxup.jdom.JDOMDocumentUpdater;
import org.jaxup.xupdate.XUpdate;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.saxpath.SAXPathException;

public class JDomUpdateDemo
{
    public static void main(String[] args)
    {
        if (args.length != 2)
        {
            System.out.println("usage: JDomUpdateDemo <document url> " + "<update document url>");
            System.exit(1);
        }

        try
        {
            SAXBuilder builder = new SAXBuilder();

            XMLOutputter outputter = new XMLOutputter();

            Document doc = builder.build(new File(args[0]));
            System.out.println("Document: ");
            outputter.output(doc, System.out);
            System.out.println();

            Document updateDoc = builder.build(new File(args[1]));
            System.out.println("Update doc: ");
            outputter.output(updateDoc, System.out);
            System.out.println();

            XUpdate updater = new XUpdate(new JDOMDocumentUpdater(), DocumentNavigator.getInstance());
            updater.runUpdate(doc, updateDoc.getRootElement());

            System.out.println("Document   :: " + args[0]);
            System.out.println("Update doc :: " + args[1]);
            System.out.println();
            System.out.println("Updated document");
            System.out.println("----------------------------------");
            outputter.output(doc, System.out);
            System.out.println();
        }
        catch (SAXPathException e)
        {
            e.printStackTrace();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
}
