package org.jaxup.samples.dom4j;

import java.io.File;

import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jaxup.NavigatorFactory;
import org.jaxup.dom4j.Dom4JDocumentUpdater;
import org.jaxup.xupdate.XUpdate;
import org.saxpath.SAXPathException;

public class Dom4JUpdateDemo
{
    public static void main(String[] args)
    {
        if (args.length != 2)
        {
            System.out.println("usage: Dom4JUpdateDemo <document url> <update document url>");
            System.exit(1);
        }

        try
        {
            SAXReader builder = new SAXReader();

            XMLWriter outputter = new XMLWriter(System.out);

            Document doc = builder.read(new File(args[0]));
            System.out.println("Document: ");
            outputter.write(doc);
            System.out.println();

            Document updateDoc = builder.read(new File(args[1]));
            System.out.println("Update doc: ");
            outputter.write(updateDoc);
            System.out.println();

            XUpdate updater = new XUpdate(new Dom4JDocumentUpdater(), NavigatorFactory.getDom4JNavigator());
            updater.runUpdate(doc, updateDoc.getRootElement());

            System.out.println("Document   :: " + args[0]);
            System.out.println("Update doc :: " + args[1]);
            System.out.println();
            System.out.println("Updated document");
            System.out.println("----------------------------------");
            outputter.write(doc);
            System.out.println();
        }
        catch (SAXPathException e)
        {
            e.printStackTrace();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
}
