package org.jaxup.samples.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jaxen.dom.DocumentNavigator;
import org.jaxup.dom.DOMDocumentUpdater;
import org.jaxup.xupdate.XUpdate;
import org.saxpath.SAXPathException;
import org.w3c.dom.Document;

public class DOMUpdateDemo
{
    public static void main(String[] args)
    {
        if (args.length != 2)
        {
            System.out.println("usage: DOMUpdaterDemo <document url> " + "<update document url>");
            System.exit(1);
        }

        try
        {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            OutputFormat o = new OutputFormat("xml", "ISO-8859-1", true);
            o.setIndenting(true);
            o.setIndent(2);
            o.setPreserveSpace(true);
            XMLSerializer serial;

            Document doc = builder.parse(args[0]);
            serial = new XMLSerializer(System.out, o);
            System.out.println("Document: ");
            //            System.out.println(doc);
            serial.serialize(doc);
            System.out.println();

            Document updateDoc = builder.parse(args[1]);
            serial = new XMLSerializer(System.out, o);
            System.out.println("Update doc: ");
            //            System.out.println(updateDoc);
            serial.serialize(updateDoc);
            System.out.println();

            XUpdate updater = new XUpdate(new DOMDocumentUpdater(), DocumentNavigator.getInstance());
            updater.runUpdate(doc, updateDoc.getDocumentElement());

            System.out.println("Document   :: " + args[0]);
            System.out.println("Update doc :: " + args[1]);
            System.out.println();
            System.out.println("Updated document");
            System.out.println("----------------------------------");
            //            System.out.println(doc);
            serial = new XMLSerializer(System.out, o);
            serial.serialize(doc);
            System.out.println();
        }
        catch (SAXPathException e)
        {
            e.printStackTrace();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
}
