/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import javolution.Javolution;
import javolution.context.LocalContext;
import javolution.lang.ClassInitializer;
import javolution.lang.Reflection;
import javolution.text.CharSet;
import javolution.text.Cursor;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TypeFormat;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFormat<T> {
    private static final FastMap FORMATS = new FastMap().setShared(true);

    protected TextFormat() {
    }

    public static <T> TextFormat<T> getInstance(Class<T> cls) {
        LocalContext.Reference formatRef = (LocalContext.Reference)FORMATS.get(cls);
        return formatRef != null ? (TextFormat)formatRef.get() : TextFormat.searchFormat(cls);
    }

    private static TextFormat searchFormat(Class cls) {
        if (cls == null) {
            return null;
        }
        ClassInitializer.initialize(cls);
        LocalContext.Reference formatRef = (LocalContext.Reference)FORMATS.get(cls);
        return formatRef != null ? (TextFormat)formatRef.get() : TextFormat.searchFormat(TextFormat.superclassOf(cls));
    }

    private static Class superclassOf(Class cls) {
        return cls.getSuperclass();
    }

    public static <T> void setInstance(Class<T> cls, TextFormat<T> format) {
        ClassInitializer.initialize(cls);
        LocalContext.Reference<TextFormat<TextFormat<T>>> formatRef = (LocalContext.Reference<TextFormat<TextFormat<T>>>)FORMATS.get(cls);
        if (formatRef == null) {
            formatRef = new LocalContext.Reference<TextFormat<TextFormat<T>>>(format);
            FORMATS.put(cls, formatRef);
            return;
        }
        formatRef.set(format);
    }

    public abstract Appendable format(T var1, Appendable var2) throws IOException;

    public abstract T parse(CharSequence var1, Cursor var2) throws IllegalArgumentException;

    public final Appendable format(T obj, TextBuilder dest) {
        try {
            return this.format(obj, (Appendable)dest);
        }
        catch (IOException e) {
            throw new Error();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Text format(T obj) {
        TextBuilder tb = TextBuilder.newInstance();
        try {
            this.format(obj, tb);
            Text text = tb.toText();
            return text;
        }
        finally {
            TextBuilder.recycle(tb);
        }
    }

    public final T parse(CharSequence csq) throws IllegalArgumentException {
        Cursor cursor = new Cursor();
        T obj = this.parse(csq, cursor);
        if (cursor.getIndex() < csq.length()) {
            throw new IllegalArgumentException("Extraneous characters in \"" + csq + "\"");
        }
        return obj;
    }

    static {
        FORMATS.put(Boolean.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format((Boolean)obj, dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return TypeFormat.parseBoolean(csq, cursor) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        FORMATS.put(Character.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return dest.append(((Character)obj).charValue());
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return new Character(cursor.next(csq));
            }
        });
        FORMATS.put(Byte.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format(((Byte)obj).byteValue(), dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return new Byte(TypeFormat.parseByte(csq, 10, cursor));
            }
        });
        FORMATS.put(Short.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format(((Short)obj).shortValue(), dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return new Short(TypeFormat.parseShort(csq, 10, cursor));
            }
        });
        FORMATS.put(Integer.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format((Integer)obj, dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return new Integer(TypeFormat.parseInt(csq, 10, cursor));
            }
        });
        FORMATS.put(Long.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format((Long)obj, dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return new Long(TypeFormat.parseLong(csq, 10, cursor));
            }
        });
        FORMATS.put(Class.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return dest.append(Javolution.j2meToCharSeq(((Class)obj).getName()));
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                CharSequence className = cursor.nextToken(csq, CharSet.WHITESPACES);
                if (className == null) {
                    throw new IllegalArgumentException("No class name found");
                }
                try {
                    Class cls = Reflection.getClass(className);
                    return cls;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Class \"" + className + "\" not found");
                }
            }
        });
        FORMATS.put(Float.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format(((Float)obj).floatValue(), dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return new Float(TypeFormat.parseFloat(csq, cursor));
            }
        });
        FORMATS.put(Double.class, new TextFormat(){

            public Appendable format(Object obj, Appendable dest) throws IOException {
                return TypeFormat.format((Double)obj, dest);
            }

            public Object parse(CharSequence csq, Cursor cursor) {
                return new Double(TypeFormat.parseDouble(csq, cursor));
            }
        });
    }
}

