/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.lang.reflect.InvocationTargetException;
import javolution.JavolutionError;
import javolution.util.FastMap;

public final class Reflection {
    private static final FastMap _NameToClass = new FastMap();
    private static final Object[] ARRAY_0 = new Object[0];
    private static final ThreadLocal ARRAY_1 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[1];
        }
    };
    private static final ThreadLocal ARRAY_2 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[2];
        }
    };
    private static final ThreadLocal ARRAY_3 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[3];
        }
    };
    private static final ThreadLocal ARRAY_4 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[4];
        }
    };

    private Reflection() {
    }

    public static Class getClass(CharSequence name) throws ClassNotFoundException {
        Class cls = (Class)_NameToClass.get(name);
        return cls != null ? cls : Reflection.searchClass(((Object)name).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class searchClass(String name) throws ClassNotFoundException {
        Class<?> cls;
        block7: {
            cls = null;
            try {
                cls = Class.forName(name);
            }
            catch (ClassNotFoundException e0) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    cls = Class.forName(name, true, cl);
                }
                catch (ClassNotFoundException e1) {
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    cls = Class.forName(name, true, cl);
                }
                if (cls != null) break block7;
                throw new ClassNotFoundException("Cannot found class " + name);
            }
        }
        FastMap fastMap = _NameToClass;
        synchronized (fastMap) {
            _NameToClass.put(name, cls);
        }
        return cls;
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        Class cls = (Class)_NameToClass.get(name);
        return cls != null ? cls : Reflection.searchClass(name);
    }

    public static Constructor getConstructor(String signature) {
        Class[] argsTypes;
        Class theClass;
        int argStart = signature.indexOf(40) + 1;
        if (argStart < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int argEnd = signature.indexOf(41);
        if (argEnd < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        String className = signature.substring(0, argStart - 1);
        try {
            theClass = Reflection.getClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        String args = signature.substring(argStart, argEnd);
        if (args.length() == 0) {
            return new DefaultConstructor(theClass);
        }
        try {
            argsTypes = Reflection.classesFor(args);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            return new ReflectConstructor(theClass.getConstructor(argsTypes), signature);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getMethod(String signature) {
        int argStart = signature.indexOf(40) + 1;
        if (argStart < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int argEnd = signature.indexOf(41);
        if (argEnd < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        int nameStart = signature.substring(0, argStart).lastIndexOf(46) + 1;
        try {
            Class[] argsTypes;
            Class theClass;
            String className = signature.substring(0, nameStart - 1);
            try {
                theClass = Reflection.getClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            String methodName = signature.substring(nameStart, argStart - 1);
            String args = signature.substring(argStart, argEnd);
            try {
                argsTypes = Reflection.classesFor(args);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            return new ReflectMethod(theClass.getMethod(methodName, argsTypes), signature);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Class[] classesFor(String args) throws ClassNotFoundException {
        if ((args = args.trim()).length() == 0) {
            return new Class[0];
        }
        int commas = 0;
        int i = 0;
        while (true) {
            i = args.indexOf(44, i);
            if (i++ < 0) break;
            ++commas;
        }
        Class[] classes = new Class[commas + 1];
        int index = 0;
        for (int i2 = 0; i2 < commas; ++i2) {
            int sep = args.indexOf(44, index);
            classes[i2] = Reflection.classFor(args.substring(index, sep).trim());
            if (classes[i2] == null) {
                return null;
            }
            index = sep + 1;
        }
        classes[commas] = Reflection.classFor(args.substring(index).trim());
        if (classes[commas] == null) {
            return null;
        }
        return classes;
    }

    private static Class classFor(String className) throws ClassNotFoundException {
        int arrayIndex = className.indexOf("[]");
        if (arrayIndex >= 0) {
            if (className.indexOf("[][]") >= 0) {
                if (className.indexOf("[][][]") >= 0) {
                    if (className.indexOf("[][][][]") >= 0) {
                        throw new UnsupportedOperationException("The maximum array dimension is 3");
                    }
                    return Reflection.getClass("[[[" + Reflection.descriptorFor(className.substring(0, arrayIndex)));
                }
                return Reflection.getClass("[[" + Reflection.descriptorFor(className.substring(0, arrayIndex)));
            }
            return Reflection.getClass("[" + Reflection.descriptorFor(className.substring(0, arrayIndex)));
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        return Reflection.getClass(className);
    }

    private static String descriptorFor(String className) {
        if (className.equals("boolean")) {
            return "Z";
        }
        if (className.equals("byte")) {
            return "B";
        }
        if (className.equals("char")) {
            return "C";
        }
        if (className.equals("short")) {
            return "S";
        }
        if (className.equals("int")) {
            return "I";
        }
        if (className.equals("long")) {
            return "J";
        }
        if (className.equals("float")) {
            return "F";
        }
        if (className.equals("double")) {
            return "D";
        }
        return "L" + className + ";";
    }

    public static abstract class Method {
        private final Class[] _parameterTypes;

        protected Method(Class[] parameterTypes) {
            this._parameterTypes = parameterTypes;
        }

        public Class[] getParameterTypes() {
            return this._parameterTypes;
        }

        protected abstract Object execute(Object var1, Object[] var2);

        public final Object invoke(Object thisObject) {
            return this.execute(thisObject, ARRAY_0);
        }

        public final Object invoke(Object thisObject, Object arg0) {
            if (this._parameterTypes.length != 1) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_1.get();
            args[0] = arg0;
            Object result = this.execute(thisObject, args);
            args[0] = null;
            return result;
        }

        public final Object invoke(Object thisObject, Object arg0, Object arg1) {
            if (this._parameterTypes.length != 2) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_2.get();
            args[0] = arg0;
            args[1] = arg1;
            Object result = this.execute(thisObject, args);
            args[0] = null;
            args[1] = null;
            return result;
        }

        public final Object invoke(Object thisObject, Object arg0, Object arg1, Object arg2) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_3.get();
            args[0] = arg0;
            args[1] = arg1;
            args[2] = arg2;
            Object result = this.execute(thisObject, args);
            args[0] = null;
            args[1] = null;
            args[2] = null;
            return result;
        }

        public final Object invoke(Object thisObject, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_3.get();
            args[0] = arg0;
            args[1] = arg1;
            args[2] = arg2;
            args[3] = arg3;
            Object result = this.execute(thisObject, args);
            args[0] = null;
            args[1] = null;
            args[2] = null;
            args[3] = null;
            return result;
        }
    }

    public static abstract class Constructor {
        private final Class[] _parameterTypes;

        protected Constructor(Class[] parameterTypes) {
            this._parameterTypes = parameterTypes;
        }

        public Class[] getParameterTypes() {
            return this._parameterTypes;
        }

        protected abstract Object allocate(Object[] var1);

        public final Object newInstance() {
            if (this._parameterTypes.length != 0) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            return this.allocate(ARRAY_0);
        }

        public final Object newInstance(Object arg0) {
            if (this._parameterTypes.length != 1) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_1.get();
            args[0] = arg0;
            Object result = this.allocate(args);
            args[0] = null;
            return result;
        }

        public final Object newInstance(Object arg0, Object arg1) {
            if (this._parameterTypes.length != 2) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_2.get();
            args[0] = arg0;
            args[1] = arg1;
            Object result = this.allocate(args);
            args[0] = null;
            args[1] = null;
            return result;
        }

        public final Object newInstance(Object arg0, Object arg1, Object arg2) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_3.get();
            args[0] = arg0;
            args[1] = arg1;
            args[2] = arg2;
            Object result = this.allocate(args);
            args[0] = null;
            args[1] = null;
            args[2] = null;
            return result;
        }

        public final Object newInstance(Object arg0, Object arg1, Object arg2, Object arg3) {
            if (this._parameterTypes.length != 4) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = (Object[])ARRAY_4.get();
            args[0] = arg0;
            args[1] = arg1;
            args[2] = arg2;
            args[3] = arg3;
            Object result = this.allocate(args);
            args[0] = null;
            args[1] = null;
            args[2] = null;
            args[3] = null;
            return result;
        }
    }

    private static final class ReflectMethod
    extends Method {
        private final java.lang.reflect.Method _value;
        private final String _signature;

        public ReflectMethod(java.lang.reflect.Method value, String signature) {
            super(value.getParameterTypes());
            this._value = value;
            this._signature = signature;
        }

        public Object execute(Object that, Object[] args) {
            try {
                return this._value.invoke(that, args);
            }
            catch (IllegalArgumentException e) {
                throw new JavolutionError("Illegal argument for " + this._signature + " method", e);
            }
            catch (IllegalAccessException e) {
                throw new JavolutionError("Illegal access error for " + this._signature + " method", e);
            }
            catch (InvocationTargetException e) {
                throw new JavolutionError("Invocation exception for " + this._signature + " method", (InvocationTargetException)e.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " method";
        }
    }

    private static final class ReflectConstructor
    extends Constructor {
        private final java.lang.reflect.Constructor _value;
        private final String _signature;

        public ReflectConstructor(java.lang.reflect.Constructor value, String signature) {
            super(value.getParameterTypes());
            this._value = value;
            this._signature = signature;
        }

        public Object allocate(Object[] args) {
            try {
                return this._value.newInstance(args);
            }
            catch (IllegalArgumentException e) {
                throw new JavolutionError("Illegal argument for " + this._signature + " constructor", e);
            }
            catch (InstantiationException e) {
                throw new JavolutionError("Instantiation error for " + this._signature + " constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new JavolutionError("Illegal access error for " + this._signature + " constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new JavolutionError("Invocation exception  for " + this._signature + " constructor", (InvocationTargetException)e.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " constructor";
        }
    }

    private static class DefaultConstructor
    extends Constructor {
        final Class _class;

        DefaultConstructor(Class cl) {
            super(new Class[0]);
            this._class = cl;
        }

        public Object allocate(Object[] args) {
            try {
                return this._class.newInstance();
            }
            catch (InstantiationException e) {
                throw new JavolutionError("Instantiation error for " + this._class.getName() + " default constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new JavolutionError("Illegal access error for " + this._class.getName() + " constructor", e);
            }
        }

        public String toString() {
            return this._class + " default constructor";
        }
    }
}

