/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.BreakIterator;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import net.disy.commons.swing.laf.LookAndFeelUtilities;

public final class AutoWrappingLabel {
    private final JTextArea textArea;

    public AutoWrappingLabel() {
        this("");
    }

    public AutoWrappingLabel(String text) {
        this(text, 330);
    }

    public AutoWrappingLabel(String text, final int width) {
        this.textArea = new JTextArea(this, text){

            public final Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public final Dimension getPreferredSize() {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int lineCount = this.getLineCount(width, fontMetrics);
                return new Dimension(width, fontMetrics.getHeight() * lineCount + 1);
            }

            private int getLineCount(int layoutWidth, FontMetrics fontMetrics) {
                StringTokenizer tokenizer = new StringTokenizer(this.getText(), "\n", true);
                int lineCount = 0;
                boolean wasContentBefore = false;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.length() == 1 && token.charAt(0) == '\n') {
                        if (!wasContentBefore) {
                            ++lineCount;
                        }
                        wasContentBefore = false;
                        continue;
                    }
                    lineCount += this.getLineCount(token, fontMetrics, layoutWidth);
                    wasContentBefore = true;
                }
                return lineCount;
            }

            private final int getLineCount(String text, FontMetrics fontMetrics, int layoutWidth) {
                BreakIterator breaker = BreakIterator.getLineInstance();
                breaker.setText(text);
                int lineCount = 1;
                int currStart = breaker.first();
                int currEnd = breaker.next();
                while (currEnd != -1) {
                    if (fontMetrics.stringWidth(text.substring(currStart, currEnd)) >= layoutWidth) {
                        int currPrior = breaker.previous();
                        if (currPrior != currStart) {
                            currEnd = currPrior;
                        } else {
                            breaker.next();
                        }
                        ++lineCount;
                        currStart = currEnd;
                    }
                    currEnd = breaker.next();
                }
                return lineCount;
            }
        };
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        LookAndFeelUtilities.installColorsAndFont(this.textArea, "Label");
    }

    public final void setFont(Font font) {
        this.textArea.setFont(font);
    }

    public final JComponent getContent() {
        return this.textArea;
    }

    public final void setForeground(Color color) {
        this.textArea.setForeground(color);
    }

    public final void setBackground(Color color) {
        this.textArea.setBackground(color);
    }

    public final void setText(String text) {
        this.textArea.setText(text);
    }
}

