/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.message;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.Icon;
import net.disy.commons.core.message.IMessageTypeVisitor;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.icon.EmptyIcon;
import net.disy.commons.swing.icon.SwingIcons;
import net.disy.commons.swing.image.DisyCommonsSwingImageProvider;
import net.disy.commons.swing.resources.DisyCommonsSwingMessages;

public final class MessageTypeUi {
    public static final Icon errorIcon = DisyCommonsSwingImageProvider.getInstance().getImageIcon("message/small/error.gif");
    public static final Icon warningIcon = DisyCommonsSwingImageProvider.getInstance().getImageIcon("message/small/warning.gif");
    public static final Icon infoIcon = DisyCommonsSwingImageProvider.getInstance().getImageIcon("message/small/info.gif");
    public static final Icon normalIcon = new EmptyIcon(new Dimension(16, 16));
    public static final Icon questionIcon = DisyCommonsSwingImageProvider.getInstance().getImageIcon("message/small/question.gif");

    public static final Icon getIcon(MessageType type) {
        final Icon[] icon = new Icon[1];
        type.accept(new IMessageTypeVisitor(){

            public final void visitError(MessageType visitedType) {
                icon[0] = SwingIcons.getOptionPaneErrorIcon();
            }

            public final void visitNormal(MessageType visitedType) {
                icon[0] = new EmptyIcon();
            }

            public final void visitWarning(MessageType visitedType) {
                icon[0] = SwingIcons.getOptionPaneWarningIcon();
            }

            public final void visitInformation(MessageType visitedType) {
                icon[0] = SwingIcons.getOptionPaneInformationIcon();
            }

            public final void visitQuestion(MessageType visitedType) {
                icon[0] = SwingIcons.getOptionPaneQuestionIcon();
            }
        });
        return icon[0];
    }

    public static final Icon getSmallIcon(MessageType type) {
        final Icon[] icon = new Icon[1];
        type.accept(new IMessageTypeVisitor(){

            public final void visitError(MessageType visitedType) {
                icon[0] = errorIcon;
            }

            public final void visitNormal(MessageType visitedType) {
                icon[0] = normalIcon;
            }

            public final void visitWarning(MessageType visitedType) {
                icon[0] = warningIcon;
            }

            public final void visitInformation(MessageType visitedType) {
                icon[0] = infoIcon;
            }

            public final void visitQuestion(MessageType visitedType) {
                icon[0] = questionIcon;
            }
        });
        return icon[0];
    }

    public static final Color getColor(MessageType type) {
        final Color[] color = new Color[1];
        type.accept(new IMessageTypeVisitor(){

            public final void visitError(MessageType visitedType) {
                color[0] = Color.red;
            }

            public final void visitNormal(MessageType visitedType) {
                color[0] = SystemColor.textText;
            }

            public final void visitWarning(MessageType visitedType) {
                color[0] = SystemColor.textText;
            }

            public final void visitInformation(MessageType visitedType) {
                color[0] = SystemColor.textText;
            }

            public final void visitQuestion(MessageType visitedType) {
                color[0] = SystemColor.textText;
            }
        });
        return color[0];
    }

    public static final String getLabel(MessageType type) {
        final String[] label = new String[1];
        type.accept(new IMessageTypeVisitor(){

            public final void visitInformation(MessageType visitedType) {
                label[0] = DisyCommonsSwingMessages.getString("MessageTypeUi.information.label");
            }

            public final void visitWarning(MessageType visitedType) {
                label[0] = DisyCommonsSwingMessages.getString("MessageTypeUi.warning.label");
            }

            public final void visitNormal(MessageType visitedType) {
                label[0] = DisyCommonsSwingMessages.getString("MessageTypeUi.normal.label");
            }

            public final void visitError(MessageType visitedType) {
                label[0] = DisyCommonsSwingMessages.getString("MessageTypeUi.error.label");
            }

            public final void visitQuestion(MessageType visitedType) {
                label[0] = DisyCommonsSwingMessages.getString("MessageTypeUi.question.label");
            }
        });
        return label[0];
    }

    private MessageTypeUi() {
    }

    static {
        new MessageTypeUi();
    }
}

