/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.grid;

import net.disy.commons.swing.layout.grid.GridAlignment;

public final class GridDialogLayoutData {
    private GridAlignment verticalAlignment = GridAlignment.CENTER;
    private GridAlignment horizontalAlignment = GridAlignment.BEGINNING;
    private int widthHint = -1;
    private int heightHint = -1;
    private int horizontalIndent = 0;
    private int horizontalSpan = 1;
    private int verticalSpan = 1;
    private boolean grabExcessHorizontalSpace = false;
    private boolean grabExcessVerticalSpace = false;
    public static final GridDialogLayoutData FILL_HORIZONTAL;
    public static final GridDialogLayoutData FILL_BOTH;

    private static GridDialogLayoutData createRight() {
        GridDialogLayoutData rightData = new GridDialogLayoutData();
        rightData.setHorizontalAlignment(GridAlignment.END);
        return rightData;
    }

    private static GridDialogLayoutData createCenter() {
        GridDialogLayoutData centerData = new GridDialogLayoutData();
        centerData.setHorizontalAlignment(GridAlignment.CENTER);
        return centerData;
    }

    private static GridDialogLayoutData createFillVertical() {
        GridDialogLayoutData fillVerticalData = new GridDialogLayoutData();
        fillVerticalData.setVerticalAlignment(GridAlignment.FILL);
        fillVerticalData.setGrabExcessVerticalSpace(true);
        return fillVerticalData;
    }

    private static GridDialogLayoutData createFillHorizontal() {
        GridDialogLayoutData fillHorizontalData = new GridDialogLayoutData();
        fillHorizontalData.setHorizontalAlignment(GridAlignment.FILL);
        fillHorizontalData.setGrabExcessHorizontalSpace(true);
        return fillHorizontalData;
    }

    private static GridDialogLayoutData createFillBoth() {
        GridDialogLayoutData fillBothData = new GridDialogLayoutData();
        fillBothData.setHorizontalAlignment(GridAlignment.FILL);
        fillBothData.setVerticalAlignment(GridAlignment.FILL);
        fillBothData.setGrabExcessHorizontalSpace(true);
        fillBothData.setGrabExcessVerticalSpace(true);
        return fillBothData;
    }

    public GridDialogLayoutData() {
    }

    public GridDialogLayoutData(GridDialogLayoutData prototype) {
        this.heightHint = prototype.getHeightHint();
        this.horizontalAlignment = prototype.getHorizontalAlignment();
        this.horizontalIndent = prototype.getHorizontalIndent();
        this.horizontalSpan = prototype.getHorizontalSpan();
        this.verticalAlignment = prototype.getVerticalAlignment();
        this.verticalSpan = prototype.getVerticalSpan();
        this.widthHint = prototype.getWidthHint();
        this.grabExcessHorizontalSpace = prototype.isGrabExcessHorizontalSpace();
        this.grabExcessVerticalSpace = prototype.isGrabExcessVerticalSpace();
    }

    public final int getHorizontalSpan() {
        return this.horizontalSpan;
    }

    public final int getVerticalSpan() {
        return this.verticalSpan;
    }

    public final int getHorizontalIndent() {
        return this.horizontalIndent;
    }

    public final int getWidthHint() {
        return this.widthHint;
    }

    public final int getHeightHint() {
        return this.heightHint;
    }

    public final GridAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final GridAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public final boolean isGrabExcessHorizontalSpace() {
        return this.grabExcessHorizontalSpace;
    }

    public final boolean isGrabExcessVerticalSpace() {
        return this.grabExcessVerticalSpace;
    }

    public final void setGrabExcessHorizontalSpace(boolean grabExcessHorizontalSpace) {
        this.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
    }

    public final void setGrabExcessVerticalSpace(boolean grabExcessVerticalSpace) {
        this.grabExcessVerticalSpace = grabExcessVerticalSpace;
    }

    public final void setHeightHint(int heightHint) {
        this.heightHint = heightHint;
    }

    public final void setHorizontalAlignment(GridAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public final void setVerticalAlignment(GridAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public final void setWidthHint(int widthHint) {
        this.widthHint = widthHint;
    }

    static {
        GridDialogLayoutData.createRight();
        GridDialogLayoutData.createFillVertical();
        FILL_HORIZONTAL = GridDialogLayoutData.createFillHorizontal();
        FILL_BOTH = GridDialogLayoutData.createFillBoth();
        GridDialogLayoutData.createCenter();
    }
}

