/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.mousecursor;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import net.disy.commons.swing.image.ImageProvider;
import net.disy.commons.swing.mousecursor.CursorCapabilities;
import net.disy.commons.swing.mousecursor.CursorDescription;
import net.disy.commons.swing.mousecursor.CursorId;

public final class ExtendedCursor {
    private static final ImageProvider imageProvider = new ImageProvider("net/disy/commons/swing/mousecursor");
    private CursorId cursorId;
    private Cursor fallBackCursor;
    private Cursor cursor;
    private boolean initialized = false;
    private List cursorDescriptions;

    public ExtendedCursor(CursorId name) {
        this.cursorId = name;
        this.cursorDescriptions = new ArrayList();
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void addCursorDescription(CursorDescription description) {
        this.cursorDescriptions.add(description);
    }

    public final void setFallBackCursor(Cursor fallBackCursor) {
        this.fallBackCursor = fallBackCursor;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final void initialize(CursorCapabilities capabilities) {
        this.initialized = true;
        for (int i = 0; i < this.cursorDescriptions.size(); ++i) {
            CursorDescription description = (CursorDescription)this.cursorDescriptions.get(i);
            if (!description.getCapabilities().equals(capabilities)) continue;
            this.cursor = this.loadCursor(description);
            return;
        }
        this.cursor = this.getFallBackCursor();
    }

    private Cursor loadCursor(CursorDescription description) {
        Image cursorImage = imageProvider.getImage(description.getFileName());
        if (cursorImage == null) {
            return this.getFallBackCursor();
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, description.getHotSpot(), this.getCursorId().getName());
    }

    private Cursor getFallBackCursor() {
        if (this.fallBackCursor != null) {
            return this.fallBackCursor;
        }
        return Cursor.getDefaultCursor();
    }

    public final CursorId getCursorId() {
        return this.cursorId;
    }
}

