/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import net.disy.commons.swing.layout.grid.EndOfLineMarkerComponent;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.IDialogComponent;
import net.disy.commons.swing.layout.util.LayoutUtilities;

public final class GridDialogPanel {
    private final List components = new ArrayList();
    private final boolean equalWidthColumns;
    private JPanel panel;
    private final int horizontalSpacing;
    private final int verticalSpacing;

    public GridDialogPanel() {
        this(false);
    }

    public GridDialogPanel(boolean equalWidthColumns) {
        this(equalWidthColumns, LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentSpacing());
    }

    public GridDialogPanel(boolean equalWidthColumns, int horizontalSpacing, int verticalSpacing) {
        this.equalWidthColumns = equalWidthColumns;
        this.horizontalSpacing = horizontalSpacing;
        this.verticalSpacing = verticalSpacing;
    }

    public final void add(IDialogComponent component) {
        if (this.panel != null) {
            throw new IllegalStateException("Trying to add a dialog component after content has been created.");
        }
        this.components.add(component);
    }

    public final JPanel getContent() {
        if (this.panel == null) {
            int columnCount = this.getMaximumColumnCount();
            if (columnCount == 0) {
                columnCount = 1;
            }
            GridDialogLayout gridDialogLayout = new GridDialogLayout(columnCount, this.equalWidthColumns);
            gridDialogLayout.setHorizontalSpacing(this.horizontalSpacing);
            gridDialogLayout.setVerticalSpacing(this.verticalSpacing);
            this.panel = new JPanel(gridDialogLayout);
            Iterator iter = this.components.iterator();
            while (iter.hasNext()) {
                IDialogComponent component = (IDialogComponent)iter.next();
                component.fillInto(this.panel, columnCount);
                this.panel.add(new EndOfLineMarkerComponent());
            }
        }
        return this.panel;
    }

    private int getMaximumColumnCount() {
        int maxColumnCount = 0;
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            IDialogComponent component = (IDialogComponent)iter.next();
            if (component.getColumnCount() <= maxColumnCount) continue;
            maxColumnCount = component.getColumnCount();
        }
        return maxColumnCount;
    }
}

