/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.grid;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import net.disy.commons.swing.layout.grid.Grid;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridBuilder;
import net.disy.commons.swing.layout.grid.GridCell;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.GridCellSizeList;
import net.disy.commons.swing.layout.util.LayoutUtilities;

public final class GridDialogLayout
implements LayoutManager2 {
    private Map constraints = new HashMap();
    private final int columnCount;
    private int horizontalSpacing = LayoutUtilities.getComponentSpacing();
    private int verticalSpacing = LayoutUtilities.getComponentSpacing();
    private final boolean equalWidthColumns;
    private Grid grid;

    public GridDialogLayout(int columnCount, boolean equalWidthColumns) {
        if (columnCount < 1) {
            throw new IllegalArgumentException("ColumnCount must be >=1, was " + columnCount);
        }
        this.columnCount = columnCount;
        this.equalWidthColumns = equalWidthColumns;
    }

    public GridDialogLayout(int columnCount, boolean equalWidthColumns, int horizontalSpacing, int verticalSpacing) {
        this(columnCount, equalWidthColumns);
        this.setHorizontalSpacing(horizontalSpacing);
        this.setVerticalSpacing(verticalSpacing);
    }

    public final void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public final void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    public final float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public final float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public final void invalidateLayout(Container target) {
        this.grid = null;
    }

    public final void addLayoutComponent(Component comp, Object constraint) {
        if (constraint == null) {
            constraint = new GridDialogLayoutData();
        } else if (!(constraint instanceof GridDialogLayoutData)) {
            throw new IllegalArgumentException("GridDialogLayout expectes layout constraints to be instance of IGridDialogLayoutData, was " + constraint);
        }
        this.constraints.put(comp, constraint);
    }

    public final void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int i;
            if (this.grid == null) {
                this.grid = this.createGrid(parent);
            }
            Insets insets = parent.getInsets();
            this.adjustColumnWidths(parent.getWidth(), insets);
            this.adjustRowHeights(parent.getHeight(), insets);
            int x = insets.left;
            for (int i2 = 0; i2 < this.grid.getColumnCount(); ++i2) {
                if (i2 > 0) {
                    x += this.horizontalSpacing;
                }
                this.grid.getColumn(i2).setStart(x);
                int size = this.grid.getColumn(i2).getSize();
                x += size;
            }
            int y = insets.top;
            for (i = 0; i < this.grid.getRowCount(); ++i) {
                if (i > 0) {
                    y += this.verticalSpacing;
                }
                this.grid.getRow(i).setStart(y);
                int size = this.grid.getRow(i).getSize();
                y += size;
            }
            for (i = 0; i < this.grid.getCellCount(); ++i) {
                GridCell cell = this.grid.getCell(i);
                int x0 = this.grid.getColumn(cell.getColumnIndex()).getStart();
                int y0 = this.grid.getRow(cell.getRowIndex()).getStart();
                int width = GridDialogLayout.getActualSize(this.grid.getColumns(), cell.getColumnIndex(), cell.getColumnSpan(), this.horizontalSpacing);
                int height = GridDialogLayout.getActualSize(this.grid.getRows(), cell.getRowIndex(), cell.getRowSpan(), this.verticalSpacing);
                this.layoutCell(cell, new Rectangle(x0, y0, width, height));
            }
            return;
        }
    }

    private void adjustColumnWidths(int availableWidth, Insets insets) {
        GridCellSizeList grabbingColumns;
        if (this.grid.getColumns().size() == 0) {
            return;
        }
        if (this.equalWidthColumns) {
            GridCellSizeList grabbingColumns2;
            this.grid.makeColumnsEqualWidth();
            this.grid.getColumns().adjustToPreferredSizes();
            int remainder = availableWidth - this.grid.getTotalPreferredWidth(this.horizontalSpacing, insets);
            if (remainder < 0) {
                this.grid.getColumns().increaseSizes(remainder);
            } else if (remainder > 0 && (grabbingColumns2 = this.grid.getGrabbingColumnSizes()).size() > 0) {
                this.grid.getColumns().increaseSizes(remainder);
            }
            return;
        }
        this.grid.getColumns().adjustToPreferredSizes();
        int remainder = availableWidth - this.grid.getTotalPreferredWidth(this.horizontalSpacing, insets);
        if (remainder < 0) {
            GridCellSizeList grabbingColumns3 = this.grid.getGrabbingColumnSizes();
            if (grabbingColumns3.size() > 0) {
                grabbingColumns3.increaseSizes(remainder);
                remainder = availableWidth - this.grid.getTotalWidth(this.horizontalSpacing, insets);
                if (remainder < 0 && this.grid.getNonGrabbingColumnSizes().size() > 0) {
                    this.grid.getNonGrabbingColumnSizes().increaseSizes(remainder);
                }
            } else {
                this.grid.getColumns().increaseSizes(remainder);
            }
            return;
        }
        if (remainder > 0 && (grabbingColumns = this.grid.getGrabbingColumnSizes()).size() > 0) {
            grabbingColumns.increaseSizes(remainder);
        }
    }

    private void adjustRowHeights(int availableHeight, Insets insets) {
        GridCellSizeList grabbingRows;
        GridCellSizeList rows = this.grid.getRows();
        if (rows.size() == 0) {
            return;
        }
        rows.adjustToPreferredSizes();
        int verticalRemainder = availableHeight - this.grid.getTotalPreferredHeight(this.verticalSpacing, insets);
        if (verticalRemainder < 0) {
            GridCellSizeList grabbingRows2 = this.grid.getGrabbingRowSizes();
            if (grabbingRows2.size() > 0) {
                grabbingRows2.increaseSizes(verticalRemainder);
                verticalRemainder = availableHeight - this.grid.getTotalHeight(this.verticalSpacing, insets);
                if (verticalRemainder < 0 && this.grid.getNonGrabbingRowSizes().size() > 0) {
                    this.grid.getNonGrabbingRowSizes().increaseSizes(verticalRemainder);
                }
            } else {
                rows.increaseSizes(verticalRemainder);
            }
            return;
        }
        if (verticalRemainder > 0 && (grabbingRows = this.grid.getGrabbingRowSizes()).size() > 0) {
            grabbingRows.increaseSizes(verticalRemainder);
        }
    }

    private void layoutCell(GridCell cell, Rectangle rectangle) {
        int height;
        int y;
        int width;
        int x;
        if (!cell.getComponent().isVisible()) {
            return;
        }
        Dimension preferredSize = cell.getPreferredComponentSize();
        int preferredHeight = preferredSize.height;
        int preferredWidth = preferredSize.width;
        GridDialogLayoutData layoutData = cell.getLayoutData();
        if (layoutData.getHorizontalIndent() < rectangle.width) {
            rectangle.x += layoutData.getHorizontalIndent();
            rectangle.width -= layoutData.getHorizontalIndent();
        }
        if (layoutData.getHorizontalAlignment() == GridAlignment.BEGINNING) {
            x = rectangle.x;
            width = this.min(preferredWidth, rectangle.width);
        } else if (layoutData.getHorizontalAlignment() == GridAlignment.CENTER) {
            width = this.min(preferredWidth, rectangle.width);
            x = rectangle.x + (rectangle.width - width) / 2;
        } else if (layoutData.getHorizontalAlignment() == GridAlignment.END) {
            width = this.min(preferredWidth, rectangle.width);
            x = rectangle.x + rectangle.width - width;
        } else {
            width = rectangle.width;
            x = rectangle.x;
        }
        if (layoutData.getVerticalAlignment() == GridAlignment.BEGINNING) {
            y = rectangle.y;
            height = this.min(preferredHeight, rectangle.height);
        } else if (layoutData.getVerticalAlignment() == GridAlignment.CENTER) {
            height = this.min(preferredHeight, rectangle.height);
            y = rectangle.y + (rectangle.height - height) / 2;
        } else if (layoutData.getVerticalAlignment() == GridAlignment.END) {
            height = this.min(preferredHeight, rectangle.height);
            y = rectangle.y + rectangle.height - height;
        } else {
            height = rectangle.height;
            y = rectangle.y;
        }
        cell.getComponent().setBounds(x, y, width, height);
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private static int getActualSize(GridCellSizeList sizes, int startIndex, int span, int spacing) {
        int size = 0;
        for (int i = startIndex; i < startIndex + span; ++i) {
            size += sizes.get(i).getSize();
        }
        return size + (span - 1) * spacing;
    }

    public final void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    public final Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    public final Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    public final Dimension maximumLayoutSize(Container target) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container parent, boolean minimumSize) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            if (this.grid == null) {
                this.grid = this.createGrid(parent);
            }
            Insets insets = parent.getInsets();
            int totalWidth = minimumSize ? this.grid.getTotalMinimumWidth(this.horizontalSpacing, insets) : this.grid.getTotalPreferredWidth(this.horizontalSpacing, insets);
            int totalHeight = minimumSize ? this.grid.getTotalMinimumHeight(this.verticalSpacing, insets) : this.grid.getTotalPreferredHeight(this.verticalSpacing, insets);
            return new Dimension(totalWidth, totalHeight);
        }
    }

    private Grid createGrid(Container parent) {
        GridBuilder builder = new GridBuilder(this.columnCount);
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component component = parent.getComponent(i);
            GridDialogLayoutData layoutData = (GridDialogLayoutData)this.constraints.get(component);
            builder.add(component, layoutData);
        }
        Grid myGrid = builder.createGrid(this.horizontalSpacing, this.verticalSpacing);
        if (this.equalWidthColumns) {
            myGrid.makeColumnsEqualWidth();
        }
        return myGrid;
    }
}

