/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view.fixedwidth;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.view.FontChooserPanel;
import net.disy.commons.swing.fontchooser.view.accessory.FontPreviewPanel;
import net.disy.commons.swing.fontchooser.view.accessory.IFontChooserAccessory;
import net.disy.commons.swing.fontchooser.view.fixedwidth.FixedWidthFontFamilyNameFilter;
import net.disy.commons.swing.layout.grid.GridDialogLayout;

public final class FixedWidthOptionFontChooserAccessory
implements IFontChooserAccessory {
    private JCheckBox cbFixedWidthOnly;
    private FontPreviewPanel previewPanel;
    private JComponent content;
    private FontChooserPanel fontChooserPanel;
    private JCheckBox cbNonSymbolFontsOnly;

    public FixedWidthOptionFontChooserAccessory(FontChooserPanel fontChooserPanel) {
        this.fontChooserPanel = fontChooserPanel;
        this.cbFixedWidthOnly = new JCheckBox("Show fixed width fonts only", true);
        this.cbNonSymbolFontsOnly = new JCheckBox("Hide symbol fonts", true);
        this.cbFixedWidthOnly.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                FixedWidthOptionFontChooserAccessory.this.updateFontFilter();
            }
        });
        this.cbNonSymbolFontsOnly.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                FixedWidthOptionFontChooserAccessory.this.updateFontFilter();
            }
        });
        this.updateFontFilter();
        this.previewPanel = new FontPreviewPanel(fontChooserPanel.getFontModel());
        JPanel checkBoxPanel = new JPanel(new GridDialogLayout(1, false));
        checkBoxPanel.add(this.cbFixedWidthOnly);
        checkBoxPanel.add(this.cbNonSymbolFontsOnly);
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        panel.add(this.previewPanel.getContent());
        panel.add(checkBoxPanel);
        this.content = panel;
    }

    private void updateFontFilter() {
        this.fontChooserPanel.setFontFamilyFilter(new FixedWidthFontFamilyNameFilter(this.cbFixedWidthOnly.isSelected(), this.cbNonSymbolFontsOnly.isSelected()));
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void setModel(FontModel model) {
        this.previewPanel.setModel(model);
    }
}

