/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view.accessory;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.border.TitledPanel;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.resources.DisyCommonsSwingFontChooserMessages;
import net.disy.commons.swing.fontchooser.view.accessory.IFontChooserAccessory;

public final class FontPreviewPanel
implements IFontChooserAccessory {
    private final ChangeListener changeListener = new ChangeListener(){

        public final void stateChanged(ChangeEvent e) {
            FontPreviewPanel.this.updateFont();
        }
    };
    private FontModel model;
    private JTextField textField;
    private final JComponent content;

    public FontPreviewPanel() {
        this(new FontModel(), false);
    }

    public FontPreviewPanel(FontModel model) {
        this(model, false);
    }

    public FontPreviewPanel(FontModel model, boolean defaultBorderVisible) {
        this.content = this.createContent(defaultBorderVisible);
        this.setModel(model);
    }

    public final void setModel(FontModel model) {
        Ensure.ensureArgumentNotNull(model);
        if (this.model != null) {
            this.model.removeChangeListener(this.changeListener);
        }
        this.model = model;
        model.addChangeListener(this.changeListener);
        this.updateFont();
    }

    private JComponent createContent(boolean defaultBorderVisible) {
        this.textField = new JTextField(this, DisyCommonsSwingFontChooserMessages.getString("FontPreviewPanel.previewText")){

            public final Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                super.getPreferredSize().height = 36;
                return size;
            }
        };
        if (defaultBorderVisible) {
            return new TitledPanel(DisyCommonsSwingFontChooserMessages.getString("FontPreviewPanel.sample"), this.textField);
        }
        return this.textField;
    }

    protected final void updateFont() {
        this.textField.setFont(this.model.getFont());
    }

    public final JComponent getContent() {
        return this.content;
    }
}

