/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.disy.commons.core.graphics.font.FontStyle;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.resources.DisyCommonsSwingFontChooserMessages;
import net.disy.commons.swing.fontchooser.view.AbstractFontAdjustListPanel;
import net.disy.commons.swing.fontchooser.view.DefaultFontDialogProperties;
import net.disy.commons.swing.fontchooser.view.FontStyleListCellRenderer;
import net.disy.commons.swing.fontchooser.view.FontStyleUI;

public final class FontStylePanel
extends AbstractFontAdjustListPanel {
    public FontStylePanel(FontModel fontModel, DefaultFontDialogProperties properties) {
        super(fontModel, properties);
    }

    protected final void updateFontModelView() {
        FontStyle style = this.getFontModel().getFontStyle();
        this.getTextField().setText(new FontStyleUI().getName(style));
        this.getList().setSelectedValue(style, true);
    }

    protected final String getTitle() {
        return DisyCommonsSwingFontChooserMessages.getString("FontStylePanel.style");
    }

    protected final JList createListComponent() {
        JList<FontStyle> list = new JList<FontStyle>(FontStyle.getAll());
        list.setCellRenderer(new FontStyleListCellRenderer(this.getFontModel(), this.getFontDialogProperties()));
        return list;
    }

    protected final void attachListListener() {
        this.getList().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                FontStyle fontStyle = (FontStyle)FontStylePanel.this.getList().getSelectedValue();
                if (fontStyle == null) {
                    return;
                }
                FontStylePanel.this.getFontModel().setFontStyle(fontStyle);
            }
        });
    }
}

