/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.resources.DisyCommonsSwingFontChooserMessages;
import net.disy.commons.swing.fontchooser.util.FontUtilities;
import net.disy.commons.swing.fontchooser.view.AbstractFontAdjustListPanel;
import net.disy.commons.swing.fontchooser.view.DefaultFontDialogProperties;
import net.disy.commons.swing.fontchooser.view.FontFamilyListCellRenderer;
import net.disy.commons.swing.fontchooser.view.FontFamilyNameListModel;
import net.disy.commons.swing.fontchooser.view.fixedwidth.FixedWidthFontFamilyNameFilter;

public final class FontFamilyPanel
extends AbstractFontAdjustListPanel {
    private FixedWidthFontFamilyNameFilter filter;
    private FontFamilyNameListModel listModel;

    public FontFamilyPanel(FontModel fontModel, DefaultFontDialogProperties properties) {
        super(fontModel, properties);
    }

    protected final void updateFontModelView() {
        String fontName = this.getFontModel().getFontFamilyName();
        this.getTextField().setText(fontName);
        this.getList().setSelectedValue(fontName, true);
    }

    protected final String getTitle() {
        return DisyCommonsSwingFontChooserMessages.getString("FontFamilyPanel.font");
    }

    protected final JList createListComponent() {
        this.listModel = new FontFamilyNameListModel();
        this.listModel.setFontNames(this.getAvailableFontFamilyNames());
        JList<Object> list = new JList<Object>(this.listModel);
        list.setCellRenderer(new FontFamilyListCellRenderer(this.getFontDialogProperties()));
        return list;
    }

    protected final void attachListListener() {
        this.getList().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public final void run() {
                        String fontFamilyName = (String)1.access$000(this.this$1).getList().getSelectedValue();
                        if (fontFamilyName == null) {
                            return;
                        }
                        1.access$000(this.this$1).getFontModel().setFontFamilyName(fontFamilyName);
                    }
                });
            }

            static final /* synthetic */ FontFamilyPanel access$000(1 x0) {
                return x0.FontFamilyPanel.this;
            }
        });
    }

    public final void setFontFamilyNameFilter(FixedWidthFontFamilyNameFilter filter) {
        this.filter = filter;
        this.listModel.setFontNames(this.getAvailableFontFamilyNames());
        String fontFamilyName = this.getFontModel().getFontFamilyName();
        int index = this.listModel.indexOf(fontFamilyName);
        if (index == -1) {
            this.getList().clearSelection();
            return;
        }
        this.getList().setSelectedIndex(index);
        this.getList().ensureIndexIsVisible(index);
    }

    private String[] getAvailableFontFamilyNames() {
        String[] names = FontUtilities.getAvailableFontFamilyNames();
        if (this.filter == null) {
            return names;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (!this.filter.accept(names[i])) continue;
            result.add(names[i]);
        }
        return result.toArray(new String[result.size()]);
    }
}

