/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import java.awt.Component;
import java.awt.Font;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.resources.DisyCommonsSwingFontChooserMessages;
import net.disy.commons.swing.fontchooser.view.FontChooserDialogPage;
import net.disy.commons.swing.fontchooser.view.FontChooserPanel;

public final class FontChooserDialog {
    private boolean canceled;
    private Component parentComponent;
    private FontModel fontModel;
    private FontChooserPanel fontChooserPanel;

    public FontChooserDialog(Component parentComponent, FontModel fontModel) {
        this.fontModel = fontModel;
        this.parentComponent = parentComponent;
        this.fontChooserPanel = new FontChooserPanel(fontModel);
    }

    public final FontChooserPanel getFontChooserPanel() {
        return this.fontChooserPanel;
    }

    public final void show() {
        UserDialog dialog = this.createDialog();
        dialog.show();
        if (dialog.isCanceled()) {
            this.canceled = true;
        }
    }

    public final void show(String title) {
        UserDialog dialog = this.createDialog(title);
        dialog.show();
        if (dialog.isCanceled()) {
            this.canceled = true;
        }
    }

    public final UserDialog createDialog() {
        return this.createDialog(DisyCommonsSwingFontChooserMessages.getString("FontChooserDialog.title"));
    }

    private UserDialog createDialog(String title) {
        FontChooserDialogPage page = new FontChooserDialogPage(this.fontChooserPanel, title);
        UserDialog dialog = new UserDialog(this.parentComponent, new AbstractDialogConfiguration(this, page){

            public final boolean isHeaderPanelVisible() {
                return false;
            }
        });
        return dialog;
    }

    public final FontModel getFontModel() {
        return this.fontModel;
    }

    public final Font getFont() {
        return this.getFontModel().getFont();
    }

    public final boolean isCanceled() {
        return this.canceled;
    }
}

