/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.component.AbstractActionComponent;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.view.FontChooserDialog;
import net.disy.commons.swing.fontchooser.view.button.LabelFontChooserButtonConfiguration;
import net.disy.commons.swing.fontchooser.view.fixedwidth.FixedWidthFontChooserDialogFactory;

public final class FontChooserButton
extends AbstractActionComponent {
    private final AbstractButton content;
    private final SmartAction action;

    public FontChooserButton(FontModel fontModel, FixedWidthFontChooserDialogFactory dialogFactory) {
        this(fontModel, new LabelFontChooserButtonConfiguration(), dialogFactory);
    }

    public FontChooserButton(final FontModel fontModel, LabelFontChooserButtonConfiguration configuration, final FixedWidthFontChooserDialogFactory dialogFactory) {
        Ensure.ensureArgumentNotNull(configuration);
        Ensure.ensureArgumentNotNull(fontModel);
        this.action = new SmartAction(configuration.getLabel(), configuration.getIcon()){

            protected final void execute(Component parentComponent) {
                FontModel dialogFontModel = new FontModel(fontModel.getFontDescription());
                FontChooserDialog fontChooserDialog = dialogFactory.createFontChooserDialog(parentComponent, dialogFontModel);
                fontChooserDialog.show();
                if (!fontChooserDialog.isCanceled()) {
                    fontModel.setFont(dialogFontModel.getFontDescription());
                    FontChooserButton.this.fireActionEvent();
                }
            }
        };
        JButton button = new JButton(this.action);
        button.setMargin(configuration.getInsets());
        button.setFocusPainted(configuration.isFocusPainted());
        this.content = button;
    }

    public final AbstractButton getContent() {
        return this.content;
    }
}

