/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import javax.swing.UIManager;

public final class FontUtilities {
    public static final FontRenderContext DEFAULT_FONT_RENDER_CONTEXT = new FontRenderContext(null, false, false);
    private static final Integer[] STANDARD_SIZES = new Integer[]{new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(18), new Integer(20), new Integer(22), new Integer(24), new Integer(26), new Integer(28), new Integer(36), new Integer(48), new Integer(72)};

    private FontUtilities() {
    }

    public static final Font getDefaultFont() {
        return UIManager.getFont("TextPane.font");
    }

    public static final Integer[] getStandardSizes() {
        return STANDARD_SIZES;
    }

    public static final String[] getAvailableFontFamilyNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static final boolean isFixedWidth(Font font) {
        return FontUtilities.getCharacterWidth(font, '#') == FontUtilities.getCharacterWidth(font, '|') && FontUtilities.getCharacterWidth(font, ' ') == FontUtilities.getCharacterWidth(font, '@');
    }

    private static int getCharacterWidth(Font font, char character) {
        return (int)font.getStringBounds(new char[]{character}, 0, 1, DEFAULT_FONT_RENDER_CONTEXT).getWidth();
    }

    public static final boolean isSymbolFont(Font font) {
        return font.canDisplayUpTo("abzABZ190") != -1;
    }

    public static final boolean isValidFontSize(int size) {
        return size >= 2 && size <= 200;
    }
}

