/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.userdialog;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogUi;
import net.disy.commons.swing.dialog.core.AbstractDialog;
import net.disy.commons.swing.dialog.userdialog.DefaultUserDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.DialogPageControl;
import net.disy.commons.swing.dialog.userdialog.IDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.IDialogPage;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutDirection;
import net.disy.commons.swing.util.GuiUtilities;
import net.disy.commons.swing.util.RelativePosition;

public class UserDialog
extends AbstractDialog {
    private DialogPageControl dialogControl;
    private JButton okButton;
    private JButton cancelButton;
    private boolean neverVisualized = true;
    private final RelativePosition relativePosition;

    public UserDialog(Component parent, IDialogConfiguration userDialog) {
        this(parent, userDialog, RelativePosition.CENTER);
    }

    public UserDialog(Component parent, IDialogConfiguration userDialog, RelativePosition relativePosition) {
        super(parent, userDialog);
        this.dialogControl = new DialogPageControl(userDialog.getDialogPage());
        this.dialogControl.setUserDialogContainer(this);
        this.initialize();
        this.setContent(this.dialogControl.getContent());
        this.updateAll();
        this.dialogControl.requestFocus();
        this.relativePosition = relativePosition;
    }

    public UserDialog(Component parentComponent, IDialogPage dialogPage) {
        this(parentComponent, new DefaultUserDialogConfiguration(dialogPage));
    }

    protected final IDialogConfiguration getConfiguration() {
        return (IDialogConfiguration)this.getGenericDialog();
    }

    private void updateAll() {
        this.updateDescription();
        this.updateTitle();
        this.updateMessage();
        this.updateButtons();
        this.setModal(this.getConfiguration().isModal());
    }

    public final void updateDescription() {
        this.setDescription(this.getDialogControl().getDescription());
    }

    public final void updateTitle() {
        this.setTitle(this.getDialogControl().getTitle());
    }

    public final void updateMessage() {
        this.setMessage(this.getDialogControl().getMessage());
    }

    public final void updateButtons() {
        this.okButton.setEnabled(this.getDialogControl().canFinish());
    }

    protected Component createButtonBar() {
        Component[] createdButtons = this.createButtons();
        if (createdButtons.length > 0 && createdButtons[0] instanceof JButton) {
            this.setDefaultButton((JButton)createdButtons[0]);
        }
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder(LayoutDirection.HORIZONTAL);
        for (int i = 0; i < createdButtons.length; ++i) {
            buttonPanelBuilder.add(createdButtons[i]);
        }
        return buttonPanelBuilder.createPanel();
    }

    protected final Component[] createButtons() {
        SmartAction okAction = new SmartAction(this.getConfiguration().getOkButtonText()){

            protected final void execute(Component parentComponent) {
                UserDialog.this.requestFinish();
            }
        };
        this.okButton = new JButton(okAction);
        SmartAction cancelAction = new SmartAction(this.getConfiguration().getCancelButtonText()){

            protected final void execute(Component parentComponent) {
                UserDialog.this.performCancel();
            }
        };
        this.cancelButton = new JButton(cancelAction);
        SmartAction helpAction = new SmartAction(BasicDialogUi.HELP_TEXT_PLAIN){

            protected final void execute(Component parentComponent) {
                UserDialog.this.helpPressed();
            }
        };
        JButton helpButton = new JButton(helpAction);
        ArrayList<Component> buttonList = new ArrayList<Component>();
        if (this.getConfiguration().isOkButtonAvailable()) {
            buttonList.add(this.okButton);
        }
        Component[] additionalButtons = this.getConfiguration().createAdditionalButtons();
        buttonList.addAll(Arrays.asList(additionalButtons));
        buttonList.addAll(Arrays.asList(this.createAdditionalButtons()));
        if (this.getConfiguration().isCancelAvailable()) {
            buttonList.add(this.cancelButton);
        }
        if (this.getDialogControl().isHelpAvailable()) {
            buttonList.add(helpButton);
        }
        return buttonList.toArray(new Component[buttonList.size()]);
    }

    protected Component[] createAdditionalButtons() {
        return new Component[0];
    }

    protected final boolean okPressed() {
        if (!this.getDialogControl().performOk()) {
            return false;
        }
        return this.getConfiguration().performOk(this.getDialog().getWindow());
    }

    protected final void helpPressed() {
        this.getDialogControl().performHelp();
    }

    public final DialogPageControl getDialogControl() {
        return this.dialogControl;
    }

    protected final boolean cancelPressed() {
        if (!this.getDialogControl().performCancel()) {
            return false;
        }
        return this.getConfiguration().performCancel(this.getDialog().getWindow());
    }

    public final void setVisible(boolean visible) {
        if (visible) {
            if (this.neverVisualized) {
                GuiUtilities.placeRelativeToOwner(this.getDialog().getWindow(), this.relativePosition);
                this.getDialog().show();
                this.neverVisualized = false;
                return;
            }
            this.getDialog().show();
            return;
        }
        this.getDialog().setVisible(false);
    }

    public final void show() {
        this.setVisible(true);
    }

    private void setModal(boolean modal) {
        this.getDialog().setModal(modal);
    }

    public final void requestFinish() {
        if (!this.getDialogControl().canFinish()) {
            return;
        }
        if (this.okPressed()) {
            this.closeDialog();
        }
    }

    protected final void closeDialog() {
        super.closeDialog();
    }
}

