/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogUi;
import net.disy.commons.swing.dialog.progress.InternalProgressDialogModel;
import net.disy.commons.swing.dialog.progress.ProgressMonitorBar;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.message.MessageTypeUi;
import net.disy.commons.swing.util.GuiUtilities;
import net.disy.commons.swing.widgets.AutoWrappingLabel;

public final class InternalProgressDialog
implements IProgressMonitor {
    private final ProgressMonitorBar progressBar;
    private JDialog dialog;
    private final SmartAction cancelAction;
    private final AutoWrappingLabel taskNameLabel;
    private final JLabel subTaskNameLabel;
    private boolean cancelable = false;
    private final InternalProgressDialogModel model;
    private boolean disposed = false;
    private boolean showing = false;
    private final Component parentComponent;
    private final String title;
    private final Collection canceledListeners = new ArrayList();

    public InternalProgressDialog(Component parentComponent, String title, InternalProgressDialogModel model) {
        Ensure.ensureArgumentNotNull(model);
        this.parentComponent = parentComponent;
        this.title = title;
        this.model = model;
        this.cancelAction = new SmartAction(BasicDialogUi.CANCEL_TEXT_SMART){

            protected final void execute(Component parent) {
                InternalProgressDialog.this.performCancel();
            }
        };
        this.taskNameLabel = new AutoWrappingLabel();
        this.taskNameLabel.setOpaque(false);
        this.subTaskNameLabel = new JLabel("", 2);
        this.subTaskNameLabel.setPreferredSize(new Dimension(this.subTaskNameLabel.getPreferredSize().width, 25));
        this.progressBar = new ProgressMonitorBar();
        this.progressBar.setBorderPainted(true);
    }

    private void performCancel() {
        if (this.cancelable) {
            this.setCanceled(true);
            this.cancelAction.setEnabled(false);
        }
        Thread.yield();
    }

    public final void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
        this.cancelAction.setEnabled(cancelable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show() {
        InternalProgressDialog internalProgressDialog = this;
        synchronized (internalProgressDialog) {
            if (this.disposed) {
                return;
            }
            this.showing = true;
            this.dialog = this.createDialog();
        }
        GuiUtilities.centerToParent(this.dialog);
        this.dialog.setVisible(true);
    }

    private JDialog createDialog() {
        JButton cancelButton = new JButton(this.cancelAction);
        ButtonPanelBuilder builder = new ButtonPanelBuilder();
        builder.add(cancelButton);
        Icon icon = MessageTypeUi.getIcon(MessageType.INFORMATION);
        JPanel topPanel = new JPanel(new BorderLayout(10, 8));
        topPanel.add((Component)new JLabel(icon), "West");
        topPanel.add((Component)this.taskNameLabel.getContent(), "Center");
        topPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
        JPanel mainPanel = new JPanel(new GridDialogLayout(1, false));
        mainPanel.add((Component)topPanel, GridDialogLayoutData.FILL_HORIZONTAL);
        mainPanel.add((Component)this.progressBar, GridDialogLayoutData.FILL_HORIZONTAL);
        mainPanel.add((Component)this.subTaskNameLabel, GridDialogLayoutData.FILL_HORIZONTAL);
        mainPanel.setBorder(new EmptyBorder(5, 7, 0, 7));
        JDialog newDialog = GuiUtilities.createDialog(this.parentComponent, this.title);
        newDialog.getContentPane().setLayout(new BorderLayout(2, 2));
        newDialog.getContentPane().add((Component)mainPanel, "Center");
        newDialog.getContentPane().add((Component)builder.createPanel(), "South");
        newDialog.pack();
        newDialog.setSize(Math.max(newDialog.getWidth(), 450), newDialog.getHeight());
        newDialog.setResizable(false);
        newDialog.setModal(true);
        newDialog.getRootPane().setDefaultButton(cancelButton);
        newDialog.setDefaultCloseOperation(0);
        newDialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                InternalProgressDialog.this.performCancel();
            }
        });
        return newDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        InternalProgressDialog internalProgressDialog = this;
        synchronized (internalProgressDialog) {
            this.disposed = true;
            if (this.showing) {
                while (this.dialog == null || !this.dialog.isVisible()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public final void beginTask(String name, int totalWork) {
        final String taskName = InternalProgressDialog.addTaskLabelEllipsis(name);
        this.subTask("");
        this.progressBar.beginTask(taskName, totalWork);
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                InternalProgressDialog.this.taskNameLabel.setText(taskName);
            }
        });
        Thread.yield();
    }

    public static final String addTaskLabelEllipsis(String name) {
        if (name.length() == 0) {
            return name;
        }
        if (name.endsWith("...")) {
            return name;
        }
        return name + "...";
    }

    public final void done() {
        this.progressBar.done();
        Thread.yield();
    }

    public final void setCanceled(boolean canceled) {
        this.model.setCanceled(canceled);
        if (canceled) {
            this.fireCanceled();
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCanceled() {
        ArrayList clonedListeners;
        InternalProgressDialog internalProgressDialog = this;
        synchronized (internalProgressDialog) {
            clonedListeners = new ArrayList(this.canceledListeners);
        }
        Iterator iter = clonedListeners.iterator();
        while (iter.hasNext()) {
            iter.next();
            Object var3_4 = null;
        }
    }

    public final void subTask(final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                InternalProgressDialog.this.subTaskNameLabel.setText(name);
            }
        });
        Thread.yield();
    }

    public final void worked(int work) {
        this.progressBar.worked(work);
        Thread.yield();
    }

    public final boolean isCanceled() {
        Thread.yield();
        return this.model.isCanceled();
    }
}

