/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.core.DialogHeaderPanel;
import net.disy.commons.swing.dialog.core.IDialogConstants;
import net.disy.commons.swing.dialog.core.IGenericDialogConfiguration;
import net.disy.commons.swing.dialog.core.ISwingFrameOrDialog;
import net.disy.commons.swing.dialog.core.SwingDialog;
import net.disy.commons.swing.dialog.core.SwingFrame;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.util.GuiUtilities;
import net.disy.commons.swing.widgets.HorizontalLine;

public abstract class AbstractDialog {
    private ISwingFrameOrDialog dialog;
    private JPanel contentPanel;
    private JComponent content;
    private DialogHeaderPanel headerPanel;
    private IGenericDialogConfiguration genericDialog;
    private boolean canceled = false;

    public AbstractDialog(Component parent, IGenericDialogConfiguration genericDialog) {
        Ensure.ensureArgumentNotNull(genericDialog);
        this.genericDialog = genericDialog;
        this.dialog = AbstractDialog.createFrameOrDialog(parent);
        this.dialog.setModal(true);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                AbstractDialog.this.performCancel();
            }
        });
    }

    private static ISwingFrameOrDialog createFrameOrDialog(Component parent) {
        Window window = GuiUtilities.getWindowForComponent(parent);
        if (window == null || !window.isVisible()) {
            return new SwingFrame(new JFrame("!Dialog.title!"));
        }
        return new SwingDialog(GuiUtilities.createDialog(parent, "!Dialog.title!"));
    }

    protected final void performCancel() {
        if (this.cancelPressed()) {
            this.canceled = true;
            this.closeDialog();
        }
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    protected final IGenericDialogConfiguration getGenericDialog() {
        return this.genericDialog;
    }

    protected final void initialize() {
        if (this.genericDialog.isHeaderPanelVisible()) {
            this.headerPanel = new DialogHeaderPanel();
            this.dialog.getContentPane().add((Component)this.headerPanel.getContent(), "North");
        }
        this.dialog.getContentPane().add(this.createContentPanel(), "Center");
        this.dialog.getContentPane().add(this.createButtonBar(), "South");
    }

    private Component createContentPanel() {
        this.contentPanel = new JPanel(new GridLayout(0, 1));
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 8, 10, 8));
        JPanel p = new JPanel(new GridDialogLayout(1, false));
        GridDialogLayoutData data = new GridDialogLayoutData(GridDialogLayoutData.FILL_BOTH);
        data.setWidthHint(IDialogConstants.MINIMUM_CONTENT_SIZE.width);
        data.setHeightHint(IDialogConstants.MINIMUM_CONTENT_SIZE.height);
        p.add((Component)this.contentPanel, data);
        p.add((Component)new HorizontalLine(), GridDialogLayoutData.FILL_HORIZONTAL);
        return p;
    }

    protected abstract Component createButtonBar();

    protected abstract boolean cancelPressed();

    protected void closeDialog() {
        this.dialog.dispose();
    }

    public final void updateSize() {
        if (this.getContent() == null) {
            this.dialog.pack();
            return;
        }
        Dimension preferredSize = this.contentPanel.getPreferredSize();
        Dimension actualSize = this.contentPanel.getSize();
        if (preferredSize.width > actualSize.width || preferredSize.height > actualSize.height) {
            this.dialog.pack();
        }
    }

    protected final void setContent(JComponent content) {
        this.content = content;
        this.contentPanel.removeAll();
        this.contentPanel.add(content);
        this.contentPanel.revalidate();
    }

    protected final JComponent getContent() {
        return this.content;
    }

    protected final void setMessage(IBasicMessage message) {
        if (this.headerPanel != null) {
            this.headerPanel.setMessage(message);
        }
        this.dialog.validate();
        this.dialog.repaint();
        this.updateSize();
    }

    protected final void setDescription(String description) {
        if (this.headerPanel != null) {
            this.headerPanel.setDescription(description);
        }
    }

    protected final void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    protected final void setDefaultButton(JButton button) {
        this.dialog.getRootPane().setDefaultButton(button);
    }

    public final ISwingFrameOrDialog getDialog() {
        return this.dialog;
    }
}

