/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;

public final class IOUtilities {
    private IOUtilities() {
    }

    public static final void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static final void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static final void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static final void copyStream(InputStream in, OutputStream out) throws IOException {
        IOUtilities.copyStream(in, out, 4096);
    }

    public static final void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int numChars;
        byte[] buffer = new byte[bufferSize];
        while ((numChars = in.read(buffer)) > 0) {
            out.write(buffer, 0, numChars);
        }
    }

    static {
        new DecimalFormat("000");
        new DecimalFormat("00.0");
        new DecimalFormat("0.00");
        new DecimalFormat("0.000");
    }
}

