/*
 * Decompiled with CFR 0.152.
 */
package de.jave.undo;

import de.jave.jave.JaveStatusFile;
import de.jave.undo.LogFileManagerEntry;
import de.jave.util.Queue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.disy.commons.core.io.IOUtilities;

public final class LogFileManager
extends Thread {
    private static LogFileManager instance = new LogFileManager();
    private final Queue queue = new Queue();
    private boolean shallStop = false;

    public static final LogFileManager getInstance() {
        return instance;
    }

    public LogFileManager() {
        super("LogFileManager");
        this.setPriority(1);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        while (!this.shallStop) {
            LogFileManagerEntry objectToWrite = null;
            Queue queue = this.queue;
            synchronized (queue) {
                while (!this.shallStop && this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.queue.isEmpty()) {
                    objectToWrite = (LogFileManagerEntry)this.queue.get();
                }
            }
            if (objectToWrite == null) continue;
            this.write(objectToWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(LogFileManagerEntry entry) {
        String s = ((Object)entry.getUndoState()).toString();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(entry.getFile(), true));
            writer.write(s);
            writer.newLine();
            IOUtilities.close(writer);
            return;
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
            return;
        }
        finally {
            IOUtilities.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File createNewLogFile() throws IOException {
        File logFileFolder = JaveStatusFile.logDir;
        String logFileFileExtension = ".jlog";
        LogFileManager logFileManager = this;
        synchronized (logFileManager) {
            File file;
            if (!logFileFolder.exists()) {
                logFileFolder.mkdirs();
            }
            int r = (int)(Math.random() * 2.147483647E9);
            do {
                r = r < 0 ? -r : r;
                file = new File(logFileFolder, String.valueOf(r) + logFileFileExtension);
                ++r;
            } while (file.exists());
            file.createNewFile();
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(LogFileManagerEntry entry) {
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.put(entry);
            this.queue.notifyAll();
            return;
        }
    }
}

