/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Random;

public final class Toolbox {
    private static Random rand;

    private Toolbox() {
    }

    public static final String getDateString() {
        Calendar rightNow = Calendar.getInstance();
        int sec = rightNow.get(13);
        int min = rightNow.get(12);
        String secStr = sec < 10 ? "0" + sec : String.valueOf(sec);
        String minStr = min < 10 ? "0" + min : String.valueOf(min);
        String date = rightNow.get(1) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(5) + " " + rightNow.get(11) + ":" + minStr + ":" + secStr;
        return date;
    }

    public static final double round(double x, int length) {
        int mult = (int)Math.pow(10.0, length);
        return Math.rint(x * (double)mult) / (double)mult;
    }

    public static final int random(int min, int max) {
        if (rand == null) {
            rand = new Random();
        }
        return min + Math.abs(rand.nextInt()) % (max - min + 1);
    }

    public static final int compareToIgnoreCase(String s1, String s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int i1 = 0;
        for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
            char c2;
            char c1 = s1.charAt(i1);
            if (c1 == (c2 = s2.charAt(i2)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }

    public static final void quickSort(String[] s) {
        Arrays.sort(s);
    }

    public static final void quickSortIgnoreCase(String[] s) {
        Toolbox.qSortIgnoreCase(s, 0, s.length - 1);
    }

    private static void qSortIgnoreCase(String[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            String mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && Toolbox.compareToIgnoreCase(a[lo], mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && Toolbox.compareToIgnoreCase(a[hi], mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                String cache = a[lo];
                a[lo] = a[hi];
                a[hi] = cache;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Toolbox.qSortIgnoreCase(a, lo0, hi);
            }
            if (lo < hi0) {
                Toolbox.qSortIgnoreCase(a, lo, hi0);
            }
        }
    }

    public static final int abs(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static final int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static final int max(int a, int b, int c, int d) {
        return Toolbox.max(Toolbox.max(a, b), Toolbox.max(c, d));
    }
}

