/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib;

import de.jave.jave.ICharacterDrawable;
import de.jave.lib.CharacterPlateConfiguration;
import de.jave.text.TextTools;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import net.disy.commons.core.util.Ensure;

public final class CharacterPlate
implements ICharacterDrawable {
    private char[][] chars;
    private boolean mix;
    private Dimension size;

    public CharacterPlate(Dimension size) {
        this(size.width, size.height);
    }

    public CharacterPlate(int width, int height) {
        this.chars = new char[height][width];
        this.size = new Dimension(width, height);
        this.clear();
        this.mix = false;
    }

    public CharacterPlate(char[][] ch) {
        this.chars = ch;
        int height = this.chars.length;
        int width = height == 0 ? 0 : this.chars[0].length;
        this.size = new Dimension(width, height);
        this.mix = false;
    }

    public CharacterPlate(String text) {
        if (text.length() == 0) {
            this.size = new Dimension(0, 0);
            this.chars = new char[0][0];
        } else {
            this.chars = TextTools.toCharField(text);
            this.size = new Dimension(this.chars[0].length, this.chars.length);
        }
        this.mix = false;
    }

    public CharacterPlate(String[] text) {
        if (text == null || text.length == 0) {
            this.size = new Dimension(0, 0);
            this.chars = new char[0][0];
        } else {
            this.chars = TextTools.toCharField(text);
            this.size = new Dimension(this.chars[0].length, this.chars.length);
        }
        this.mix = false;
    }

    public final char[][] getContent() {
        return this.chars;
    }

    public final boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.size.width && y < this.size.height;
    }

    public final boolean equals(String pattern, int x, int y) {
        for (int i = 0; i < pattern.length(); ++i) {
            if (!this.contains(x + i, y)) {
                return false;
            }
            if (this.get(x + i, y) == pattern.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static final char[][] getClone(char[][] original) {
        int h = original.length;
        int w = h == 0 ? 0 : original[0].length;
        char[][] result = new char[h][w];
        for (int y = 0; y < h; ++y) {
            System.arraycopy(original[y], 0, result[y], 0, w);
        }
        return result;
    }

    public final CharacterPlate getCopy(Rectangle region) {
        return this.getCopy(region.x, region.y, region.width, region.height);
    }

    public final CharacterPlate getCopy(int x0, int y0, int width, int height) {
        Ensure.ensureArgumentTrue("height may not be less than 0, but was " + height, height >= 0);
        Ensure.ensureArgumentTrue("width may not be less than 0, but was " + width, width >= 0);
        char[][] sel = new char[height][width];
        for (int x = 0; x < width; ++x) {
            int xx = x + x0;
            for (int y = 0; y < height; ++y) {
                int yy = y + y0;
                sel[y][x] = xx >= 0 && xx < this.size.width && yy >= 0 && yy < this.size.height ? this.get(xx, yy) : (char)32;
            }
        }
        return new CharacterPlate(sel);
    }

    public final CharacterPlate getClone() {
        char[][] c = CharacterPlate.getClone(this.chars);
        return new CharacterPlate(c);
    }

    public static final CharacterPlate tabelize(String s) {
        int col;
        String[] lines = TextTools.toStringArray(s);
        int columnCount = 1;
        for (int i = 0; i < lines.length; ++i) {
            int currentColumnCount = 1 + TextTools.count(lines[i], '\t');
            if (currentColumnCount <= columnCount) continue;
            columnCount = currentColumnCount;
        }
        int[] columnWidths = new int[columnCount];
        for (int row = 0; row < lines.length; ++row) {
            col = 0;
            int oldIndex = 0;
            int index = lines[row].indexOf(9);
            while (index != -1) {
                if (columnWidths[col] < index - oldIndex) {
                    columnWidths[col] = index - oldIndex;
                }
                ++col;
                oldIndex = index;
                index = lines[row].indexOf(9, index + 1);
            }
            if (columnWidths[col] >= lines[row].length() - oldIndex) continue;
            columnWidths[col] = lines[row].length() - oldIndex;
        }
        int resultWidth = 0;
        for (col = 0; col < columnCount; ++col) {
            resultWidth += columnWidths[col] + 1;
        }
        CharacterPlate cp = new CharacterPlate(--resultWidth, lines.length);
        for (int row = 0; row < lines.length; ++row) {
            String cell;
            int col2 = 0;
            int x = 0;
            int oldIndex = 0;
            int index = lines[row].indexOf(9);
            while (index != -1) {
                cell = lines[row].substring(oldIndex, index);
                cp.paste(cell, x, row);
                x += columnWidths[col2] + 1;
                ++col2;
                oldIndex = index + 1;
                index = lines[row].indexOf(9, oldIndex);
            }
            cell = lines[row].substring(oldIndex);
            cp.paste(cell, x, row);
        }
        return cp;
    }

    public final boolean isEmpty() {
        return this.isEmpty(0, 0, this.size.width - 1, this.size.height - 1, ' ');
    }

    public final boolean isEmpty(int x0, int y0, int x1, int y1) {
        return this.isEmpty(x0, y0, x1, y1, ' ');
    }

    public final boolean isEmpty(int x0, int y0, int x1, int y1, char emptyChar) {
        for (int x = x0; x <= x1; ++x) {
            for (int y = y0; y <= y1; ++y) {
                if (this.chars[y][x] == emptyChar) continue;
                return false;
            }
        }
        return true;
    }

    public final int getNonEmptyCharCount() {
        int result = 0;
        for (int x = 0; x < this.size.width; ++x) {
            for (int y = 0; y < this.size.height; ++y) {
                if (this.chars[y][x] == ' ') continue;
                ++result;
            }
        }
        return result;
    }

    public final Insets getEmptyInsets() {
        return this.getEmptyInsets(' ');
    }

    public final Insets getEmptyInsets(char emptyChar) {
        int right;
        int left;
        int bottom;
        int top;
        for (top = 0; top < this.size.height && this.isEmpty(0, top, this.size.width - 1, top, emptyChar); ++top) {
        }
        for (bottom = 0; bottom < this.size.height && this.isEmpty(0, this.size.height - bottom - 1, this.size.width - 1, this.size.height - bottom - 1, emptyChar); ++bottom) {
        }
        for (left = 0; left < this.size.width && this.isEmpty(left, 0, left, this.size.height - 1, emptyChar); ++left) {
        }
        for (right = 0; right < this.size.width && this.isEmpty(this.size.width - right - 1, 0, this.size.width - right - 1, this.size.height - 1, emptyChar); ++right) {
        }
        return new Insets(top, left, bottom, right);
    }

    public final void setContent(char[][] ch) {
        this.chars = ch;
        this.size = new Dimension(this.chars[0].length, this.chars.length);
    }

    public final void setSize(int width, int height) {
        if (width == this.size.width && height == this.size.height) {
            return;
        }
        char[][] oldChars = this.chars;
        this.chars = new char[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.chars[y][x] = y < this.size.height && x < this.size.width ? oldChars[y][x] : 32;
            }
        }
        this.size = new Dimension(width, height);
    }

    public final void removeColumnsLeft(int count) {
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height][this.size.width - count];
        for (int y = 0; y < this.size.height; ++y) {
            for (int x = 0; x < this.size.width - count; ++x) {
                this.chars[y][x] = oldChars[y][x + count];
            }
        }
        this.size = new Dimension(this.size.width - count, this.size.height);
    }

    public final void removeColumnsRight(int count) {
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height][this.size.width - count];
        for (int y = 0; y < this.size.height; ++y) {
            for (int x = 0; x < this.size.width - count; ++x) {
                this.chars[y][x] = oldChars[y][x];
            }
        }
        this.size = new Dimension(this.size.width - count, this.size.height);
    }

    public final void removeLinesBottom(int count) {
        char[][] oldChars = this.chars;
        this.size = new Dimension(this.size.width, this.size.height - count);
        this.chars = new char[this.size.height][this.size.width];
        for (int y = 0; y < this.size.height; ++y) {
            this.chars[y] = oldChars[y];
        }
    }

    public final void removeLinesTop(int count) {
        char[][] oldChars = this.chars;
        this.size = new Dimension(this.size.width, this.size.height - count);
        this.chars = new char[this.size.height][this.size.width];
        for (int y = 0; y < this.size.height; ++y) {
            this.chars[y] = oldChars[y + count];
        }
    }

    public final void addLinesBottom(int count) {
        int x;
        int y;
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height + count][this.size.width];
        for (y = 0; y < this.size.height; ++y) {
            for (x = 0; x < this.size.width; ++x) {
                this.chars[y][x] = oldChars[y][x];
            }
        }
        for (y = 0; y < count; ++y) {
            for (x = 0; x < this.size.width; ++x) {
                this.chars[y + this.size.height][x] = 32;
            }
        }
        this.size = new Dimension(this.size.width, this.size.height + count);
    }

    public final void addLinesTop(int count) {
        int x;
        int y;
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height + count][this.size.width];
        for (y = 0; y < this.size.height; ++y) {
            for (x = 0; x < this.size.width; ++x) {
                this.chars[y + count][x] = oldChars[y][x];
            }
        }
        for (y = 0; y < count; ++y) {
            for (x = 0; x < this.size.width; ++x) {
                this.chars[y][x] = 32;
            }
        }
        this.size = new Dimension(this.size.width, this.size.height + count);
    }

    public final void addColumnsRight(int count) {
        int x;
        int y;
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height][this.size.width + count];
        for (y = 0; y < this.size.height; ++y) {
            for (x = 0; x < this.size.width; ++x) {
                this.chars[y][x] = oldChars[y][x];
            }
        }
        for (y = 0; y < this.size.height; ++y) {
            for (x = 0; x < count; ++x) {
                this.chars[y][x + this.size.width] = 32;
            }
        }
        this.size = new Dimension(this.size.width + count, this.size.height);
    }

    public final void addColumnsLeft(int count) {
        int x;
        int y;
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height][this.size.width + count];
        for (y = 0; y < this.size.height; ++y) {
            for (x = 0; x < this.size.width; ++x) {
                this.chars[y][x + count] = oldChars[y][x];
            }
        }
        for (y = 0; y < this.size.height; ++y) {
            for (x = 0; x < count; ++x) {
                this.chars[y][x] = 32;
            }
        }
        this.size = new Dimension(this.size.width + count, this.size.height);
    }

    public final void insertLine(int line, String text) {
        int y;
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height + 1][this.size.width];
        for (y = 0; y < line; ++y) {
            this.chars[y] = oldChars[y];
        }
        for (int x = 0; x < this.size.width; ++x) {
            this.chars[line][x] = x < text.length() ? text.charAt(x) : (char)32;
        }
        for (y = line; y < this.size.height; ++y) {
            this.chars[y + 1] = oldChars[y];
        }
        this.size = new Dimension(this.size.width, this.size.height + 1);
    }

    public final void removeLine(int line) {
        int y;
        char[][] oldChars = this.chars;
        this.chars = new char[this.size.height - 1][this.size.width];
        for (y = 0; y < line; ++y) {
            this.chars[y] = oldChars[y];
        }
        for (y = line + 1; y < this.size.height; ++y) {
            this.chars[y - 1] = oldChars[y];
        }
        this.size = new Dimension(this.size.width, this.size.height - 1);
    }

    public final String getLine(int lineNo) {
        return this.getLine(lineNo, 0);
    }

    public final String getLine(int lineNo, int xStart) {
        if (xStart == 0) {
            return new String(this.chars[lineNo]);
        }
        return new String(this.chars[lineNo], xStart, this.size.width - xStart);
    }

    public final boolean equals(Object other) {
        if (!(other instanceof CharacterPlate)) {
            return false;
        }
        CharacterPlate o = (CharacterPlate)other;
        if (o.getWidth() != this.getWidth()) {
            return false;
        }
        if (o.getHeight() != this.getHeight()) {
            return false;
        }
        for (int x = 0; x < this.size.width; ++x) {
            for (int y = 0; y < this.size.height; ++y) {
                if (this.chars[y][x] == o.chars[y][x]) continue;
                return false;
            }
        }
        return true;
    }

    public final void delete(int x0, int y0, int x1, int y1) {
        for (int x = x0; x <= x1; ++x) {
            this.chars[y0][x] = 32;
        }
        for (int y = y0 + 1; y <= y1; ++y) {
            System.arraycopy(this.chars[y0], x0, this.chars[y], x0, x1 - x0 + 1);
        }
    }

    public final void paste(String lineContent, int x, int y) {
        StringTokenizer st = new StringTokenizer(lineContent, "\n", false);
        while (st.hasMoreElements()) {
            char[] c = st.nextToken().toCharArray();
            System.arraycopy(c, 0, this.chars[y], x, c.length);
            ++y;
        }
    }

    public final void print() {
        System.out.println(this.toString());
    }

    public final String toString() {
        return TextTools.toString(this.chars);
    }

    public final String[] toStringArray() {
        return TextTools.toStringArray(this.chars);
    }

    public final void pasteInto(CharacterPlate plate, int x0, int y0) {
        for (int y = 0; y < this.size.height; ++y) {
            for (int x = 0; x < this.size.width; ++x) {
                if (this.chars[y][x] == ' ') continue;
                plate.set(x + x0, y + y0, this.chars[y][x]);
            }
        }
    }

    public final void pasteIntoForce(CharacterPlate plate, int x0, int y0) {
        int yStart = 0;
        int xStart = 0;
        if (x0 < 0) {
            xStart = -x0;
        }
        if (y0 < 0) {
            yStart = -y0;
        }
        int h = this.size.height;
        int w = this.size.width;
        if (x0 + w > plate.size.width) {
            w = plate.size.width - x0;
        }
        if (y0 + h > plate.size.height) {
            h = plate.size.height - y0;
        }
        for (int y = yStart; y < h; ++y) {
            System.arraycopy(this.chars[y], xStart, plate.chars[y + y0], x0 + xStart, w - xStart);
        }
    }

    public final void paste(char[][] ch, int x0, int y0) {
        int h = ch.length;
        if (h == 0) {
            return;
        }
        int w = ch[0].length;
        if (w == 0) {
            return;
        }
        this.paste(ch, x0, y0, w, h);
    }

    public final void paste(CharacterPlate ch, int x0, int y0, int w, int h) {
        this.paste(ch.getContent(), x0, y0, w, h);
    }

    public final void paste(char[][] ch, int x0, int y0, int w, int h) {
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                this.chars[y0 + y][x0 + x] = ch[y][x];
            }
        }
    }

    public final boolean isMix() {
        return this.mix;
    }

    public final void setMix(boolean what) {
        this.mix = what;
    }

    public final char get(int x, int y) {
        return this.chars[y][x];
    }

    public final void setForce(int x, int y, char ch) {
        if (ch == '\u0001') {
            char[] cArray = this.chars[y];
            int n = x;
            cArray[n] = (char)(cArray[n] % 255);
            char[] cArray2 = this.chars[y];
            int n2 = x;
            cArray2[n2] = (char)(cArray2[n2] + 255);
            return;
        }
        this.chars[y][x] = ch;
    }

    public final void fill(int x, int y, int w, int h, char ch) {
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                this.setForce(xx, yy, ch);
            }
        }
    }

    public final void set(int x, int y, char ch) {
        if (x < 0 || y < 0 || x >= this.size.width || y >= this.size.height) {
            return;
        }
        if (ch == '\u0001') {
            char[] cArray = this.chars[y];
            int n = x;
            cArray[n] = (char)(cArray[n] % 255);
            char[] cArray2 = this.chars[y];
            int n2 = x;
            cArray2[n2] = (char)(cArray2[n2] + 255);
            return;
        }
        if (this.chars[y][x] == ch) {
            return;
        }
        if (this.mix && ch == ' ') {
            return;
        }
        if (!this.mix || ch == ' ') {
            this.chars[y][x] = ch;
            return;
        }
        char[] mixRuleA = CharacterPlateConfiguration.getInstance().getMixRuleA();
        char[] mixRuleB = CharacterPlateConfiguration.getInstance().getMixRuleB();
        char[] mixRuleC = CharacterPlateConfiguration.getInstance().getMixRuleC();
        for (int i = 0; i < mixRuleA.length; ++i) {
            if ((mixRuleA[i] != this.chars[y][x] || mixRuleB[i] != ch) && (mixRuleB[i] != this.chars[y][x] || mixRuleA[i] != ch)) continue;
            this.chars[y][x] = mixRuleC[i];
            return;
        }
        this.chars[y][x] = ch;
    }

    public final char getPasteResult(char ch, int x, int y) {
        if (!this.mix || ch == ' ') {
            return ch;
        }
        char[] mixRuleA = CharacterPlateConfiguration.getInstance().getMixRuleA();
        char[] mixRuleB = CharacterPlateConfiguration.getInstance().getMixRuleB();
        char[] mixRuleC = CharacterPlateConfiguration.getInstance().getMixRuleC();
        for (int i = 0; i < mixRuleA.length; ++i) {
            if ((mixRuleA[i] != this.chars[y][x] || mixRuleB[i] != ch) && (mixRuleB[i] != this.chars[y][x] || mixRuleA[i] != ch)) continue;
            return mixRuleC[i];
        }
        return ch;
    }

    public final int getWidth() {
        return this.size.width;
    }

    public final int getHeight() {
        return this.size.height;
    }

    public final void clear() {
        if (this.size.height == 0) {
            return;
        }
        for (int x = 0; x < this.size.width; ++x) {
            this.chars[0][x] = 32;
        }
        for (int y = 1; y < this.size.height; ++y) {
            System.arraycopy(this.chars[0], 0, this.chars[y], 0, this.size.width);
        }
    }

    public final void replace(char ch, char chNew) {
        for (int y = 0; y < this.size.height; ++y) {
            for (int x = 0; x < this.size.width; ++x) {
                if (this.chars[y][x] != ch) continue;
                this.chars[y][x] = chNew;
            }
        }
    }

    public final void panLeft() {
        for (int y = 0; y < this.size.height; ++y) {
            char t = this.chars[y][0];
            System.arraycopy(this.chars[y], 1, this.chars[y], 0, this.size.width - 1);
            this.chars[y][this.size.width - 1] = t;
        }
    }

    public final void panRight() {
        for (int y = 0; y < this.size.height; ++y) {
            char t = this.chars[y][this.size.width - 1];
            System.arraycopy(this.chars[y], 0, this.chars[y], 1, this.size.width - 1);
            this.chars[y][0] = t;
        }
    }

    public final void panUp() {
        char[] t = new char[this.size.width];
        System.arraycopy(this.chars[0], 0, t, 0, this.size.width);
        for (int y = 1; y < this.size.height; ++y) {
            System.arraycopy(this.chars[y], 0, this.chars[y - 1], 0, this.size.width);
        }
        System.arraycopy(t, 0, this.chars[this.size.height - 1], 0, this.size.width);
    }

    public final void panDown() {
        char[] t = new char[this.size.width];
        System.arraycopy(this.chars[this.size.height - 1], 0, t, 0, this.size.width);
        for (int y = this.size.height - 1; y > 0; --y) {
            System.arraycopy(this.chars[y - 1], 0, this.chars[y], 0, this.size.width);
        }
        System.arraycopy(t, 0, this.chars[0], 0, this.size.width);
    }

    public final Dimension getSize() {
        return this.size;
    }

    public final void changeColumnsRight(int size) {
        if (size == 0) {
            return;
        }
        if (size < 0) {
            this.removeColumnsRight(-size);
            return;
        }
        this.addColumnsRight(size);
    }

    public final void changeLinesBottom(int size) {
        if (size == 0) {
            return;
        }
        if (size < 0) {
            this.removeLinesBottom(-size);
            return;
        }
        this.addLinesBottom(size);
    }

    public final void changeColumnsLeft(int size) {
        if (size == 0) {
            return;
        }
        if (size < 0) {
            this.removeColumnsLeft(-size);
            return;
        }
        this.addColumnsLeft(size);
    }

    public final void changeLinesTop(int size) {
        if (size == 0) {
            return;
        }
        if (size < 0) {
            this.removeLinesTop(-size);
            return;
        }
        this.addLinesTop(size);
    }
}

