/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib;

import java.awt.Insets;

public final class BooleanPlate {
    private boolean[][] plate;
    private int height = -1;
    private int width = -1;

    private BooleanPlate() {
    }

    public BooleanPlate(int width, int height) {
        this.width = width;
        this.height = height;
        this.plate = new boolean[height][width];
    }

    public BooleanPlate(String s) {
        char[] ch = s.toCharArray();
        int index = 0;
        this.width = 0;
        while (ch[index] != ' ') {
            this.width *= 10;
            this.width += ch[index++] - 48;
        }
        ++index;
        this.height = 0;
        while (ch[index] != ' ') {
            this.height *= 10;
            this.height += ch[index++] - 48;
        }
        this.plate = new boolean[this.height][this.width];
        int i = 0;
        while (index < ch.length) {
            int count;
            boolean state = (count = ch[index++] - 32) > 46;
            count %= 47;
            while (count > 0) {
                int x = i % this.width;
                int y = i / this.width;
                ++i;
                this.plate[y][x] = state;
                --count;
            }
        }
    }

    public final BooleanPlate getClone() {
        BooleanPlate b = new BooleanPlate();
        new BooleanPlate().width = this.width;
        b.height = this.height;
        b.plate = new boolean[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            System.arraycopy(this.plate[y], 0, b.plate[y], 0, this.width);
        }
        return b;
    }

    public final boolean[][] getContent() {
        return this.plate;
    }

    public final void pasteInto(BooleanPlate plate, int x0, int y0) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                plate.set(x + x0, y + y0, this.isSet(x, y));
            }
        }
    }

    public final String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.width + " " + this.height + " ");
        boolean state = this.plate[0][0];
        int count = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            int y = i / this.width;
            int x = i % this.width;
            if (this.plate[y][x] != state || count >= 46) {
                if (state) {
                    s.append((char)(count + 79));
                } else {
                    s.append((char)(count + 32));
                }
                state = this.plate[y][x];
                count = 1;
                continue;
            }
            ++count;
        }
        if (state) {
            s.append((char)(count + 79));
        } else {
            s.append((char)(count + 32));
        }
        return s.toString();
    }

    public final void setAll(boolean set) {
        if (this.height == 0) {
            return;
        }
        for (int x = 0; x < this.width; ++x) {
            this.plate[0][x] = set;
        }
        for (int y = 1; y < this.height; ++y) {
            System.arraycopy(this.plate[0], 0, this.plate[y], 0, this.width);
        }
    }

    public final boolean isSet(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            System.err.println("Warning: coordinates out of plate in BooleanPlate.isSet(" + x + "," + y + ")");
            return false;
        }
        return this.plate[y][x];
    }

    public final boolean isAllSet() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.plate[y][x]) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isEmpty() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.plate[y][x]) continue;
                return false;
            }
        }
        return true;
    }

    public final Insets getEmptyInsets(boolean empty) {
        int right;
        int left;
        int bottom;
        int top;
        for (top = 0; top < this.height && this.isEmpty(0, top, this.width - 1, top, empty); ++top) {
        }
        for (bottom = 0; bottom < this.height && this.isEmpty(0, this.height - bottom - 1, this.width - 1, this.height - bottom - 1, empty); ++bottom) {
        }
        for (left = 0; left < this.width && this.isEmpty(left, 0, left, this.height - 1, empty); ++left) {
        }
        for (right = 0; right < this.width && this.isEmpty(this.width - right - 1, 0, this.width - right - 1, this.height - 1, empty); ++right) {
        }
        return new Insets(top, left, bottom, right);
    }

    public final boolean isEmpty(int x0, int y0, int x1, int y1, boolean empty) {
        for (int x = x0; x <= x1; ++x) {
            for (int y = y0; y <= y1; ++y) {
                if (this.plate[y][x] == empty) continue;
                return false;
            }
        }
        return true;
    }

    public final void set(int x, int y, boolean set) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        this.plate[y][x] = set;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void removeLinesBottom(int count) {
        boolean[][] oldPlate = this.plate;
        this.height -= count;
        this.plate = new boolean[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            this.plate[y] = oldPlate[y];
        }
    }

    public final void removeLinesTop(int count) {
        boolean[][] oldPlate = this.plate;
        this.height -= count;
        this.plate = new boolean[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            this.plate[y] = oldPlate[y + count];
        }
    }

    public final void removeColumnsRight(int count) {
        boolean[][] oldPlate = this.plate;
        this.plate = new boolean[this.height][this.width - count];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width - count; ++x) {
                this.plate[y][x] = oldPlate[y][x];
            }
        }
        this.width -= count;
    }

    public final void removeColumnsLeft(int count) {
        boolean[][] oldPlate = this.plate;
        this.plate = new boolean[this.height][this.width - count];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width - count; ++x) {
                this.plate[y][x] = oldPlate[y][x + count];
            }
        }
        this.width -= count;
    }

    public final void addLinesBottom(int count, boolean set) {
        int x;
        int y;
        boolean[][] oldPlate = this.plate;
        this.plate = new boolean[this.height + count][this.width];
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.plate[y][x] = oldPlate[y][x];
            }
        }
        for (y = 0; y < count; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.plate[y + this.height][x] = set;
            }
        }
        this.height += count;
    }

    public final void addLinesTop(int count, boolean set) {
        int x;
        int y;
        boolean[][] oldPlate = this.plate;
        this.plate = new boolean[this.height + count][this.width];
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.plate[y + count][x] = oldPlate[y][x];
            }
        }
        for (y = 0; y < count; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.plate[y][x] = set;
            }
        }
        this.height += count;
    }

    public final void addColumnsRight(int count, boolean set) {
        int x;
        int y;
        boolean[][] oldPlate = this.plate;
        this.plate = new boolean[this.height][this.width + count];
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.plate[y][x] = oldPlate[y][x];
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < count; ++x) {
                this.plate[y][x + this.width] = set;
            }
        }
        this.width += count;
    }

    public final void addColumnsLeft(int count, boolean set) {
        int x;
        int y;
        boolean[][] oldPlate = this.plate;
        this.plate = new boolean[this.height][this.width + count];
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.plate[y][x + count] = oldPlate[y][x];
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < count; ++x) {
                this.plate[y][x] = set;
            }
        }
        this.width += count;
    }

    public final void setSize(int width, int height) {
        if (width == this.width && height == this.height) {
            return;
        }
        boolean[][] oldPlate = this.plate;
        this.plate = new boolean[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.plate[y][x] = y < this.height && x < this.width ? oldPlate[y][x] : false;
            }
        }
        this.width = width;
        this.height = height;
    }
}

