/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

import de.jave.jave.version.JaveVersion;
import de.jave.javeplayer.IPlayerControlBar;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.javeplayer.JavePlate;
import de.jave.javeplayer.JavePlayerConfiguration;
import de.jave.javeplayer.NullControlBar;
import de.jave.javeplayer.PlayerControlBar;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class JavePlayer
extends JPanel
implements Runnable {
    private final JavePlate plate;
    private JaveAnimationFile animationFile;
    private AudioClip audioClip;
    private int audioStart;
    private int currentFrameIndex;
    public static final String TITLE = "JavE Asciimation Player " + JaveVersion.getFullVersionNumber();
    public static final Color DEFAULT_BACKGROUND = Color.white;
    public static final Color DEFAULT_FOREGROUND = Color.black;
    private JTextField tfFrame;
    private JLabel lFps;
    private boolean reverse = false;
    private static final String[] STR_SPEEDS = new String[]{"Slowest (0.1x)", "Slower (0.2x)", "Slow (0.5x)", "Normal Speed (1x)", "Fast (1.3x)", "Faster (2x)", "Fastest (4x)", "As fast as possible"};
    private static final double[] DURATION_MULTIPLICATOR = new double[]{10.0, 5.0, 2.0, 1.0, 0.75, 0.5, 0.25, 0.0};
    private int sleepTime;
    private double durationMultiplicator = 1.0;
    private Thread thread;
    private boolean pause;
    private boolean shallStop;
    private final BooleanModel loop = new BooleanModel();
    private final DefaultBoundedRangeModel progressModel = new DefaultBoundedRangeModel();
    private final IPlayerControlBar controlBar;

    public JavePlayer() {
        this(JavePlayerConfiguration.DEFAULT_CONTROLS, false, false);
    }

    public JavePlayer(JavePlayerConfiguration configuration, boolean loop, boolean autostart) {
        this.loop.setValue(loop);
        this.setLayout(new BorderLayout(2, 2));
        this.plate = new JavePlate();
        this.plate.setBackground(DEFAULT_BACKGROUND);
        this.plate.setForeground(DEFAULT_FOREGROUND);
        this.plate.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent evt) {
                if (evt.isMetaDown()) {
                    return;
                }
                if (JavePlayer.this.thread == null) {
                    JavePlayer.this.doPlay();
                    return;
                }
                JavePlayer.this.doPause();
            }

            public final void mouseReleased(MouseEvent e) {
                if (!e.isMetaDown()) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                menu.add(new SmartAction(this, "About JavE Asciimation Player"){

                    protected final void execute(Component parentComponent) {
                        MessageDialogFactory.showMessageDialog(parentComponent, new Message(TITLE + " " + JaveVersion.getBuildDate(), MessageType.INFORMATION));
                    }
                });
                menu.show(JavePlayer.this.plate, e.getX(), e.getY());
            }
        });
        this.add((Component)this.plate, "Center");
        this.currentFrameIndex = 0;
        if (configuration == JavePlayerConfiguration.ALL_CONTROLS) {
            PlayerControlBar bar = new PlayerControlBar(this.progressModel, this, this.loop);
            this.controlBar = bar;
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(0, 1, 2, 2));
            p.add(this.createStatusBar());
            p.add(bar.getContent());
            this.add((Component)p, "South");
        } else if (configuration == JavePlayerConfiguration.DEFAULT_CONTROLS) {
            PlayerControlBar bar = new PlayerControlBar(this.progressModel, this, this.loop);
            this.controlBar = bar;
            this.add((Component)bar.getContent(), "South");
        } else {
            this.controlBar = new NullControlBar();
        }
        this.progressModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                JavePlayer.this.setFrame(JavePlayer.this.progressModel.getValue());
            }
        });
        this.updateProgress();
        this.addAncestorListener(new AncestorListener(){

            public final void ancestorMoved(AncestorEvent event) {
            }

            public final void ancestorRemoved(AncestorEvent event) {
                JavePlayer.this.doStop();
            }

            public final void ancestorAdded(AncestorEvent event) {
            }
        });
    }

    public final void run() {
        long timeStart = System.currentTimeMillis();
        this.pause = false;
        int fpsCounter = 0;
        long fpsTimerStart = System.currentTimeMillis();
        while (!this.shallStop && this.animationFile != null && (this.loop.getValue() || !this.reverse && this.currentFrameIndex < this.animationFile.getFrameCount() - 1 || this.reverse && this.currentFrameIndex > 0)) {
            long wait = (long)((double)this.sleepTime * this.durationMultiplicator) - (System.currentTimeMillis() - timeStart);
            if (wait > 0L) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (++fpsCounter % 10 == 0) {
                long delta = System.currentTimeMillis() - fpsTimerStart;
                fpsTimerStart = System.currentTimeMillis();
                double fps = 10000.0 / (double)delta;
                if (this.lFps != null) {
                    this.lFps.setText(String.valueOf((double)((int)(fps * 10.0)) / 10.0) + " fps");
                }
            }
            timeStart = System.currentTimeMillis();
            while (!this.shallStop && !this.plate.isRepainted()) {
                Thread.yield();
            }
            if (!this.pause && !this.shallStop) {
                this.doNext();
            }
            this.plate.getToolkit().sync();
        }
        this.thread = null;
    }

    public final void setAnimationFile(JaveAnimationFile animationFile) {
        this.doStop();
        this.animationFile = animationFile;
        this.currentFrameIndex = -1;
        this.plate.setStatusMessage(null);
        this.setFrame(0);
    }

    private void setFrame(int index) {
        if (index == this.currentFrameIndex) {
            return;
        }
        this.currentFrameIndex = index;
        this.updateProgress();
        if (this.currentFrameIndex < 0 || this.currentFrameIndex >= this.animationFile.getFrameCount()) {
            if (this.animationFile.getFrameCount() == 0) {
                this.plate.setStatusMessage("* Empty Animation *");
            }
            this.plate.setContent(null);
            this.plate.repaint();
            if (this.tfFrame != null) {
                this.tfFrame.setText("");
            }
            return;
        }
        JaveAnimationFrame currentFrame = this.animationFile.getFrame(this.currentFrameIndex);
        this.sleepTime = this.animationFile.getProperties().getFrameDuration();
        this.plate.setContent(currentFrame);
        this.plate.setBackground(this.animationFile.getProperties().getBackgroundColor());
        this.plate.setForeground(this.animationFile.getProperties().getForegroundColor());
        this.plate.repaint();
        if (this.tfFrame != null) {
            this.tfFrame.setText(this.currentFrameIndex + 1 + "/" + this.animationFile.getFrameCount());
        }
    }

    private void updateProgress() {
        if (this.animationFile != null) {
            this.progressModel.setMaximum(this.animationFile.getFrameCount() - 1);
        }
        this.progressModel.setMinimum(0);
        this.progressModel.setValue(this.currentFrameIndex);
        if (this.animationFile != null) {
            this.controlBar.setProgressToolTip("Frame " + (this.currentFrameIndex + 1) + " of " + this.animationFile.getFrameCount());
        }
        boolean navigationControlsEnabled = this.animationFile != null && this.animationFile.getFrameCount() > 1;
        this.controlBar.setEnabled(navigationControlsEnabled);
    }

    public final void doPlay() {
        this.currentFrameIndex = this.reverse ? this.animationFile.getFrameCount() - 1 : 0;
        this.setFrame(this.currentFrameIndex);
        if (this.thread != null) {
            this.shallStop = true;
            try {
                this.thread.interrupt();
                while (this.thread != null && this.thread.isAlive()) {
                    Thread.yield();
                }
            }
            catch (Exception exception) {}
        }
        this.thread = new Thread((Runnable)this, "Animator");
        this.thread.setPriority(1);
        this.shallStop = false;
        if (this.audioClip != null) {
            JaveAnimationFrame currentFrame;
            if (this.audioStart == 0) {
                this.audioClip.play();
            } else if (this.audioStart == 1) {
                this.audioClip.loop();
            } else if (this.audioStart == 2 && (currentFrame = this.animationFile.getFrame(this.currentFrameIndex)).isSoundTrigger()) {
                this.audioClip.play();
            }
        }
        this.thread.start();
    }

    public final void doPause() {
        boolean bl = this.pause = !this.pause;
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    public final void doStop() {
        if (this.thread != null) {
            this.shallStop = true;
            try {
                this.thread.interrupt();
                while (this.thread != null && this.thread.isAlive()) {
                    Thread.yield();
                }
            }
            catch (Exception exception) {}
            if (this.audioClip != null) {
                this.audioClip.stop();
            }
        }
    }

    public final void doPrev() {
        if (this.reverse) {
            if (this.currentFrameIndex < this.animationFile.getFrameCount() - 1) {
                this.setFrame(this.currentFrameIndex + 1);
                return;
            }
            if (this.loop.getValue()) {
                this.setFrame(0);
                return;
            }
        } else {
            if (this.currentFrameIndex > 0) {
                this.setFrame(this.currentFrameIndex - 1);
                return;
            }
            if (this.loop.getValue()) {
                this.setFrame(this.animationFile.getFrameCount() - 1);
            }
        }
    }

    public final void doNext() {
        if (this.reverse) {
            if (this.currentFrameIndex > 0) {
                this.setFrame(this.currentFrameIndex - 1);
                return;
            }
            if (this.loop.getValue()) {
                this.setFrame(this.animationFile.getFrameCount() - 1);
                return;
            }
        } else {
            JaveAnimationFrame currentFrame;
            if (this.currentFrameIndex < this.animationFile.getFrameCount() - 1) {
                this.setFrame(this.currentFrameIndex + 1);
            } else if (this.loop.getValue()) {
                this.setFrame(0);
            }
            if (this.audioClip != null && this.audioStart == 2 && (currentFrame = this.animationFile.getFrame(this.currentFrameIndex)).isSoundTrigger()) {
                this.audioClip.play();
            }
        }
    }

    public final void doZoomIn() {
        this.plate.zoomIn();
    }

    public final void doZoomOut() {
        this.plate.zoomOut();
    }

    private Component createStatusBar() {
        JPanel p = new JPanel();
        this.tfFrame = new JTextField(10);
        this.tfFrame.setEditable(false);
        p.add(new JLabel("Frame:"));
        p.add(this.tfFrame);
        final JCheckBox cbReverse = new JCheckBox("Reverse", false);
        cbReverse.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JavePlayer.this.reverse = cbReverse.isSelected();
            }
        });
        final JComboBox<String> chSpeed = new JComboBox<String>(STR_SPEEDS);
        chSpeed.setSelectedIndex(3);
        chSpeed.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JavePlayer.this.durationMultiplicator = DURATION_MULTIPLICATOR[chSpeed.getSelectedIndex()];
            }
        });
        this.durationMultiplicator = DURATION_MULTIPLICATOR[chSpeed.getSelectedIndex()];
        p.add(cbReverse);
        p.add(chSpeed);
        this.lFps = new JLabel("0.00 fps");
        p.add(this.lFps);
        return p;
    }
}

