/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.linealgorithmic;

import de.jave.jave.MixCharactersPanel;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.MouseCharacterPanel;
import de.jave.jave.tool.linealgorithmic.AlgorithmicLineStyle;
import de.jave.jave.tool.linealgorithmic.AlgorithmicLineStyleUi;
import de.jave.jave.tool.linealgorithmic.LineAlgorithmicOptions;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public final class LineAlgorithmicOptionsPanel {
    private final JComponent content;
    private final LineAlgorithmicOptions options;

    public LineAlgorithmicOptionsPanel(final LineAlgorithmicOptions options, BooleanModel mixCharactersModel, MouseCharacterModel mouseCharacterModel) {
        this.options = options;
        final JComboBox<AlgorithmicLineStyle> chMode = new JComboBox<AlgorithmicLineStyle>(AlgorithmicLineStyle.getAll());
        final MouseCharacterPanel mouseCharacterPanel = new MouseCharacterPanel(mouseCharacterModel);
        chMode.setRenderer(new ObjectUiListCellRenderer(new AlgorithmicLineStyleUi()));
        chMode.setSelectedItem(options.getStyle());
        chMode.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                options.setStyle((AlgorithmicLineStyle)chMode.getSelectedItem());
                LineAlgorithmicOptionsPanel.this.updateMouseCharactersPanelEnabled(mouseCharacterPanel);
            }
        });
        this.updateMouseCharactersPanelEnabled(mouseCharacterPanel);
        JPanel optionsPanel = new JPanel(new GridDialogLayout(2, false));
        optionsPanel.add((Component)new JLabel("Style:"), GridDialogLayoutData.RIGHT);
        optionsPanel.add(chMode);
        GridDialogLayoutData data = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        data.setHorizontalSpan(2);
        optionsPanel.add((Component)mouseCharacterPanel.getContent(), data);
        optionsPanel.add((Component)new MixCharactersPanel(mixCharactersModel).getContent(), data);
        this.content = optionsPanel;
    }

    private void updateMouseCharactersPanelEnabled(MouseCharacterPanel mouseCharacterPanel) {
        mouseCharacterPanel.setEnabled(this.options.getStyle() == AlgorithmicLineStyle.CHARACTERS);
    }

    public final JComponent getContent() {
        return this.content;
    }
}

