/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.rectangle;

import de.jave.gui.CharField;
import de.jave.gui.CharacterModel;
import de.jave.gui.layout.Gap;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.RectangleAlgorithm;
import de.jave.jave.algorithm.rectangle.RectangleStyle;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.MouseCharacterPanel;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class RectangleStylePanel
implements ItemListener,
ItemSelectable {
    private JComboBox chMode;
    private final CharField[] charFields;
    private final CharacterModel[] charModels;
    private MouseCharacterModel mouseCharacterModel;
    private transient ItemListener itemListener;
    private static final RectangleStyleItem USER_DEFINED = new RectangleStyleItem("User Defined", null);
    private final JComponent content;
    private final MouseCharacterPanel mouseCharacterPanel;

    public RectangleStylePanel(MouseCharacterModel mouseCharacterModel) {
        this.mouseCharacterModel = mouseCharacterModel;
        this.mouseCharacterPanel = new MouseCharacterPanel(mouseCharacterModel);
        RectangleStyle[] allStyles = RectangleStyle.getAll();
        RectangleStyleItem[] items = new RectangleStyleItem[allStyles.length + 1];
        for (int i = 0; i < allStyles.length; ++i) {
            items[i] = new RectangleStyleItem(allStyles[i].getPrintName(), allStyles[i]);
        }
        items[items.length - 1] = USER_DEFINED;
        this.chMode = new JComboBox<RectangleStyleItem>(items);
        this.chMode.setSelectedIndex(0);
        this.chMode.addItemListener(this);
        JPanel p1 = new JPanel(new GridDialogLayout(2, false));
        p1.add(new JLabel("Style:"));
        p1.add((Component)this.chMode, GridDialogLayoutData.FILL_HORIZONTAL);
        char[] chars = RectangleAlgorithm.getCharsForStyle(((RectangleStyleItem)this.chMode.getSelectedItem()).getStyle());
        this.charModels = new CharacterModel[8];
        this.charFields = new CharField[8];
        ChangeListener changeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                RectangleStylePanel.this.chMode.setSelectedItem(USER_DEFINED);
                RectangleAlgorithm.setUserDefinedChars(RectangleStylePanel.this.getCurrentChars());
                if (RectangleStylePanel.this.itemListener != null) {
                    RectangleStylePanel.this.itemListener.itemStateChanged(new ItemEvent(RectangleStylePanel.this, 701, null, 1));
                }
            }
        };
        for (int i = 0; i < 8; ++i) {
            this.charModels[i] = new CharacterModel(chars[i]);
            this.charFields[i] = new CharField(this.charModels[i]);
            this.charFields[i].setFont(JaveGlobalRessources.FONT_DEFAULT);
            this.charModels[i].addChangeListener(changeListener);
        }
        JPanel p2 = new JPanel(new GridDialogLayout(3, false, 0, 0));
        p2.add(this.charFields[0]);
        p2.add((Component)this.charFields[1], GridDialogLayoutData.FILL_HORIZONTAL);
        p2.add(this.charFields[2]);
        p2.add((Component)this.charFields[3], GridDialogLayoutData.FILL_VERTICAL);
        p2.add((Component)new Gap(55, 5), GridDialogLayoutData.FILL_BOTH);
        p2.add((Component)this.charFields[4], GridDialogLayoutData.FILL_VERTICAL);
        p2.add(this.charFields[5]);
        p2.add((Component)this.charFields[6], GridDialogLayoutData.FILL_HORIZONTAL);
        p2.add(this.charFields[7]);
        JPanel panel = new JPanel(new BorderLayout(2, 3));
        panel.add((Component)p1, "North");
        panel.add((Component)p2, "Center");
        panel.add((Component)this.mouseCharacterPanel.getContent(), "South");
        this.updateMouseCharacterPanelEnabled();
        mouseCharacterModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                RectangleStyle style = ((RectangleStyleItem)RectangleStylePanel.this.chMode.getSelectedItem()).getStyle();
                if (style == RectangleStyle.CHARACTERS) {
                    RectangleStylePanel.this.initializeTextFieldsFromMouseCharacter();
                }
            }
        });
        this.content = panel;
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public final synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public final boolean isUnderLineStyle() {
        return this.charModels[1].getCharacter() == '_';
    }

    public final void itemStateChanged(ItemEvent evt) {
        RectangleStyle style = ((RectangleStyleItem)this.chMode.getSelectedItem()).getStyle();
        if (style == RectangleStyle.CHARACTERS) {
            this.initializeTextFieldsFromMouseCharacter();
        } else {
            char[] ch = RectangleAlgorithm.getCharsForStyle(style);
            for (int i = 0; i < 8; ++i) {
                this.charModels[i].setCharacter(ch[i]);
                this.charFields[i].setEditable(true);
            }
        }
        this.updateMouseCharacterPanelEnabled();
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, null, 1));
        }
    }

    private void initializeTextFieldsFromMouseCharacter() {
        char ch = this.mouseCharacterModel.getCharacter1();
        for (int i = 0; i < 8; ++i) {
            this.charModels[i].setCharacter(ch);
            this.charFields[i].setEditable(false);
        }
    }

    private void updateMouseCharacterPanelEnabled() {
        this.mouseCharacterPanel.setEnabled(((RectangleStyleItem)this.chMode.getSelectedItem()).getStyle() == RectangleStyle.CHARACTERS);
    }

    public final void setStyle(RectangleStyle style) {
        for (int i = 0; i < this.chMode.getItemCount(); ++i) {
            if (((RectangleStyleItem)this.chMode.getItemAt(i)).getStyle() != style) continue;
            this.chMode.setSelectedIndex(i);
            break;
        }
        this.itemStateChanged(null);
    }

    public final char[] getCurrentChars() {
        char[] ch = new char[8];
        for (int i = 0; i < 8; ++i) {
            ch[i] = this.charModels[i].getCharacter();
        }
        return ch;
    }

    public final Object[] getSelectedObjects() {
        return new Object[]{this.getCurrentChars()};
    }

    private static final class RectangleStyleItem {
        private final RectangleStyle style;
        private final String printName;

        public RectangleStyleItem(String printName, RectangleStyle style) {
            Ensure.ensureArgumentNotNull(printName);
            this.printName = printName;
            this.style = style;
        }

        public final String getPrintName() {
            return this.printName;
        }

        public final RectangleStyle getStyle() {
            return this.style;
        }

        public final String toString() {
            return this.getPrintName();
        }
    }
}

