/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.plate;

import de.jave.jave.plate.IDocumentEditor;
import java.io.File;

public final class DocumentEditorTitleFactory {
    public static final String createShortEditorTitle(IDocumentEditor editor) {
        File file = editor.getFile();
        if (file == null) {
            return editor.getStopGapName();
        }
        return file.getName();
    }

    public static final String createEditorTabTitle(IDocumentEditor editor) {
        String title = DocumentEditorTitleFactory.createShortEditorTitle(editor);
        if (editor.isModified()) {
            return "*" + title;
        }
        return title;
    }

    public static final String createEditorFrameTitle(IDocumentEditor editor) {
        File file = editor.getFile();
        StringBuffer title = new StringBuffer("[");
        if (file != null) {
            title.append(file);
        } else {
            title.append(editor.getStopGapName());
        }
        if (editor.isModified()) {
            title.append(" *");
        }
        title.append("]");
        return title.toString();
    }
}

