/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.pattern;

import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.pattern.Pattern;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.disy.commons.core.io.IOUtilities;

public final class PatternList {
    public static final File PATTERN_FILE = new File(new File(JaveGlobalRessources.codeBase, "pattern"), "pattern.jcf");
    private final List patterns = new ArrayList();

    public final int getPatternCount() {
        return this.patterns.size();
    }

    public final Pattern getPattern(int index) {
        return (Pattern)this.patterns.get(index);
    }

    public final void delete(int index) {
        this.patterns.remove(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        this.patterns.clear();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(PATTERN_FILE));
            String s1 = null;
            String s2 = null;
            String s3 = null;
            while ((s1 = br.readLine()) != null) {
                if (s1.trim().length() == 0) continue;
                s2 = br.readLine();
                if (s2 == null) {
                    throw new Exception("Unexpected End of Pattern File '" + PATTERN_FILE + "' !");
                }
                s3 = br.readLine();
                if (s3 == null) {
                    throw new Exception("Unexpected End of Pattern File '" + PATTERN_FILE + "' !");
                }
                Pattern pattern = new Pattern(s1, s3, s2);
                this.patterns.add(pattern);
                br.readLine();
            }
        }
        catch (Exception e) {
            try {
                System.err.println("Error loading Pattern-File! " + e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
            IOUtilities.close(br);
        }
        IOUtilities.close(br);
        Collections.sort(this.patterns);
    }

    public final void add(Pattern pat) {
        this.patterns.add(pat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        BufferedWriter br = null;
        try {
            File file = PATTERN_FILE;
            br = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.patterns.size(); ++i) {
                Pattern pattern = (Pattern)this.patterns.get(i);
                br.write(pattern.getName());
                br.newLine();
                br.write(pattern.getAuthor());
                br.newLine();
                br.write(pattern.getCode());
                br.newLine();
                br.newLine();
            }
        }
        catch (Exception e) {
            try {
                System.err.println("Error saving Pattern-File! " + e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
            IOUtilities.close(br);
            return;
        }
        IOUtilities.close(br);
        return;
    }
}

